/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.Template;

public class MismatchedSizeException
extends RuntimeException {
    private static final String ERROR = "Mismatched col/row//array/vector lengths";

    public MismatchedSizeException() {
        super(ERROR);
    }

    public MismatchedSizeException(Matrix matrix, Matrix matrix2) {
        super("Mismatched matrix row or col sizes:  a: " + matrix.getNumRow() + " & b: " + matrix2.getNumRow() + " a: " + matrix.getNumCol() + " & b: " + matrix2.getNumCol());
    }

    public MismatchedSizeException(Vector vector, Vector vector2, int n) {
        super("Mismatched col/row//array/vector lengths a: " + vector.getSize() + " & b: " + vector2.getSize() + " at b_index " + n);
    }

    public MismatchedSizeException(Vector vector, Vector vector2) {
        super("Mismatched col/row//array/vector lengths a: " + vector.getSize() + " & b: " + vector2.getSize());
    }

    public MismatchedSizeException(LabelledVector labelledVector, LabelledVector labelledVector2) {
        super("Mismatched col/row//array/vector lengths a: " + labelledVector.getSize() + " & b: " + labelledVector2.getSize());
    }

    public MismatchedSizeException(Object[] objectArray, Object[] objectArray2, int n) {
        super("Mismatched col/row//array/vector lengths a: " + objectArray.length + " & b: " + objectArray2.length + " at b_index " + n);
    }

    public MismatchedSizeException(Object[] objectArray, Object[] objectArray2) {
        super("Mismatched col/row//array/vector lengths a: " + objectArray.length + " & b: " + objectArray2.length);
    }

    public MismatchedSizeException(String string, Object[] objectArray, String string2, Object[] objectArray2) {
        super("Mismatched col/row//array/vector lengths for " + string + ": " + objectArray.length + " & " + string2 + " :" + objectArray2.length);
    }

    public MismatchedSizeException(String string, int n, String string2, int n2) {
        super("Mismatched col/row//array/vector lengths for " + string + ": " + n + " & " + string2 + " :" + n2);
    }

    public MismatchedSizeException(Dataset dataset, Template template) {
        super("Mismatched col/row//array/vector lengths for Dataset " + dataset.getName() + ": " + dataset.getNumCol() + " & Template " + template.getName() + " :" + template.getNumItems());
    }
}

