/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.reports.NullSafeStringBuffer;
import edu.mit.broad.xbench.core.api.Application;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class Errors {
    private static final Logger klog = XLogger.getLogger(Errors.class);
    private List fErrors_as_strings;
    private List fErrors_as_throwables;
    private String fErrorName;

    public Errors() {
        this("ERROR(S)");
    }

    public Errors(String string) {
        this.fErrorName = string;
        this.fErrors_as_throwables = new ArrayList();
        this.fErrors_as_strings = new ArrayList();
    }

    public final String getName() {
        return this.fErrorName;
    }

    public final void add(String string, Set set) {
        NullSafeStringBuffer nullSafeStringBuffer = new NullSafeStringBuffer(true);
        nullSafeStringBuffer.append(string).append('\t').append(set, '\t');
        this.fErrors_as_strings.add(nullSafeStringBuffer.toString());
    }

    public final void add(String string) {
        if (!this.fErrors_as_strings.contains(string)) {
            this.fErrors_as_strings.add(string);
        }
    }

    public final void add(Throwable throwable) {
        this.fErrors_as_strings.add(Errors.getAsString(throwable));
        if (throwable != null && !(!this.fErrors_as_throwables.contains(throwable))) {
            this.fErrors_as_throwables.add(throwable);
        }
    }

    public final void add(String string, Throwable throwable) {
        this.fErrors_as_strings.add(string + "\n" + Errors.getAsString(throwable));
        if (throwable != null && !this.fErrors_as_throwables.contains(throwable)) {
            this.fErrors_as_throwables.add(throwable);
        }
    }

    public final boolean isEmpty() {
        boolean bl = this.fErrors_as_strings.isEmpty();
        if (!bl) {
            return bl;
        }
        return this.fErrors_as_throwables.isEmpty();
    }

    public final int getSize() {
        return this.fErrors_as_strings.size();
    }

    public final Throwable[] getErrors() {
        return this.fErrors_as_throwables.toArray(new Throwable[this.fErrors_as_throwables.size()]);
    }

    public final String getErrors(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("There were errors: ").append(this.fErrorName).append(" #:").append(this.fErrors_as_strings.size());
        if (bl) {
            stringBuffer.append("<br>");
        } else {
            stringBuffer.append("\n");
        }
        for (int i2 = 0; i2 < this.fErrors_as_strings.size(); ++i2) {
            stringBuffer.append(this.fErrors_as_strings.get(i2).toString());
            if (bl) {
                stringBuffer.append("<br>");
                continue;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public final void showMessageIfNotEmpty() {
        if (!this.isEmpty()) {
            Application.getWindowManager().showError(this);
        }
    }

    public final void warnIfNotEmpty() {
        if (!this.fErrors_as_strings.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("There were errors: ").append(this.fErrorName).append(" #:").append(this.fErrors_as_strings.size()).append("\n");
            for (int i2 = 0; i2 < this.fErrors_as_strings.size(); ++i2) {
                stringBuffer.append(this.fErrors_as_strings.get(i2).toString()).append('\n');
            }
            klog.warn(stringBuffer);
        }
    }

    public final void barfIfNotEmpty() {
        this.barfIfNotEmpty(null);
    }

    public final void barfIfNotEmpty(String string) {
        String string2 = this._barfIfNotEmpty_message(string);
        if (string2 != null) {
            throw new Exception(string2);
        }
    }

    private String _barfIfNotEmpty_message(String string) {
        if (string != null) {
            this.fErrorName = string;
        }
        if (!this.fErrors_as_strings.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("There were errors: ").append(this.fErrorName).append(" #:").append(this.fErrors_as_strings.size()).append("\n");
            for (int i2 = 0; i2 < this.fErrors_as_strings.size(); ++i2) {
                stringBuffer.append(this.fErrors_as_strings.get(i2).toString()).append('\n');
            }
            return stringBuffer.toString();
        }
        klog.info("NO error(s) for: " + this.fErrorName);
        return null;
    }

    public final void barfIfNotEmpty_IO() {
        this.barfIfNotEmpty_IO(null);
    }

    public final void barfIfNotEmpty_IO(String string) {
        String string2 = this._barfIfNotEmpty_message(string);
        if (string2 != null) {
            throw new IOException(string2);
        }
    }

    public final void barfIfNotEmptyRuntime() {
        this.barfIfNotEmptyRuntime(null);
    }

    public final void barfIfNotEmptyRuntime(String string) {
        if (!this.fErrors_as_strings.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string).append('\n');
            }
            stringBuffer.append("There were errors: ").append(this.fErrorName).append(" #:").append(this.fErrors_as_strings.size()).append("\n");
            for (int i2 = 0; i2 < this.fErrors_as_strings.size(); ++i2) {
                stringBuffer.append(this.fErrors_as_strings.get(i2).toString()).append('\n');
            }
            throw new RuntimeException(stringBuffer.toString());
        }
    }

    private static String getAsString(Throwable throwable) {
        if (throwable == null) {
            return "null exception";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

