/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape.view;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.swing.JideTabbedPane;
import edu.mit.broad.cytoscape.view.EnrichmentMapInputPanel$1;
import edu.mit.broad.cytoscape.view.EnrichmentMapInputPanel$2;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.viewers.AbstractViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import xapps.api.vtools.ParamSetFormForAFew;
import xtools.api.param.DirParam;
import xtools.api.param.Param;
import xtools.api.param.ReportCacheChooserParam;

public class EnrichmentMapInputPanel
extends AbstractViewer {
    public static final String NAME = "EnrichmentMapVisualizationWidget";
    public static final Icon ICON = JarResources.getIcon("enrichmentmap_logo.png");
    private ReportCacheChooserParam fReportParam;
    private DirParam fDirParam;
    private SortableTable sortableTable;
    private File curr_gseaResultDir;
    private EnrichmentDb curr_edb;
    private JComponent fFiller;
    private Component tableComponent;
    private EnrichmentMapInputPanel fInstance = this;
    private JideTabbedPane sharedTabbedPane;

    public EnrichmentMapInputPanel() {
        super(NAME, ICON, "Enrichment Map Visualization");
        this.jbInit();
    }

    private void jbInit() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new EnrichmentMapInputPanel$1(this));
        JButton jButton2 = new JButton("Load GSEA Results");
        jButton2.addActionListener(new EnrichmentMapInputPanel$2(this));
        this.fReportParam = new ReportCacheChooserParam("Select a GSEA result from the application cache", false);
        this.fDirParam = new DirParam("dir", "[ OR ] Locate a GSEA result folder from the file system", "[ OR ] Locate a GSEA report folder from the file system", false);
        Param[] paramArray = new Param[]{this.fReportParam, this.fDirParam};
        StringBuffer stringBuffer = EnrichmentMapInputPanel._createColStr();
        StringBuffer stringBuffer2 = EnrichmentMapInputPanel._createRowStr(paramArray);
        PanelBuilder panelBuilder = ParamSetFormForAFew.createPanelBuilder(stringBuffer, stringBuffer2);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 3;
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            GFieldPlusChooser gFieldPlusChooser = paramArray[i2].getSelectionComponent();
            if (paramArray[i2].isFileBased() && gFieldPlusChooser instanceof GDirFieldPlusChooser) {
                ((GDirFieldPlusChooser)gFieldPlusChooser).getTextField().setBackground(ParamSetFormForAFew.LIGHT_GREEN);
            }
            JLabel jLabel = new JLabel(paramArray[i2].getHtmlLabel_v3());
            ParamSetFormForAFew.enableToolTips(jLabel, paramArray[i2]);
            panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n));
            panelBuilder.add((Component)gFieldPlusChooser.getComponent(), cellConstraints.xy(3, n));
            n += 2;
        }
        panelBuilder.add((Component)new JLabel(""), cellConstraints.xy(1, n));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        panelBuilder.add((Component)jPanel, cellConstraints.xy(3, n));
        JPanel jPanel2 = panelBuilder.getPanel();
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)jPanel2, "North");
        this.fFiller = GuiHelper.createWaitingPlaceholder();
        this.add((Component)this.fFiller, "Center");
        this.revalidate();
    }

    public final String[] getSelectedResultNames() {
        int[] nArray = this.sortableTable.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = this.sortableTable.getModel().getValueAt(nArray[i2], 1).toString();
        }
        return stringArray;
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("220dlu,      4dlu,        250dlu,   4dlu,  40dlu");
    }

    private static StringBuffer _createRowStr(Param[] paramArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pref, 10dlu,");
        for (int i2 = 0; i2 < paramArray.length + 1; ++i2) {
            stringBuffer.append("pref, 5dlu");
            if (paramArray.length == i2 - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    static final /* synthetic */ ReportCacheChooserParam access$000(EnrichmentMapInputPanel enrichmentMapInputPanel) {
        return enrichmentMapInputPanel.fReportParam;
    }

    static final /* synthetic */ DirParam access$100(EnrichmentMapInputPanel enrichmentMapInputPanel) {
        return enrichmentMapInputPanel.fDirParam;
    }

    static final /* synthetic */ JideTabbedPane access$200(EnrichmentMapInputPanel enrichmentMapInputPanel) {
        return enrichmentMapInputPanel.sharedTabbedPane;
    }

    static final /* synthetic */ JideTabbedPane access$202(EnrichmentMapInputPanel enrichmentMapInputPanel, JideTabbedPane jideTabbedPane) {
        enrichmentMapInputPanel.sharedTabbedPane = jideTabbedPane;
        return enrichmentMapInputPanel.sharedTabbedPane;
    }

    static final /* synthetic */ JComponent access$300(EnrichmentMapInputPanel enrichmentMapInputPanel) {
        return enrichmentMapInputPanel.fFiller;
    }

    static final /* synthetic */ EnrichmentMapInputPanel access$400(EnrichmentMapInputPanel enrichmentMapInputPanel) {
        return enrichmentMapInputPanel.fInstance;
    }
}

