/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

public class ReaderWriterLock {
    protected int numActiveReaders = 0;
    protected int numWaitingReaders = 0;
    protected int numWaitingWriters = 0;
    protected boolean activeWriter = false;

    private final boolean allowReaderIn() {
        return this.numWaitingWriters == 0 && !this.activeWriter;
    }

    private final boolean allowWriterIn() {
        return this.numActiveReaders == 0 && !this.activeWriter;
    }

    public final synchronized void getReadLock() {
        ++this.numWaitingReaders;
        while (!this.allowReaderIn()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.numWaitingReaders;
        ++this.numActiveReaders;
    }

    public final synchronized void getWriteLock() {
        ++this.numWaitingWriters;
        while (!this.allowWriterIn()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.numWaitingWriters;
        this.activeWriter = true;
    }

    public final synchronized void releaseReadLock() {
        --this.numActiveReaders;
        this.notifyAll();
    }

    public final synchronized void releaseWriteLock() {
        this.activeWriter = false;
        this.notifyAll();
    }
}

