/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.RenderingHintsProxy;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.renderable.RenderContext;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.ROIShape;

public class RenderContextProxy
implements Serializable {
    private transient RenderContext renderContext;

    public RenderContextProxy(RenderContext renderContext) {
        this.renderContext = renderContext;
    }

    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        Shape shape;
        AffineTransform affineTransform = (AffineTransform)objectInputStream.readObject();
        ROIShape rOIShape = objectInputStream.readBoolean() ? (ROIShape)objectInputStream.readObject() : null;
        RenderingHintsProxy renderingHintsProxy = (RenderingHintsProxy)objectInputStream.readObject();
        RenderingHints renderingHints = renderingHintsProxy.getRenderingHints();
        Shape shape2 = shape = rOIShape == null ? null : rOIShape.getAsShape();
        this.renderContext = rOIShape == null && renderingHints.isEmpty() ? new RenderContext(affineTransform) : (rOIShape == null ? new RenderContext(affineTransform, renderingHints) : (renderingHints.isEmpty() ? new RenderContext(affineTransform, shape) : new RenderContext(affineTransform, shape, renderingHints)));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        AffineTransform affineTransform = this.renderContext.getTransform();
        RenderingHintsProxy renderingHintsProxy = new RenderingHintsProxy(this.renderContext.getRenderingHints());
        Shape shape = this.renderContext.getAreaOfInterest();
        objectOutputStream.writeObject(affineTransform);
        objectOutputStream.writeBoolean(shape != null);
        if (shape != null) {
            objectOutputStream.writeObject(new ROIShape(shape));
        }
        objectOutputStream.writeObject(renderingHintsProxy);
    }
}

