/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ColorModelProxy;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.NullPropertyTag;
import com.sun.media.jai.rmi.RMIImage;
import com.sun.media.jai.rmi.RasterProxy;
import com.sun.media.jai.rmi.RenderContextProxy;
import com.sun.media.jai.rmi.SampleModelProxy;
import com.sun.media.jai.rmi.SerializableRenderedImage;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class RMIImageImpl
implements RMIImage {
    public static final Object NULL_PROPERTY = new NullPropertyTag();
    private static long idCounter = 0L;
    private static Hashtable sources = null;
    private static Hashtable propertySources = null;

    public RMIImageImpl() {
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(String.valueOf(JaiI18N.getString("RMIImageImpl0")) + exception.getMessage());
        }
    }

    private static synchronized void addSource(Long l2, RenderedImage renderedImage, PropertySource propertySource) {
        if (sources == null) {
            sources = new Hashtable();
            propertySources = new Hashtable();
        }
        sources.put(l2, renderedImage);
        propertySources.put(l2, propertySource);
    }

    public final RasterProxy copyData(Long l2, Rectangle rectangle) {
        return this.getData(l2, rectangle);
    }

    public final void dispose(Long l2) {
        if (sources != null) {
            sources.remove(l2);
            propertySources.remove(l2);
        }
    }

    public final Rectangle getBounds(Long l2) {
        return RMIImageImpl.getSource(l2).getBounds();
    }

    public final ColorModelProxy getColorModel(Long l2) {
        return new ColorModelProxy(RMIImageImpl.getSource(l2).getColorModel());
    }

    public final RasterProxy getData(Long l2) {
        return new RasterProxy(RMIImageImpl.getSource(l2).getData());
    }

    public final RasterProxy getData(Long l2, Rectangle rectangle) {
        RasterProxy rasterProxy = null;
        if (rectangle == null) {
            rasterProxy = this.getData(l2);
        } else {
            rectangle = rectangle.intersection(this.getBounds(l2));
            rasterProxy = new RasterProxy(RMIImageImpl.getSource(l2).getData(rectangle));
        }
        return rasterProxy;
    }

    public final int getHeight(Long l2) {
        return RMIImageImpl.getSource(l2).getHeight();
    }

    public final int getMaxTileX(Long l2) {
        return RMIImageImpl.getSource(l2).getMaxTileX();
    }

    public final int getMaxTileY(Long l2) {
        return RMIImageImpl.getSource(l2).getMaxTileY();
    }

    public final int getMaxX(Long l2) {
        return RMIImageImpl.getSource(l2).getMaxX();
    }

    public final int getMaxY(Long l2) {
        return RMIImageImpl.getSource(l2).getMaxY();
    }

    public final int getMinTileX(Long l2) {
        return RMIImageImpl.getSource(l2).getMinTileX();
    }

    public final int getMinTileY(Long l2) {
        return RMIImageImpl.getSource(l2).getMinTileY();
    }

    public final int getMinX(Long l2) {
        return RMIImageImpl.getSource(l2).getMinX();
    }

    public final int getMinY(Long l2) {
        return RMIImageImpl.getSource(l2).getMinY();
    }

    public final int getNumXTiles(Long l2) {
        return RMIImageImpl.getSource(l2).getNumXTiles();
    }

    public final int getNumYTiles(Long l2) {
        return RMIImageImpl.getSource(l2).getNumYTiles();
    }

    public final Object getProperty(Long l2, String string) {
        PropertySource propertySource = RMIImageImpl.getPropertySource(l2);
        Object object = propertySource.getProperty(string);
        if (object == null || object.equals(Image.UndefinedProperty)) {
            object = NULL_PROPERTY;
        }
        return object;
    }

    public final String[] getPropertyNames(Long l2) {
        PropertySource propertySource = RMIImageImpl.getPropertySource(l2);
        return propertySource.getPropertyNames();
    }

    private static PropertySource getPropertySource(Long l2) {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (propertySources == null) break block2;
                Object v = propertySources.get(l2);
                var1_1 = v;
                if (v != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    public final synchronized Long getRemoteID() {
        return new Long(++idCounter);
    }

    public final SampleModelProxy getSampleModel(Long l2) {
        return new SampleModelProxy(RMIImageImpl.getSource(l2).getSampleModel());
    }

    private static PlanarImage getSource(Long l2) {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (sources == null) break block2;
                Object v = sources.get(l2);
                var1_1 = v;
                if (v != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    public final Vector getSources(Long l2) {
        Vector vector = RMIImageImpl.getSource(l2).getSources();
        int n = vector.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            RenderedImage renderedImage = (RenderedImage)vector.get(n2);
            if (!(renderedImage instanceof Serializable)) {
                if (!bl) {
                    vector = (Vector)vector.clone();
                }
                vector.set(n2, new SerializableRenderedImage(renderedImage, false));
            }
            ++n2;
        }
        return vector;
    }

    public final RasterProxy getTile(Long l2, int n, int n2) {
        return new RasterProxy(RMIImageImpl.getSource(l2).getTile(n, n2));
    }

    public final int getTileGridXOffset(Long l2) {
        return RMIImageImpl.getSource(l2).getTileGridXOffset();
    }

    public final int getTileGridYOffset(Long l2) {
        return RMIImageImpl.getSource(l2).getTileGridYOffset();
    }

    public final int getTileHeight(Long l2) {
        return RMIImageImpl.getSource(l2).getTileHeight();
    }

    public final int getTileWidth(Long l2) {
        return RMIImageImpl.getSource(l2).getTileWidth();
    }

    public final int getWidth(Long l2) {
        return RMIImageImpl.getSource(l2).getWidth();
    }

    public static final void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        String string = null;
        int n = 1099;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-host")) {
                string = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-port")) {
                n = Integer.parseInt(stringArray[++n2]);
            }
            ++n2;
        }
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(JaiI18N.getString("RMIImageImpl1")) + exception.getMessage());
                exception.printStackTrace();
            }
        }
        System.out.println(String.valueOf(JaiI18N.getString("RMIImageImpl3")) + " " + string + ":" + n);
        try {
            RMIImageImpl rMIImageImpl = new RMIImageImpl();
            String string2 = new String("rmi://" + string + ":" + n + "/" + "RemoteImageServer");
            System.out.println(String.valueOf(JaiI18N.getString("RMIImageImpl4")) + " \"" + string2 + "\".");
            Naming.rebind(string2, rMIImageImpl);
            System.out.println(JaiI18N.getString("RMIImageImpl5"));
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(JaiI18N.getString("RMIImageImpl0")) + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public final void setSource(Long l2, RenderedImage renderedImage) {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        RMIImageImpl.addSource(l2, planarImage, planarImage);
    }

    public final void setSource(Long l2, RenderableOp renderableOp, RenderContextProxy renderContextProxy) {
        RenderContext renderContext = renderContextProxy.getRenderContext();
        RenderedImage renderedImage = renderableOp.createRendering(renderContext);
        RMIImageImpl.addSource(l2, PlanarImage.wrapRenderedImage(renderedImage), renderableOp);
    }

    public final void setSource(Long l2, RenderedOp renderedOp) {
        RMIImageImpl.addSource(l2, renderedOp.getRendering(), renderedOp);
    }
}

