/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

public final class TranslateIntOpImage
extends OpImage {
    private int transX;
    private int transY;

    public TranslateIntOpImage(RenderedImage renderedImage, int n, int n2) {
        super(renderedImage, null, null, TranslateIntOpImage.layoutHelper(renderedImage, n, n2), false);
        this.transX = n;
        this.transY = n2;
    }

    public final Raster getTile(int n, int n2) {
        Raster raster = this.source0.getTile(n, n2);
        return raster.createTranslatedChild(this.tileXToX(n), this.tileYToY(n2));
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage, int n, int n2) {
        ImageLayout imageLayout = new ImageLayout(renderedImage.getMinX() + n, renderedImage.getMinY() + n2, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getTileGridXOffset() + n, renderedImage.getTileGridYOffset() + n2, renderedImage.getTileWidth(), renderedImage.getTileHeight(), renderedImage.getSampleModel(), renderedImage.getColorModel());
        return imageLayout;
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("TranslateIntOpImage0"));
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(-this.transX, -this.transY);
        return rectangle2;
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("TranslateIntOpImage0"));
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(this.transX, this.transY);
        return rectangle2;
    }
}

