/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;
import javax.media.jai.TileCache;

final class ScaleBicubicOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    private int[] tableDataHi = null;
    private int[] tableDataVi = null;
    private float[] tableDataHf = null;
    private float[] tableDataVf = null;
    private double[] tableDataHd = null;
    private double[] tableDataVd = null;
    private int precisionBits;
    private int round;
    private Rational half = new Rational(1L, 2L);
    InterpolationTable interpTable;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;
    int dwidth;
    int dheight;
    int[] xpos;
    int[] ypos;
    int[] xfracvalues;
    int[] yfracvalues;
    int srcPixelStride;
    int srcScanlineStride;

    public ScaleBicubicOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, f2, f3, f4, f5, interpolation, true);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.interpTable = (InterpolationTable)interpolation;
        this.one = 1 << this.subsampleBits;
        this.precisionBits = this.interpTable.getPrecisionBits();
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            byte[] byArray3 = byArray[n4];
            byte[] byArray4 = byArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 - this.srcScanlineStride;
                int n12 = n10 + this.srcScanlineStride;
                int n13 = n12 + this.srcScanlineStride;
                int n14 = 0;
                while (n14 < this.dwidth) {
                    int n15 = this.xfracvalues[n14];
                    int n16 = this.xpos[n14];
                    int n17 = n16 - this.srcPixelStride;
                    int n18 = n16 + this.srcPixelStride;
                    int n19 = n18 + this.srcPixelStride;
                    int n20 = byArray4[n17 + n11] & 0xFF;
                    int n21 = byArray4[n16 + n11] & 0xFF;
                    int n22 = byArray4[n18 + n11] & 0xFF;
                    int n23 = byArray4[n19 + n11] & 0xFF;
                    int n24 = byArray4[n17 + n10] & 0xFF;
                    int n25 = byArray4[n16 + n10] & 0xFF;
                    int n26 = byArray4[n18 + n10] & 0xFF;
                    int n27 = byArray4[n19 + n10] & 0xFF;
                    int n28 = byArray4[n17 + n12] & 0xFF;
                    int n29 = byArray4[n16 + n12] & 0xFF;
                    int n30 = byArray4[n18 + n12] & 0xFF;
                    int n31 = byArray4[n19 + n12] & 0xFF;
                    int n32 = byArray4[n17 + n13] & 0xFF;
                    int n33 = byArray4[n16 + n13] & 0xFF;
                    int n34 = byArray4[n18 + n13] & 0xFF;
                    int n35 = byArray4[n19 + n13] & 0xFF;
                    int n36 = 4 * n15;
                    int n37 = n36 + 1;
                    int n38 = n36 + 2;
                    int n39 = n36 + 3;
                    long l2 = (long)this.tableDataHi[n36] * (long)n20;
                    l2 += (long)this.tableDataHi[n37] * (long)n21;
                    l2 += (long)this.tableDataHi[n38] * (long)n22;
                    l2 += (long)this.tableDataHi[n39] * (long)n23;
                    long l3 = (long)this.tableDataHi[n36] * (long)n24;
                    l3 += (long)this.tableDataHi[n37] * (long)n25;
                    l3 += (long)this.tableDataHi[n38] * (long)n26;
                    l3 += (long)this.tableDataHi[n39] * (long)n27;
                    long l4 = (long)this.tableDataHi[n36] * (long)n28;
                    l4 += (long)this.tableDataHi[n37] * (long)n29;
                    l4 += (long)this.tableDataHi[n38] * (long)n30;
                    l4 += (long)this.tableDataHi[n39] * (long)n31;
                    long l5 = (long)this.tableDataHi[n36] * (long)n32;
                    l5 += (long)this.tableDataHi[n37] * (long)n33;
                    l5 += (long)this.tableDataHi[n38] * (long)n34;
                    l5 += (long)this.tableDataHi[n39] * (long)n35;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    int n40 = 4 * n9;
                    long l6 = (long)this.tableDataVi[n40] * l2;
                    l6 += (long)this.tableDataVi[n40 + 1] * l3;
                    l6 += (long)this.tableDataVi[n40 + 2] * l4;
                    int n41 = (int)((l6 += (long)this.tableDataVi[n40 + 3] * l5) + (long)this.round >> this.precisionBits);
                    if (n41 > 255) {
                        n41 = 255;
                    } else if (n41 < 0) {
                        n41 = 0;
                    }
                    byArray3[n8] = (byte)(n41 & 0xFF);
                    n8 += n2;
                    ++n14;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        this.dwidth = rectangle.width;
        this.dheight = rectangle.height;
        this.srcPixelStride = rasterAccessor.getPixelStride();
        this.srcScanlineStride = rasterAccessor.getScanlineStride();
        this.ypos = new int[this.dheight];
        this.xpos = new int[this.dwidth];
        this.yfracvalues = new int[this.dheight];
        this.xfracvalues = new int[this.dwidth];
        long l2 = n4;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n5 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n5 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        long l7 = n3;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n6 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n6 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n7 = 0;
        while (n7 < this.dwidth) {
            this.xpos[n7] = (n6 - n) * this.srcPixelStride;
            this.xfracvalues[n7] = (int)((float)l9 / (float)l10 * (float)this.one);
            n6 = (int)((long)n6 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n6;
                l9 -= l10;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.dheight) {
            this.ypos[n8] = (n5 - n2) * this.srcScanlineStride;
            this.yfracvalues[n8] = (int)((float)l4 / (float)l5 * (float)this.one);
            n5 = (int)((long)n5 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n5;
                l4 -= l5;
            }
            ++n8;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                if (this.tableDataHi == null || this.tableDataVi == null) {
                    this.tableDataHi = this.interpTable.getHorizontalTableData();
                    this.tableDataVi = this.interpTable.getVerticalTableData();
                }
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 2: {
                if (this.tableDataHi == null || this.tableDataVi == null) {
                    this.tableDataHi = this.interpTable.getHorizontalTableData();
                    this.tableDataVi = this.interpTable.getVerticalTableData();
                }
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 1: {
                if (this.tableDataHi == null || this.tableDataVi == null) {
                    this.tableDataHi = this.interpTable.getHorizontalTableData();
                    this.tableDataVi = this.interpTable.getVerticalTableData();
                }
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 3: {
                if (this.tableDataHi == null || this.tableDataVi == null) {
                    this.tableDataHi = this.interpTable.getHorizontalTableData();
                    this.tableDataVi = this.interpTable.getVerticalTableData();
                }
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 4: {
                if (this.tableDataHf == null || this.tableDataVf == null) {
                    this.tableDataHf = this.interpTable.getHorizontalTableDataFloat();
                    this.tableDataVf = this.interpTable.getVerticalTableDataFloat();
                }
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 5: {
                if (this.tableDataHd == null || this.tableDataVd == null) {
                    this.tableDataHd = this.interpTable.getHorizontalTableDataDouble();
                    this.tableDataVd = this.interpTable.getVerticalTableDataDouble();
                }
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            double[] dArray3 = dArray[n4];
            double[] dArray4 = dArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 - this.srcScanlineStride;
                int n12 = n10 + this.srcScanlineStride;
                int n13 = n12 + this.srcScanlineStride;
                int n14 = 0;
                while (n14 < this.dwidth) {
                    int n15 = this.xfracvalues[n14];
                    int n16 = this.xpos[n14];
                    int n17 = n16 - this.srcPixelStride;
                    int n18 = n16 + this.srcPixelStride;
                    int n19 = n18 + this.srcPixelStride;
                    double d2 = dArray4[n17 + n11];
                    double d3 = dArray4[n16 + n11];
                    double d4 = dArray4[n18 + n11];
                    double d5 = dArray4[n19 + n11];
                    double d6 = dArray4[n17 + n10];
                    double d7 = dArray4[n16 + n10];
                    double d8 = dArray4[n18 + n10];
                    double d9 = dArray4[n19 + n10];
                    double d10 = dArray4[n17 + n12];
                    double d11 = dArray4[n16 + n12];
                    double d12 = dArray4[n18 + n12];
                    double d13 = dArray4[n19 + n12];
                    double d14 = dArray4[n17 + n13];
                    double d15 = dArray4[n16 + n13];
                    double d16 = dArray4[n18 + n13];
                    double d17 = dArray4[n19 + n13];
                    int n20 = 4 * n15;
                    int n21 = n20 + 1;
                    int n22 = n20 + 2;
                    int n23 = n20 + 3;
                    double d18 = this.tableDataHd[n20] * d2;
                    d18 += this.tableDataHd[n21] * d3;
                    d18 += this.tableDataHd[n22] * d4;
                    d18 += this.tableDataHd[n23] * d5;
                    double d19 = this.tableDataHd[n20] * d6;
                    d19 += this.tableDataHd[n21] * d7;
                    d19 += this.tableDataHd[n22] * d8;
                    d19 += this.tableDataHd[n23] * d9;
                    double d20 = this.tableDataHd[n20] * d10;
                    d20 += this.tableDataHd[n21] * d11;
                    d20 += this.tableDataHd[n22] * d12;
                    d20 += this.tableDataHd[n23] * d13;
                    double d21 = this.tableDataHd[n20] * d14;
                    d21 += this.tableDataHd[n21] * d15;
                    d21 += this.tableDataHd[n22] * d16;
                    int n24 = 4 * n9;
                    double d22 = this.tableDataVd[n24] * d18;
                    d22 += this.tableDataVd[n24 + 1] * d19;
                    d22 += this.tableDataVd[n24 + 2] * d20;
                    dArray3[n8] = d22 += this.tableDataVd[n24 + 3] * (d21 += this.tableDataHd[n23] * d17);
                    n8 += n2;
                    ++n14;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            float[] fArray3 = fArray[n4];
            float[] fArray4 = fArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 - this.srcScanlineStride;
                int n12 = n10 + this.srcScanlineStride;
                int n13 = n12 + this.srcScanlineStride;
                int n14 = 0;
                while (n14 < this.dwidth) {
                    int n15 = this.xfracvalues[n14];
                    int n16 = this.xpos[n14];
                    int n17 = n16 - this.srcPixelStride;
                    int n18 = n16 + this.srcPixelStride;
                    int n19 = n18 + this.srcPixelStride;
                    float f2 = fArray4[n17 + n11];
                    float f3 = fArray4[n16 + n11];
                    float f4 = fArray4[n18 + n11];
                    float f5 = fArray4[n19 + n11];
                    float f6 = fArray4[n17 + n10];
                    float f7 = fArray4[n16 + n10];
                    float f8 = fArray4[n18 + n10];
                    float f9 = fArray4[n19 + n10];
                    float f10 = fArray4[n17 + n12];
                    float f11 = fArray4[n16 + n12];
                    float f12 = fArray4[n18 + n12];
                    float f13 = fArray4[n19 + n12];
                    float f14 = fArray4[n17 + n13];
                    float f15 = fArray4[n16 + n13];
                    float f16 = fArray4[n18 + n13];
                    float f17 = fArray4[n19 + n13];
                    int n20 = 4 * n15;
                    int n21 = n20 + 1;
                    int n22 = n20 + 2;
                    int n23 = n20 + 3;
                    double d2 = this.tableDataHf[n20] * f2;
                    d2 += (double)(this.tableDataHf[n21] * f3);
                    d2 += (double)(this.tableDataHf[n22] * f4);
                    d2 += (double)(this.tableDataHf[n23] * f5);
                    double d3 = this.tableDataHf[n20] * f6;
                    d3 += (double)(this.tableDataHf[n21] * f7);
                    d3 += (double)(this.tableDataHf[n22] * f8);
                    d3 += (double)(this.tableDataHf[n23] * f9);
                    double d4 = this.tableDataHf[n20] * f10;
                    d4 += (double)(this.tableDataHf[n21] * f11);
                    d4 += (double)(this.tableDataHf[n22] * f12);
                    d4 += (double)(this.tableDataHf[n23] * f13);
                    double d5 = this.tableDataHf[n20] * f14;
                    d5 += (double)(this.tableDataHf[n21] * f15);
                    d5 += (double)(this.tableDataHf[n22] * f16);
                    d5 += (double)(this.tableDataHf[n23] * f17);
                    int n24 = 4 * n9;
                    double d6 = (double)this.tableDataVf[n24] * d2;
                    d6 += (double)this.tableDataVf[n24 + 1] * d3;
                    d6 += (double)this.tableDataVf[n24 + 2] * d4;
                    if ((d6 += (double)this.tableDataVf[n24 + 3] * d5) > 3.4028234663852886E38) {
                        d6 = 3.4028234663852886E38;
                    } else if (d6 < -3.4028234663852886E38) {
                        d6 = -3.4028234663852886E38;
                    }
                    fArray3[n8] = (float)d6;
                    n8 += n2;
                    ++n14;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            int[] nArray5 = nArray[n4];
            int[] nArray6 = nArray3[n4];
            int n5 = nArray2[n4];
            int n6 = nArray4[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                long l2 = this.yfracvalues[n7];
                int n9 = this.ypos[n7] + n6;
                int n10 = n9 - this.srcScanlineStride;
                int n11 = n9 + this.srcScanlineStride;
                int n12 = n11 + this.srcScanlineStride;
                int n13 = 0;
                while (n13 < this.dwidth) {
                    int n14;
                    long l3 = this.xfracvalues[n13];
                    int n15 = this.xpos[n13];
                    int n16 = n15 - this.srcPixelStride;
                    int n17 = n15 + this.srcPixelStride;
                    int n18 = n17 + this.srcPixelStride;
                    int n19 = nArray6[n16 + n10];
                    int n20 = nArray6[n15 + n10];
                    int n21 = nArray6[n17 + n10];
                    int n22 = nArray6[n18 + n10];
                    int n23 = nArray6[n16 + n9];
                    int n24 = nArray6[n15 + n9];
                    int n25 = nArray6[n17 + n9];
                    int n26 = nArray6[n18 + n9];
                    int n27 = nArray6[n16 + n11];
                    int n28 = nArray6[n15 + n11];
                    int n29 = nArray6[n17 + n11];
                    int n30 = nArray6[n18 + n11];
                    int n31 = nArray6[n16 + n12];
                    int n32 = nArray6[n15 + n12];
                    int n33 = nArray6[n17 + n12];
                    int n34 = nArray6[n18 + n12];
                    int n35 = (int)(4L * l3);
                    int n36 = n35 + 1;
                    int n37 = n35 + 2;
                    int n38 = n35 + 3;
                    long l4 = (long)this.tableDataHi[n35] * (long)n19;
                    l4 += (long)this.tableDataHi[n36] * (long)n20;
                    l4 += (long)this.tableDataHi[n37] * (long)n21;
                    l4 += (long)this.tableDataHi[n38] * (long)n22;
                    long l5 = (long)this.tableDataHi[n35] * (long)n23;
                    l5 += (long)this.tableDataHi[n36] * (long)n24;
                    l5 += (long)this.tableDataHi[n37] * (long)n25;
                    l5 += (long)this.tableDataHi[n38] * (long)n26;
                    long l6 = (long)this.tableDataHi[n35] * (long)n27;
                    l6 += (long)this.tableDataHi[n36] * (long)n28;
                    l6 += (long)this.tableDataHi[n37] * (long)n29;
                    l6 += (long)this.tableDataHi[n38] * (long)n30;
                    long l7 = (long)this.tableDataHi[n35] * (long)n31;
                    l7 += (long)this.tableDataHi[n36] * (long)n32;
                    l7 += (long)this.tableDataHi[n37] * (long)n33;
                    l7 += (long)this.tableDataHi[n38] * (long)n34;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    l6 = l6 + (long)this.round >> this.precisionBits;
                    l7 = l7 + (long)this.round >> this.precisionBits;
                    int n39 = (int)(4L * l2);
                    long l8 = (long)this.tableDataVi[n39] * l4;
                    l8 += (long)this.tableDataVi[n39 + 1] * l5;
                    l8 += (long)this.tableDataVi[n39 + 2] * l6;
                    nArray5[n8] = n14 = (int)((l8 += (long)this.tableDataVi[n39 + 3] * l7) + (long)this.round >> this.precisionBits);
                    n8 += n2;
                    ++n13;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            short[] sArray3 = sArray[n4];
            short[] sArray4 = sArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 - this.srcScanlineStride;
                int n12 = n10 + this.srcScanlineStride;
                int n13 = n12 + this.srcScanlineStride;
                int n14 = 0;
                while (n14 < this.dwidth) {
                    int n15 = this.xfracvalues[n14];
                    int n16 = this.xpos[n14];
                    int n17 = n16 - this.srcPixelStride;
                    int n18 = n16 + this.srcPixelStride;
                    int n19 = n18 + this.srcPixelStride;
                    short s = sArray4[n17 + n11];
                    short s2 = sArray4[n16 + n11];
                    short s3 = sArray4[n18 + n11];
                    short s4 = sArray4[n19 + n11];
                    short s5 = sArray4[n17 + n10];
                    short s6 = sArray4[n16 + n10];
                    short s7 = sArray4[n18 + n10];
                    short s8 = sArray4[n19 + n10];
                    short s9 = sArray4[n17 + n12];
                    short s10 = sArray4[n16 + n12];
                    short s11 = sArray4[n18 + n12];
                    short s12 = sArray4[n19 + n12];
                    short s13 = sArray4[n17 + n13];
                    short s14 = sArray4[n16 + n13];
                    short s15 = sArray4[n18 + n13];
                    short s16 = sArray4[n19 + n13];
                    int n20 = 4 * n15;
                    int n21 = n20 + 1;
                    int n22 = n20 + 2;
                    int n23 = n20 + 3;
                    long l2 = (long)this.tableDataHi[n20] * (long)s;
                    l2 += (long)this.tableDataHi[n21] * (long)s2;
                    l2 += (long)this.tableDataHi[n22] * (long)s3;
                    l2 += (long)this.tableDataHi[n23] * (long)s4;
                    long l3 = (long)this.tableDataHi[n20] * (long)s5;
                    l3 += (long)this.tableDataHi[n21] * (long)s6;
                    l3 += (long)this.tableDataHi[n22] * (long)s7;
                    l3 += (long)this.tableDataHi[n23] * (long)s8;
                    long l4 = (long)this.tableDataHi[n20] * (long)s9;
                    l4 += (long)this.tableDataHi[n21] * (long)s10;
                    l4 += (long)this.tableDataHi[n22] * (long)s11;
                    l4 += (long)this.tableDataHi[n23] * (long)s12;
                    long l5 = (long)this.tableDataHi[n20] * (long)s13;
                    l5 += (long)this.tableDataHi[n21] * (long)s14;
                    l5 += (long)this.tableDataHi[n22] * (long)s15;
                    l5 += (long)this.tableDataHi[n23] * (long)s16;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    int n24 = 4 * n9;
                    long l6 = (long)this.tableDataVi[n24] * l2;
                    l6 += (long)this.tableDataVi[n24 + 1] * l3;
                    l6 += (long)this.tableDataVi[n24 + 2] * l4;
                    int n25 = (int)((l6 += (long)this.tableDataVi[n24 + 3] * l5) + (long)this.round >> this.precisionBits);
                    if (n25 > Short.MAX_VALUE) {
                        n25 = Short.MAX_VALUE;
                    } else if (n25 < Short.MIN_VALUE) {
                        n25 = Short.MIN_VALUE;
                    }
                    sArray3[n8] = (short)n25;
                    n8 += n2;
                    ++n14;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            short[] sArray3 = sArray[n4];
            short[] sArray4 = sArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 - this.srcScanlineStride;
                int n12 = n10 + this.srcScanlineStride;
                int n13 = n12 + this.srcScanlineStride;
                int n14 = 0;
                while (n14 < this.dwidth) {
                    int n15 = this.xfracvalues[n14];
                    int n16 = this.xpos[n14];
                    int n17 = n16 - this.srcPixelStride;
                    int n18 = n16 + this.srcPixelStride;
                    int n19 = n18 + this.srcPixelStride;
                    int n20 = sArray4[n17 + n11] & 0xFFFF;
                    int n21 = sArray4[n16 + n11] & 0xFFFF;
                    int n22 = sArray4[n18 + n11] & 0xFFFF;
                    int n23 = sArray4[n19 + n11] & 0xFFFF;
                    int n24 = sArray4[n17 + n10] & 0xFFFF;
                    int n25 = sArray4[n16 + n10] & 0xFFFF;
                    int n26 = sArray4[n18 + n10] & 0xFFFF;
                    int n27 = sArray4[n19 + n10] & 0xFFFF;
                    int n28 = sArray4[n17 + n12] & 0xFFFF;
                    int n29 = sArray4[n16 + n12] & 0xFFFF;
                    int n30 = sArray4[n18 + n12] & 0xFFFF;
                    int n31 = sArray4[n19 + n12] & 0xFFFF;
                    int n32 = sArray4[n17 + n13] & 0xFFFF;
                    int n33 = sArray4[n16 + n13] & 0xFFFF;
                    int n34 = sArray4[n18 + n13] & 0xFFFF;
                    int n35 = sArray4[n19 + n13] & 0xFFFF;
                    int n36 = 4 * n15;
                    int n37 = n36 + 1;
                    int n38 = n36 + 2;
                    int n39 = n36 + 3;
                    long l2 = (long)this.tableDataHi[n36] * (long)n20;
                    l2 += (long)this.tableDataHi[n37] * (long)n21;
                    l2 += (long)this.tableDataHi[n38] * (long)n22;
                    l2 += (long)this.tableDataHi[n39] * (long)n23;
                    long l3 = (long)this.tableDataHi[n36] * (long)n24;
                    l3 += (long)this.tableDataHi[n37] * (long)n25;
                    l3 += (long)this.tableDataHi[n38] * (long)n26;
                    l3 += (long)this.tableDataHi[n39] * (long)n27;
                    long l4 = (long)this.tableDataHi[n36] * (long)n28;
                    l4 += (long)this.tableDataHi[n37] * (long)n29;
                    l4 += (long)this.tableDataHi[n38] * (long)n30;
                    l4 += (long)this.tableDataHi[n39] * (long)n31;
                    long l5 = (long)this.tableDataHi[n36] * (long)n32;
                    l5 += (long)this.tableDataHi[n37] * (long)n33;
                    l5 += (long)this.tableDataHi[n38] * (long)n34;
                    l5 += (long)this.tableDataHi[n39] * (long)n35;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    int n40 = 4 * n9;
                    long l6 = (long)this.tableDataVi[n40] * l2;
                    l6 += (long)this.tableDataVi[n40 + 1] * l3;
                    l6 += (long)this.tableDataVi[n40 + 2] * l4;
                    int n41 = (int)((l6 += (long)this.tableDataVi[n40 + 3] * l5) + (long)this.round >> this.precisionBits);
                    if (n41 > 65536) {
                        n41 = 65536;
                    } else if (n41 < 0) {
                        n41 = 0;
                    }
                    sArray3[n8] = (short)(n41 & 0xFFFF);
                    n8 += n2;
                    ++n14;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }
}

