/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;
import javax.media.jai.UntiledOpImage;

final class ErrorDiffusionOpImage
extends UntiledOpImage {
    private static final float FLOAT_EPSILON = 1.1920929E-7f;
    private static final int NBANDS = 3;
    private static final int NGRAYS = 256;
    private static final int OVERSHOOT = 256;
    private static final int UNDERSHOOT = 256;
    private static final int TOTALGRAYS = 768;
    private static final int ERR_SHIFT = 8;
    protected LookupTableJAI colorMap;
    protected KernelJAI errorKernel;
    private int numBandsSource;
    private boolean isOptimizedCase = false;

    public ErrorDiffusionOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, LookupTableJAI lookupTableJAI, KernelJAI kernelJAI) {
        super(renderedImage, tileCache, ErrorDiffusionOpImage.layoutHelper(imageLayout, renderedImage));
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBandsSource = sampleModel.getNumBands();
        this.colorMap = lookupTableJAI;
        this.errorKernel = kernelJAI;
        this.isOptimizedCase = this.sampleModel.getTransferType() == 0 && sampleModel.getTransferType() == 0 && this.numBandsSource == 3 && lookupTableJAI instanceof ColorCube && ErrorDiffusionOpImage.isFloydSteinbergKernel(kernelJAI);
    }

    protected final void computeImage(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.isOptimizedCase) {
            this.computeImageOptimized(raster, writableRaster, rectangle);
        } else {
            this.computeImageDefault(raster, writableRaster, rectangle);
        }
    }

    protected final void computeImageDefault(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n = this.minX;
        int n2 = n + this.width - 1;
        int n3 = this.minY;
        int n4 = n3 + this.height - 1;
        int n5 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin();
        float[][] fArray = new float[n5][this.width * this.numBandsSource];
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray[n6] = n6;
            raster.getPixels(n, n3 + n6, this.width, 1, fArray[n6]);
            ++n6;
        }
        int n7 = n5 - 1;
        int n8 = this.errorKernel.getWidth();
        float[] fArray2 = this.errorKernel.getKernelData();
        int n9 = n8 - this.errorKernel.getXOrigin() - 1;
        int n10 = this.errorKernel.getHeight() - this.errorKernel.getYOrigin() - 1;
        int n11 = this.errorKernel.getYOrigin() * n8 + this.errorKernel.getXOrigin() + 1;
        int n12 = (this.errorKernel.getYOrigin() + 1) * n8;
        float[] fArray3 = new float[this.numBandsSource];
        int n13 = this.colorMap.getOffset();
        float[] fArray4 = new float[this.numBandsSource];
        int[] nArray2 = new int[this.width];
        int n14 = n3;
        while (n14 <= n4) {
            int n15;
            int n16 = nArray[0];
            float[] fArray5 = fArray[n16];
            int n17 = 0;
            int n18 = n;
            int n19 = 0;
            while (n18 <= n2) {
                n15 = 0;
                while (n15 < this.numBandsSource) {
                    fArray3[n15] = fArray5[n19++];
                    ++n15;
                }
                int n20 = this.colorMap.findNearestEntry(fArray3);
                nArray2[n17++] = n20;
                boolean bl = false;
                int n21 = 0;
                while (n21 < this.numBandsSource) {
                    fArray4[n21] = fArray3[n21] - this.colorMap.lookupFloat(n21, n20);
                    if (fArray4[n21] != 0.0f) {
                        bl = true;
                    }
                    ++n21;
                }
                if (bl) {
                    int n22;
                    int n23 = Math.min(n9, n2 - n18);
                    int n24 = n11;
                    int n25 = n19;
                    int n26 = 1;
                    while (n26 <= n23) {
                        n22 = 0;
                        while (n22 < this.numBandsSource) {
                            int n27 = n25++;
                            fArray5[n27] = fArray5[n27] + fArray4[n22] * fArray2[n24];
                            ++n22;
                        }
                        ++n24;
                        ++n26;
                    }
                    n22 = Math.min(n18 - n, n9);
                    int n28 = Math.min(n18 + n9, n2) - Math.max(n18 - n9, n) + 1;
                    int n29 = 1;
                    while (n29 <= n10) {
                        float[] fArray6 = fArray[nArray[n29]];
                        n24 = n12;
                        n25 = n19 - (n22 + 1) * this.numBandsSource;
                        int n30 = 1;
                        while (n30 <= n28) {
                            int n31 = 0;
                            while (n31 < this.numBandsSource) {
                                int n32 = n25++;
                                fArray6[n32] = fArray6[n32] + fArray4[n31] * fArray2[n24];
                                ++n31;
                            }
                            ++n24;
                            ++n30;
                        }
                        ++n29;
                    }
                }
                ++n18;
            }
            writableRaster.setSamples(n, n14, rectangle.width, 1, 0, nArray2);
            n15 = 0;
            while (n15 < n7) {
                nArray[n15] = nArray[n15 + 1];
                ++n15;
            }
            nArray[n7] = n16;
            if (n14 + n5 < this.getMaxY()) {
                raster.getPixels(n, n14 + n5, this.width, 1, fArray[nArray[n7]]);
            }
            ++n14;
        }
    }

    protected final void computeImageOptimized(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n = this.minX;
        int n2 = n + this.width - 1;
        int n3 = this.minY;
        int n4 = n3 + this.height - 1;
        int[] nArray = ErrorDiffusionOpImage.initFloydSteinberg24To8((ColorCube)this.colorMap);
        int n5 = raster.getWidth() + 2;
        int[] nArray2 = new int[n5 * 3];
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n, n3, raster.getWidth(), raster.getHeight()), rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        byte[] byArray = rasterAccessor.getByteDataArray(0);
        byte[] byArray2 = rasterAccessor.getByteDataArray(1);
        byte[] byArray3 = rasterAccessor.getByteDataArray(2);
        byte[] byArray4 = rasterAccessor2.getByteDataArray(0);
        int n10 = rasterAccessor.getBandOffset(0);
        int n11 = rasterAccessor.getBandOffset(1);
        int n12 = rasterAccessor.getBandOffset(2);
        int n13 = rasterAccessor2.getBandOffset(0);
        int n14 = n3;
        while (n14 <= n4) {
            int n15;
            int n16 = n10;
            int n17 = n11;
            int n18 = n12;
            int n19 = n13;
            int n20 = 0;
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            int n29 = 0;
            boolean bl = false;
            int n30 = n;
            while (n30 <= n2) {
                int n31;
                n15 = 256;
                int n32 = (n20 + nArray2[n29 + 3] + 8 >> 4) + (byArray[n16] & 0xFF);
                n16 += n6;
                int n33 = nArray[n15 + n32];
                int n34 = n31 = n33 >> 8;
                int n35 = n33 & 0xFF;
                int n36 = n31 + n31;
                nArray2[n29] = n21 + (n31 += n36);
                n21 = n22 + (n31 += n36);
                n22 = n34;
                n20 = n31 += n36;
                n32 = (n23 + nArray2[n29 + 4] + 8 >> 4) + (byArray2[n17] & 0xFF);
                n17 += n6;
                n33 = nArray[(n15 += 768) + n32];
                n34 = n31 = n33 >> 8;
                n35 += n33 & 0xFF;
                n36 = n31 + n31;
                nArray2[n29 + 1] = n24 + (n31 += n36);
                n24 = n25 + (n31 += n36);
                n25 = n34;
                n23 = n31 += n36;
                n32 = (n26 + nArray2[n29 + 5] + 8 >> 4) + (byArray3[n18] & 0xFF);
                n18 += n6;
                n33 = nArray[(n15 += 768) + n32];
                n34 = n31 = n33 >> 8;
                n35 += n33 & 0xFF;
                n36 = n31 + n31;
                nArray2[n29 + 2] = n27 + (n31 += n36);
                n27 = n28 + (n31 += n36);
                n28 = n34;
                n26 = n31 += n36;
                byArray4[n19] = (byte)(n35 & 0xFF);
                n19 += n8;
                n29 += 3;
                ++n30;
            }
            n15 = 3 * (n5 - 2);
            nArray2[n15] = n21;
            nArray2[n15 + 1] = n24;
            nArray2[n15 + 2] = n27;
            n10 += n7;
            n11 += n7;
            n12 += n7;
            n13 += n9;
            ++n14;
        }
        rasterAccessor2.copyDataToRaster();
    }

    private static int[] initFloydSteinberg24To8(ColorCube colorCube) {
        int n;
        int[] nArray = new int[2304];
        float[] fArray = new float[256];
        int[] nArray2 = colorCube.getMultipliers();
        int[] nArray3 = colorCube.getDimsLessOne();
        int n2 = colorCube.getAdjustedOffset();
        int n3 = 0;
        while (n3 < 3) {
            int n4;
            n = n3 * 768;
            float f2 = 255.0f / (float)nArray3[n3];
            int n5 = 0;
            while (n5 < nArray3[n3]) {
                fArray[n5] = ((float)n5 + 0.5f) * f2;
                ++n5;
            }
            fArray[nArray3[n3]] = 256.0f;
            int n6 = 256;
            int n7 = -65536;
            int n8 = -256;
            while (n8 < 0) {
                nArray[n++] = n7;
                n7 += n6;
                ++n8;
            }
            int n9 = 0;
            float f3 = 0.0f;
            int n10 = 0;
            float f4 = fArray[0];
            int n11 = 0;
            while (n11 < 256) {
                int n12 = n9;
                n4 = (int)(f3 + 0.5f);
                while ((float)n11 < f4) {
                    nArray[n++] = (n11 - n4 << 8) + n12;
                    ++n11;
                }
                f4 = fArray[++n10];
                n9 += nArray2[n3];
                f3 += f2;
            }
            n4 = 255;
            n7 = 256 - n4 << 8 | (n9 -= nArray2[n3]);
            n11 = 256;
            while (n11 < 512) {
                nArray[n++] = n7;
                n7 += n6;
                ++n11;
            }
            ++n3;
        }
        n = 0;
        int n13 = 768;
        while (n13 != 0) {
            int n14 = n++;
            nArray[n14] = nArray[n14] + n2;
            --n13;
        }
        return nArray;
    }

    private static boolean isFloydSteinbergKernel(KernelJAI kernelJAI) {
        int n = kernelJAI.getYOrigin();
        return kernelJAI.getWidth() == 3 && kernelJAI.getXOrigin() == 1 && kernelJAI.getHeight() - n == 2 && Math.abs(kernelJAI.getElement(2, n) - 0.4375f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(0, n + 1) - 0.1875f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(1, n + 1) - 0.3125f) < 1.1920929E-7f && Math.abs(kernelJAI.getElement(2, n + 1) - 0.0625f) < 1.1920929E-7f;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        imageLayout2.setWidth(renderedImage.getWidth());
        imageLayout2.setHeight(renderedImage.getHeight());
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        return imageLayout2;
    }
}

