/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class CompositeOpImage
extends PointOpImage {
    protected PlanarImage source1Alpha;
    protected PlanarImage source2Alpha;
    protected boolean alphaPremultiplied;
    private int aOffset;
    private int cOffset;
    private byte maxValueByte;
    private short maxValueShort;
    private int maxValue;
    private float invMaxValue;

    public CompositeOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, TileCache tileCache, ImageLayout imageLayout, PlanarImage planarImage, PlanarImage planarImage2, boolean bl, boolean bl2) {
        super(renderedImage, renderedImage2, tileCache, imageLayout, true);
        this.source1Alpha = planarImage;
        this.source2Alpha = planarImage2;
        this.alphaPremultiplied = bl;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        int n2 = sampleModel.getNumBands() + 1;
        if (this.sampleModel.getTransferType() != n || this.sampleModel.getNumBands() != n2) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, n, this.tileWidth, this.tileHeight, n2);
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
        }
        this.aOffset = bl2 ? 0 : n2 - 1;
        this.cOffset = bl2 ? 1 : 0;
        switch (n) {
            case 0: {
                this.maxValue = 255;
                this.maxValueByte = (byte)-1;
                break;
            }
            case 1: {
                this.maxValue = 65535;
                this.maxValueShort = (short)-1;
                break;
            }
            case 2: {
                this.maxValue = Short.MAX_VALUE;
                this.maxValueShort = Short.MAX_VALUE;
                break;
            }
            case 3: {
                this.maxValue = Integer.MAX_VALUE;
                break;
            }
        }
        this.invMaxValue = 1.0f / (float)this.maxValue;
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[] byArray3 = rasterAccessor3.getByteDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        byte[] byArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            byArray4 = rasterAccessor4.getByteDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        byte[][] byArray5 = rasterAccessor5.getByteDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f2 = 1.0f - (float)(byArray3[n24 + n10] & 0xFF) * this.invMaxValue;
                        byArray5[this.aOffset][n25 + nArray3[this.aOffset]] = this.maxValueByte;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            byArray5[n28][n25 + nArray3[n28]] = (byte)((float)(byArray[n27][n22 + nArray[n27]] & 0xFF) + (float)(byArray2[n27][n23 + nArray2[n27]] & 0xFF) * f2);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        int n36 = byArray3[n32 + n10] & 0xFF;
                        float f3 = 1.0f - (float)n36 * this.invMaxValue;
                        byArray5[this.aOffset][n34 + nArray3[this.aOffset]] = (byte)((float)n36 + (float)(byArray4[n33 + n13] & 0xFF) * f3);
                        int n37 = 0;
                        while (n37 < n3) {
                            int n38 = n37 + this.cOffset;
                            byArray5[n38][n34 + nArray3[n38]] = (byte)((float)(byArray[n37][n30 + nArray[n37]] & 0xFF) + (float)(byArray2[n37][n31 + nArray2[n37]] & 0xFF) * f3);
                            ++n37;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n2) {
                int n40 = n16;
                int n41 = n17;
                int n42 = n18;
                int n43 = n20;
                int n44 = 0;
                while (n44 < n) {
                    float f4 = (float)(byArray3[n42 + n10] & 0xFF) * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    byArray5[this.aOffset][n43 + nArray3[this.aOffset]] = this.maxValueByte;
                    int n45 = 0;
                    while (n45 < n3) {
                        int n46 = n45 + this.cOffset;
                        byArray5[n46][n43 + nArray3[n46]] = (byte)((float)(byArray[n45][n40 + nArray[n45]] & 0xFF) * f4 + (float)(byArray2[n45][n41 + nArray2[n45]] & 0xFF) * f5);
                        ++n45;
                    }
                    n40 += n5;
                    n41 += n7;
                    n42 += n9;
                    n43 += n15;
                    ++n44;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n2) {
                int n48 = n16;
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = 0;
                while (n53 < n) {
                    float f6;
                    float f7;
                    int n54 = byArray3[n50 + n10] & 0xFF;
                    float f8 = (1.0f - (float)n54 * this.invMaxValue) * (float)(byArray4[n51 + n13] & 0xFF);
                    float f9 = (float)n54 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n54 / f9;
                        f6 = f8 / f9;
                    }
                    byArray5[this.aOffset][n52 + nArray3[this.aOffset]] = (byte)f9;
                    int n55 = 0;
                    while (n55 < n3) {
                        int n56 = n55 + this.cOffset;
                        byArray5[n56][n52 + nArray3[n56]] = (byte)((float)(byArray[n55][n48 + nArray[n55]] & 0xFF) * f7 + (float)(byArray2[n55][n49 + nArray2[n55]] & 0xFF) * f6);
                        ++n55;
                    }
                    n48 += n5;
                    n49 += n7;
                    n50 += n9;
                    n51 += n12;
                    n52 += n15;
                    ++n53;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n47;
            }
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RenderedImage[] renderedImageArray = this.source2Alpha == null ? new RenderedImage[3] : new RenderedImage[4];
        renderedImageArray[0] = this.getSource(0);
        renderedImageArray[1] = this.getSource(1);
        renderedImageArray[2] = this.source1Alpha;
        Raster raster = this.source1Alpha.getData(rectangle);
        Raster raster2 = null;
        if (this.source2Alpha != null) {
            renderedImageArray[3] = this.source2Alpha;
            raster2 = this.source2Alpha.getData(rectangle);
        }
        RasterFormatTag[] rasterFormatTagArray = RasterAccessor.findCompatibleTags(renderedImageArray, this);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(raster, rectangle, rasterFormatTagArray[2], this.source1Alpha.getColorModel());
        RasterAccessor rasterAccessor4 = null;
        RasterAccessor rasterAccessor5 = null;
        if (this.source2Alpha != null) {
            rasterAccessor4 = new RasterAccessor(raster2, rectangle, rasterFormatTagArray[3], this.source2Alpha.getColorModel());
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[4], this.getColorModel());
        } else {
            rasterAccessor4 = null;
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[3], this.getColorModel());
        }
        switch (rasterAccessor5.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
        }
        rasterAccessor5.copyDataToRaster();
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[] dArray3 = rasterAccessor3.getDoubleDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        double[] dArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            dArray4 = rasterAccessor4.getDoubleDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        double[][] dArray5 = rasterAccessor5.getDoubleDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        double d2 = 5.562684646268003E-309;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        double d3 = 1.0 - dArray3[n24 + n10] * d2;
                        dArray5[this.aOffset][n25 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            dArray5[n28][n25 + nArray3[n28]] = dArray[n27][n22 + nArray[n27]] + dArray2[n27][n23 + nArray2[n27]] * d3;
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        double d4 = dArray3[n32 + n10];
                        double d5 = 1.0 - d4 * d2;
                        dArray5[this.aOffset][n34 + nArray3[this.aOffset]] = d4 + dArray4[n33 + n13] * d5;
                        int n36 = 0;
                        while (n36 < n3) {
                            int n37 = n36 + this.cOffset;
                            dArray5[n37][n34 + nArray3[n37]] = dArray[n36][n30 + nArray[n36]] + dArray2[n36][n31 + nArray2[n36]] * d5;
                            ++n36;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n38 = 0;
            while (n38 < n2) {
                int n39 = n16;
                int n40 = n17;
                int n41 = n18;
                int n42 = n20;
                int n43 = 0;
                while (n43 < n) {
                    double d6 = dArray3[n41 + n10] * d2;
                    double d7 = 1.0 - d6;
                    dArray5[this.aOffset][n42 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                    int n44 = 0;
                    while (n44 < n3) {
                        int n45 = n44 + this.cOffset;
                        dArray5[n45][n42 + nArray3[n45]] = dArray[n44][n39 + nArray[n44]] * d6 + dArray2[n44][n40 + nArray2[n44]] * d7;
                        ++n44;
                    }
                    n39 += n5;
                    n40 += n7;
                    n41 += n9;
                    n42 += n15;
                    ++n43;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n38;
            }
        } else {
            int n46 = 0;
            while (n46 < n2) {
                int n47 = n16;
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = 0;
                while (n52 < n) {
                    double d8;
                    double d9;
                    double d10 = dArray3[n49 + n10];
                    double d11 = (1.0 - d10 * d2) * dArray4[n50 + n13];
                    double d12 = d10 + d11;
                    if (d12 == 0.0) {
                        d9 = 0.0;
                        d8 = 0.0;
                    } else {
                        d9 = d10 / d12;
                        d8 = d11 / d12;
                    }
                    dArray5[this.aOffset][n51 + nArray3[this.aOffset]] = d12;
                    int n53 = 0;
                    while (n53 < n3) {
                        int n54 = n53 + this.cOffset;
                        dArray5[n54][n51 + nArray3[n54]] = dArray[n53][n47 + nArray[n53]] * d9 + dArray2[n53][n48 + nArray2[n53]] * d8;
                        ++n53;
                    }
                    n47 += n5;
                    n48 += n7;
                    n49 += n9;
                    n50 += n12;
                    n51 += n15;
                    ++n52;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n46;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[] fArray3 = rasterAccessor3.getFloatDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        float[] fArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            fArray4 = rasterAccessor4.getFloatDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        float[][] fArray5 = rasterAccessor5.getFloatDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        float f2 = 2.938736E-39f;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f3 = 1.0f - fArray3[n24 + n10] * f2;
                        fArray5[this.aOffset][n25 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            fArray5[n28][n25 + nArray3[n28]] = fArray[n27][n22 + nArray[n27]] + fArray2[n27][n23 + nArray2[n27]] * f3;
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        float f4 = fArray3[n32 + n10];
                        float f5 = 1.0f - f4 * f2;
                        fArray5[this.aOffset][n34 + nArray3[this.aOffset]] = f4 + fArray4[n33 + n13] * f5;
                        int n36 = 0;
                        while (n36 < n3) {
                            int n37 = n36 + this.cOffset;
                            fArray5[n37][n34 + nArray3[n37]] = fArray[n36][n30 + nArray[n36]] + fArray2[n36][n31 + nArray2[n36]] * f5;
                            ++n36;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n38 = 0;
            while (n38 < n2) {
                int n39 = n16;
                int n40 = n17;
                int n41 = n18;
                int n42 = n20;
                int n43 = 0;
                while (n43 < n) {
                    float f6 = fArray3[n41 + n10] * f2;
                    float f7 = 1.0f - f6;
                    fArray5[this.aOffset][n42 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                    int n44 = 0;
                    while (n44 < n3) {
                        int n45 = n44 + this.cOffset;
                        fArray5[n45][n42 + nArray3[n45]] = fArray[n44][n39 + nArray[n44]] * f6 + fArray2[n44][n40 + nArray2[n44]] * f7;
                        ++n44;
                    }
                    n39 += n5;
                    n40 += n7;
                    n41 += n9;
                    n42 += n15;
                    ++n43;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n38;
            }
        } else {
            int n46 = 0;
            while (n46 < n2) {
                int n47 = n16;
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = 0;
                while (n52 < n) {
                    float f8;
                    float f9;
                    float f10 = fArray3[n49 + n10];
                    float f11 = (1.0f - f10 * f2) * fArray4[n50 + n13];
                    float f12 = f10 + f11;
                    if (f12 == 0.0f) {
                        f9 = 0.0f;
                        f8 = 0.0f;
                    } else {
                        f9 = f10 / f12;
                        f8 = f11 / f12;
                    }
                    fArray5[this.aOffset][n51 + nArray3[this.aOffset]] = f12;
                    int n53 = 0;
                    while (n53 < n3) {
                        int n54 = n53 + this.cOffset;
                        fArray5[n54][n51 + nArray3[n54]] = fArray[n53][n47 + nArray[n53]] * f9 + fArray2[n53][n48 + nArray2[n53]] * f8;
                        ++n53;
                    }
                    n47 += n5;
                    n48 += n7;
                    n49 += n9;
                    n50 += n12;
                    n51 += n15;
                    ++n52;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n46;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int[][] nArray = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray4 = rasterAccessor2.getBandOffsets();
        int[] nArray5 = rasterAccessor3.getIntDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        int[] nArray6 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            nArray6 = rasterAccessor4.getIntDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        int[][] nArray7 = rasterAccessor5.getIntDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray8 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f2 = 1.0f - (float)nArray5[n24 + n10] * this.invMaxValue;
                        nArray7[this.aOffset][n25 + nArray8[this.aOffset]] = this.maxValue;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            nArray7[n28][n25 + nArray8[n28]] = (int)((float)nArray[n27][n22 + nArray2[n27]] + (float)nArray3[n27][n23 + nArray4[n27]] * f2);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        int n36 = nArray5[n32 + n10];
                        float f3 = 1.0f - (float)n36 * this.invMaxValue;
                        nArray7[this.aOffset][n34 + nArray8[this.aOffset]] = (int)((float)n36 + (float)nArray6[n33 + n13] * f3);
                        int n37 = 0;
                        while (n37 < n3) {
                            int n38 = n37 + this.cOffset;
                            nArray7[n38][n34 + nArray8[n38]] = (int)((float)nArray[n37][n30 + nArray2[n37]] + (float)nArray3[n37][n31 + nArray4[n37]] * f3);
                            ++n37;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n2) {
                int n40 = n16;
                int n41 = n17;
                int n42 = n18;
                int n43 = n20;
                int n44 = 0;
                while (n44 < n) {
                    float f4 = (float)nArray5[n42 + n10] * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    nArray7[this.aOffset][n43 + nArray8[this.aOffset]] = this.maxValue;
                    int n45 = 0;
                    while (n45 < n3) {
                        int n46 = n45 + this.cOffset;
                        nArray7[n46][n43 + nArray8[n46]] = (int)((float)nArray[n45][n40 + nArray2[n45]] * f4 + (float)nArray3[n45][n41 + nArray4[n45]] * f5);
                        ++n45;
                    }
                    n40 += n5;
                    n41 += n7;
                    n42 += n9;
                    n43 += n15;
                    ++n44;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n2) {
                int n48 = n16;
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = 0;
                while (n53 < n) {
                    float f6;
                    float f7;
                    int n54 = nArray5[n50 + n10];
                    float f8 = (1.0f - (float)n54 * this.invMaxValue) * (float)nArray6[n51 + n13];
                    float f9 = (float)n54 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n54 / f9;
                        f6 = f8 / f9;
                    }
                    nArray7[this.aOffset][n52 + nArray8[this.aOffset]] = (int)f9;
                    int n55 = 0;
                    while (n55 < n3) {
                        int n56 = n55 + this.cOffset;
                        nArray7[n56][n52 + nArray8[n56]] = (int)((float)nArray[n55][n48 + nArray2[n55]] * f7 + (float)nArray3[n55][n49 + nArray4[n55]] * f6);
                        ++n55;
                    }
                    n48 += n5;
                    n49 += n7;
                    n50 += n9;
                    n51 += n12;
                    n52 += n15;
                    ++n53;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n47;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f2 = 1.0f - (float)sArray3[n24 + n10] * this.invMaxValue;
                        sArray5[this.aOffset][n25 + nArray3[this.aOffset]] = this.maxValueShort;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            sArray5[n28][n25 + nArray3[n28]] = (short)((float)sArray[n27][n22 + nArray[n27]] + (float)sArray2[n27][n23 + nArray2[n27]] * f2);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        short s = sArray3[n32 + n10];
                        float f3 = 1.0f - (float)s * this.invMaxValue;
                        sArray5[this.aOffset][n34 + nArray3[this.aOffset]] = (short)((float)s + (float)sArray4[n33 + n13] * f3);
                        int n36 = 0;
                        while (n36 < n3) {
                            int n37 = n36 + this.cOffset;
                            sArray5[n37][n34 + nArray3[n37]] = (short)((float)sArray[n36][n30 + nArray[n36]] + (float)sArray2[n36][n31 + nArray2[n36]] * f3);
                            ++n36;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n38 = 0;
            while (n38 < n2) {
                int n39 = n16;
                int n40 = n17;
                int n41 = n18;
                int n42 = n20;
                int n43 = 0;
                while (n43 < n) {
                    float f4 = (float)sArray3[n41 + n10] * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    sArray5[this.aOffset][n42 + nArray3[this.aOffset]] = this.maxValueShort;
                    int n44 = 0;
                    while (n44 < n3) {
                        int n45 = n44 + this.cOffset;
                        sArray5[n45][n42 + nArray3[n45]] = (short)((float)sArray[n44][n39 + nArray[n44]] * f4 + (float)sArray2[n44][n40 + nArray2[n44]] * f5);
                        ++n44;
                    }
                    n39 += n5;
                    n40 += n7;
                    n41 += n9;
                    n42 += n15;
                    ++n43;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n38;
            }
        } else {
            int n46 = 0;
            while (n46 < n2) {
                int n47 = n16;
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = 0;
                while (n52 < n) {
                    float f6;
                    float f7;
                    short s = sArray3[n49 + n10];
                    float f8 = (1.0f - (float)s * this.invMaxValue) * (float)sArray4[n50 + n13];
                    float f9 = (float)s + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)s / f9;
                        f6 = f8 / f9;
                    }
                    sArray5[this.aOffset][n51 + nArray3[this.aOffset]] = (short)f9;
                    int n53 = 0;
                    while (n53 < n3) {
                        int n54 = n53 + this.cOffset;
                        sArray5[n54][n51 + nArray3[n54]] = (short)((float)sArray[n53][n47 + nArray[n53]] * f7 + (float)sArray2[n53][n48 + nArray2[n53]] * f6);
                        ++n53;
                    }
                    n47 += n5;
                    n48 += n7;
                    n49 += n9;
                    n50 += n12;
                    n51 += n15;
                    ++n52;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n46;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = n16;
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n20;
                    int n26 = 0;
                    while (n26 < n) {
                        float f2 = 1.0f - (float)(sArray3[n24 + n10] & 0xFFFF) * this.invMaxValue;
                        sArray5[this.aOffset][n25 + nArray3[this.aOffset]] = this.maxValueShort;
                        int n27 = 0;
                        while (n27 < n3) {
                            int n28 = n27 + this.cOffset;
                            sArray5[n28][n25 + nArray3[n28]] = (short)((float)(sArray[n27][n22 + nArray[n27]] & 0xFFFF) + (float)(sArray2[n27][n23 + nArray2[n27]] & 0xFFFF) * f2);
                            ++n27;
                        }
                        n22 += n5;
                        n23 += n7;
                        n24 += n9;
                        n25 += n15;
                        ++n26;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                    ++n21;
                }
            } else {
                int n29 = 0;
                while (n29 < n2) {
                    int n30 = n16;
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = 0;
                    while (n35 < n) {
                        int n36 = sArray3[n32 + n10] & 0xFFFF;
                        float f3 = 1.0f - (float)n36 * this.invMaxValue;
                        sArray5[this.aOffset][n34 + nArray3[this.aOffset]] = (short)((float)n36 + (float)(sArray4[n33 + n13] & 0xFFFF) * f3);
                        int n37 = 0;
                        while (n37 < n3) {
                            int n38 = n37 + this.cOffset;
                            sArray5[n38][n34 + nArray3[n38]] = (short)((float)(sArray[n37][n30 + nArray[n37]] & 0xFFFF) + (float)(sArray2[n37][n31 + nArray2[n37]] & 0xFFFF) * f3);
                            ++n37;
                        }
                        n30 += n5;
                        n31 += n7;
                        n32 += n9;
                        n33 += n12;
                        n34 += n15;
                        ++n35;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                    ++n29;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n2) {
                int n40 = n16;
                int n41 = n17;
                int n42 = n18;
                int n43 = n20;
                int n44 = 0;
                while (n44 < n) {
                    float f4 = (float)(sArray3[n42 + n10] & 0xFFFF) * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    sArray5[this.aOffset][n43 + nArray3[this.aOffset]] = this.maxValueShort;
                    int n45 = 0;
                    while (n45 < n3) {
                        int n46 = n45 + this.cOffset;
                        sArray5[n46][n43 + nArray3[n46]] = (short)((float)(sArray[n45][n40 + nArray[n45]] & 0xFFFF) * f4 + (float)(sArray2[n45][n41 + nArray2[n45]] & 0xFFFF) * f5);
                        ++n45;
                    }
                    n40 += n5;
                    n41 += n7;
                    n42 += n9;
                    n43 += n15;
                    ++n44;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n2) {
                int n48 = n16;
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = 0;
                while (n53 < n) {
                    float f6;
                    float f7;
                    int n54 = sArray3[n50 + n10] & 0xFFFF;
                    float f8 = (1.0f - (float)n54 * this.invMaxValue) * (float)(sArray4[n51 + n13] & 0xFFFF);
                    float f9 = (float)n54 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n54 / f9;
                        f6 = f8 / f9;
                    }
                    sArray5[this.aOffset][n52 + nArray3[this.aOffset]] = (short)f9;
                    int n55 = 0;
                    while (n55 < n3) {
                        int n56 = n55 + this.cOffset;
                        sArray5[n56][n52 + nArray3[n56]] = (short)((float)(sArray[n55][n48 + nArray[n55]] & 0xFFFF) * f7 + (float)(sArray2[n55][n49 + nArray2[n55]] & 0xFFFF) * f6);
                        ++n55;
                    }
                    n48 += n5;
                    n49 += n7;
                    n50 += n9;
                    n51 += n12;
                    n52 += n15;
                    ++n53;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
                ++n47;
            }
        }
    }
}

