/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpOpImage;

class AffineOpImage
extends WarpOpImage {
    protected AffineTransform i_transform;
    protected Interpolation interp;
    private Rectangle srcimg;
    private Rectangle padimg;
    protected BorderExtender extender;
    private Rectangle theDest;
    public float src_rect_x1;
    public float src_rect_y1;
    public float src_rect_x2;
    public float src_rect_y2;
    protected static final int geom_frac_max = 0x100000;
    double m00;
    double m10;
    double flr_m00;
    double flr_m10;
    double fracdx;
    double fracdx1;
    double fracdy;
    double fracdy1;
    int incx;
    int incx1;
    int incy;
    int incy1;
    int ifracdx;
    int ifracdx1;
    int ifracdy;
    int ifracdy1;
    public int lpad;
    public int rpad;
    public int tpad;
    public int bpad;
    protected static final int USHORT_MAX = 65535;
    protected int clipMinX;
    protected int clipMaxX;
    protected int s_ix;
    protected int s_iy;
    protected int ifracx;
    protected int ifracy;

    public AffineOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, AffineOpImage.layoutHelper(imageLayout, renderedImage, affineTransform), new WarpAffine(affineTransform), interpolation, true);
        this.interp = interpolation;
        this.extender = borderExtender;
        this.lpad = interpolation.getLeftPadding();
        this.rpad = interpolation.getRightPadding();
        this.tpad = interpolation.getTopPadding();
        this.bpad = interpolation.getBottomPadding();
        this.srcimg = new Rectangle(this.source0.getMinX(), this.source0.getMinY(), this.source0.getWidth(), this.source0.getHeight());
        this.padimg = new Rectangle(this.srcimg.x - this.lpad, this.srcimg.y - this.tpad, this.srcimg.width + this.lpad + this.rpad, this.srcimg.height + this.tpad + this.bpad);
        if (borderExtender == null) {
            float f2 = this.srcimg.x;
            float f3 = this.srcimg.y;
            float f4 = this.srcimg.width;
            float f5 = this.srcimg.height;
            float f6 = this.lpad;
            float f7 = this.rpad;
            float f8 = this.tpad;
            float f9 = this.bpad;
            if (!(interpolation instanceof InterpolationNearest)) {
                f6 = (float)((double)f6 + 0.5);
                f8 = (float)((double)f8 + 0.5);
                f7 = (float)((double)f7 + 0.5);
                f9 = (float)((double)f9 + 0.5);
            }
            Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f2 += f6, f3 += f8), new Point2D.Float(f2 + (f4 -= f6 + f7), f3), new Point2D.Float(f2 + f4, f3 + (f5 -= f8 + f9)), new Point2D.Float(f2, f3 + f5)};
            affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
            float f10 = Float.MAX_VALUE;
            float f11 = Float.MAX_VALUE;
            float f12 = -3.4028235E38f;
            float f13 = -3.4028235E38f;
            int n = 0;
            while (n < 4) {
                float f14 = (float)point2DArray[n].getX();
                float f15 = (float)point2DArray[n].getY();
                f10 = Math.min(f10, f14);
                f11 = Math.min(f11, f15);
                f12 = Math.max(f12, f14);
                f13 = Math.max(f13, f15);
                ++n;
            }
            int n2 = (int)Math.ceil(f10);
            int n3 = (int)Math.ceil(f11);
            int n4 = (int)Math.floor(f12);
            int n5 = (int)Math.floor(f13);
            this.theDest = new Rectangle(n2, n3, n4 - n2, n5 - n3);
        } else {
            this.theDest = this.getBounds();
        }
        try {
            this.i_transform = affineTransform.createInverse();
        }
        catch (Exception exception) {
            throw new RuntimeException(JaiI18N.getString("AffineOpImage0"));
        }
        this.m00 = this.i_transform.getScaleX();
        this.flr_m00 = Math.floor(this.m00);
        this.fracdx = this.m00 - this.flr_m00;
        this.fracdx1 = 1.0 - this.fracdx;
        this.incx = (int)this.flr_m00;
        this.incx1 = this.incx + 1;
        this.ifracdx = (int)Math.round(this.fracdx * 1048576.0);
        this.ifracdx1 = 0x100000 - this.ifracdx;
        this.m10 = this.i_transform.getShearY();
        this.flr_m10 = Math.floor(this.m10);
        this.fracdy = this.m10 - this.flr_m10;
        this.fracdy1 = 1.0 - this.fracdy;
        this.incy = (int)this.flr_m10;
        this.incy1 = this.incy + 1;
        this.ifracdy = (int)Math.round(this.fracdy * 1048576.0);
        this.ifracdy1 = 0x100000 - this.ifracdy;
    }

    protected final void advanceToStartOfScanline(int n) {
        int n2 = this.clipMinX - n;
        long l2 = ((long)this.ifracx + (long)(n2 * this.ifracdx)) / 0x100000L;
        long l3 = ((long)this.ifracy + (long)(n2 * this.ifracdy)) / 0x100000L;
        this.s_ix += n2 * this.incx + (int)l2;
        this.s_iy += n2 * this.incy + (int)l3;
        this.ifracx += n2 * this.ifracdx;
        this.ifracx = this.ifracx >= 0 ? (this.ifracx %= 0x100000) : -(-this.ifracx % 0x100000);
        this.ifracy += n2 * this.ifracdy;
        this.ifracy = this.ifracy >= 0 ? (this.ifracy %= 0x100000) : -(-this.ifracy % 0x100000);
    }

    protected final int ceilRatio(long l2, long l3) {
        if (l3 < 0L) {
            l3 = -l3;
            l2 = -l2;
        }
        if (l2 >= 0L) {
            return (int)((l2 + l3 - 1L) / l3);
        }
        return (int)(l2 / l3);
    }

    public final Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.theDest);
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return writableRaster;
        }
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        rectangle3 = this.extender == null ? rectangle3.intersection(this.srcimg) : rectangle3.intersection(this.padimg);
        if (rectangle3.width <= 0 || rectangle3.height <= 0) {
            return writableRaster;
        }
        this.src_rect_x1 = rectangle3.x;
        this.src_rect_y1 = rectangle3.y;
        this.src_rect_x2 = rectangle3.x + rectangle3.width;
        this.src_rect_y2 = rectangle3.y + rectangle3.height;
        Raster[] rasterArray = new Raster[]{this.extender == null ? this.source0.getData(rectangle3) : this.source0.getExtendedData(rectangle3, this.extender)};
        this.computeRect(rasterArray, writableRaster, rectangle2);
        return writableRaster;
    }

    protected final int floorRatio(long l2, long l3) {
        if (l3 < 0L) {
            l3 = -l3;
            l2 = -l2;
        }
        if (l2 >= 0L) {
            return (int)(l2 / l3);
        }
        return (int)((l2 - l3 + 1L) / l3);
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, AffineTransform affineTransform) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        float f2 = renderedImage.getMinX();
        float f3 = renderedImage.getMinY();
        float f4 = renderedImage.getWidth();
        float f5 = renderedImage.getHeight();
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f2, f3), new Point2D.Float(f2 + f4, f3), new Point2D.Float(f2 + f4, f3 + f5), new Point2D.Float(f2, f3 + f5)};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f6 = Float.MAX_VALUE;
        float f7 = Float.MAX_VALUE;
        float f8 = -3.4028235E38f;
        float f9 = -3.4028235E38f;
        int n = 0;
        while (n < 4) {
            float f10 = (float)point2DArray[n].getX();
            float f11 = (float)point2DArray[n].getY();
            f6 = Math.min(f6, f10);
            f7 = Math.min(f7, f11);
            f8 = Math.max(f8, f10);
            f9 = Math.max(f9, f11);
            ++n;
        }
        int n2 = (int)(f8 - f6);
        int n3 = (int)(f9 - f7);
        int n4 = (int)Math.floor(f6);
        int n5 = (double)Math.abs(f6 - (float)n4) <= 0.5 ? n4 : (int)Math.ceil(f6);
        int n6 = (int)Math.floor(f7);
        int n7 = (double)Math.abs(f7 - (float)n6) <= 0.5 ? n6 : (int)Math.ceil(f7);
        imageLayout2.setMinX(n5);
        imageLayout2.setMinY(n7);
        imageLayout2.setWidth(n2);
        imageLayout2.setHeight(n3);
        return imageLayout2;
    }

    public final void mapDestPoint(Point2D point2D, Point2D point2D2) {
        this.i_transform.transform(point2D, point2D2);
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        float f2 = rectangle.x;
        float f3 = rectangle.y;
        float f4 = rectangle.width;
        float f5 = rectangle.height;
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f2, f3), new Point2D.Float(f2 + f4, f3), new Point2D.Float(f2 + f4, f3 + f5), new Point2D.Float(f2, f3 + f5)};
        this.i_transform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f6 = Float.MAX_VALUE;
        float f7 = Float.MAX_VALUE;
        float f8 = -3.4028235E38f;
        float f9 = -3.4028235E38f;
        int n2 = 0;
        while (n2 < 4) {
            float f10 = (float)point2DArray[n2].getX();
            float f11 = (float)point2DArray[n2].getY();
            f6 = Math.min(f6, f10);
            f7 = Math.min(f7, f11);
            f8 = Math.max(f8, f10);
            f9 = Math.max(f9, f11);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.interp instanceof InterpolationNearest) {
            n3 = (int)Math.floor(f6);
            n4 = (int)Math.floor(f7);
            n5 = (int)Math.ceil(f8);
            n6 = (int)Math.ceil(f9);
        } else {
            n3 = (int)Math.floor((double)f6 - 0.5);
            n4 = (int)Math.floor((double)f7 - 0.5);
            n5 = (int)Math.ceil(f8);
            n6 = (int)Math.ceil(f9);
            n3 -= this.lpad;
            n4 -= this.tpad;
            n5 += this.rpad;
            n6 += this.bpad;
        }
        return new Rectangle(n3, n4, n5 - n3, n6 - n4);
    }

    protected final void performScanlineClipping(int n, int n2, int n3, int n4, int n5, int n6) {
        long l2;
        long l3;
        long l4;
        long l5;
        this.clipMinX = n;
        this.clipMaxX = n2;
        long l6 = this.incx * 0x100000 + this.ifracdx;
        if (l6 != 0L) {
            l5 = (long)this.src_rect_x1 + (long)n3;
            l4 = (long)this.src_rect_x2 - (long)n4;
            l3 = (l5 - (long)this.s_ix) * 0x100000L - (long)this.ifracx + (long)n * l6;
            l2 = (l4 - (long)this.s_ix) * 0x100000L - (long)this.ifracx + (long)n * l6;
            if (l6 < 0L) {
                long l7 = l3;
                l3 = l2;
                l2 = l7;
            }
            int n7 = this.ceilRatio(l3, l6);
            this.clipMinX = Math.max(this.clipMinX, n7);
            int n8 = this.floorRatio(l2, l6) + 1;
            this.clipMaxX = Math.min(this.clipMaxX, n8);
        } else if ((float)this.s_ix < this.src_rect_x1 || (float)this.s_ix >= this.src_rect_x2) {
            this.clipMinX = this.clipMaxX = n;
            return;
        }
        l5 = this.incy * 0x100000 + this.ifracdy;
        if (l5 != 0L) {
            l4 = (long)this.src_rect_y1 + (long)n5;
            l3 = (long)this.src_rect_y2 - (long)n6;
            l2 = (l4 - (long)this.s_iy) * 0x100000L - (long)this.ifracy + (long)n * l5;
            long l8 = (l3 - (long)this.s_iy) * 0x100000L - (long)this.ifracy + (long)n * l5;
            if (l5 < 0L) {
                long l9 = l2;
                l2 = l8;
                l8 = l9;
            }
            int n9 = this.ceilRatio(l2, l5);
            this.clipMinX = Math.max(this.clipMinX, n9);
            int n10 = this.floorRatio(l8, l5) + 1;
            this.clipMaxX = Math.min(this.clipMaxX, n10);
        } else if ((float)this.s_iy < this.src_rect_y1 || (float)this.s_iy >= this.src_rect_y2) {
            this.clipMinX = this.clipMaxX = n;
        }
    }
}

