/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.TileCache;

final class AffineNearestBinaryOpImage
extends AffineOpImage {
    private int black = 0;

    public AffineNearestBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
        if (this.colorModel.getRGB(1) == -16777216) {
            this.black = 1;
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n11 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n12 = dataBufferByte2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        int n19 = n14;
        while (n19 < n16) {
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f2 = (float)((Point2D)float_2).getX();
            float f3 = (float)((Point2D)float_2).getY();
            this.s_ix = (int)Math.floor(f2);
            this.s_iy = (int)Math.floor(f3);
            double d2 = (double)f2 - (double)this.s_ix;
            double d3 = (double)f3 - (double)this.s_iy;
            this.ifracx = (int)Math.floor(d2 * 1048576.0);
            this.ifracy = (int)Math.floor(d3 * 1048576.0);
            int n25 = this.s_ix;
            int n26 = this.s_iy;
            int n27 = this.ifracx;
            int n28 = this.ifracy;
            this.performScanlineClipping(n13, n14, 0, 0, 0, 0);
            int n29 = (n19 - n8) * n10 + n12;
            int n30 = n9 + (n13 - n7);
            int n31 = (this.s_iy - n2) * n4 + n11;
            int n32 = this.s_ix - n + n3;
            int n33 = n13;
            while (n33 < this.clipMinX) {
                n24 = n29 + (n30 >> 3);
                n23 = 7 - (n30 & 7);
                n22 = byArray2[n24];
                byArray2[n24] = (byte)(n22 |= this.black << n23);
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n33;
            }
            n24 = this.clipMinX;
            while (n24 < this.clipMaxX) {
                n23 = n31 + (n32 >> 3);
                n22 = byArray[n23];
                n21 = n22 >> 7 - (n32 & 7) & 1;
                n20 = n29 + (n30 >> 3);
                int n34 = 7 - (n30 & 7);
                int n35 = byArray2[n20];
                byArray2[n20] = (byte)(n35 |= n21 << n34);
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n24;
            }
            n23 = this.clipMaxX;
            while (n23 < n15) {
                n22 = n29 + (n30 >> 3);
                n21 = 7 - (n30 & 7);
                n20 = byArray2[n22];
                byArray2[n22] = (byte)(n20 |= this.black << n21);
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n23;
            }
            ++n19;
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, rectangle);
                break;
            }
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray = dataBufferInt.getData();
        int n11 = dataBufferInt.getOffset();
        int[] nArray2 = dataBufferInt2.getData();
        int n12 = dataBufferInt2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        int n19 = n14;
        while (n19 < n16) {
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f2 = (float)((Point2D)float_2).getX();
            float f3 = (float)((Point2D)float_2).getY();
            this.s_ix = (int)Math.floor(f2);
            this.s_iy = (int)Math.floor(f3);
            double d2 = (double)f2 - (double)this.s_ix;
            double d3 = (double)f3 - (double)this.s_iy;
            this.ifracx = (int)Math.floor(d2 * 1048576.0);
            this.ifracy = (int)Math.floor(d3 * 1048576.0);
            int n25 = this.s_ix;
            int n26 = this.s_iy;
            int n27 = this.ifracx;
            int n28 = this.ifracy;
            this.performScanlineClipping(n13, n14, 0, 0, 0, 0);
            int n29 = (n19 - n8) * n10 + n12;
            int n30 = n9 + (n13 - n7);
            int n31 = (this.s_iy - n2) * n4 + n11;
            int n32 = this.s_ix - n + n3;
            int n33 = n13;
            while (n33 < this.clipMinX) {
                n24 = n29 + (n30 >> 5);
                n23 = 31 - (n30 & 0x1F);
                n22 = nArray2[n24];
                nArray2[n24] = n22 |= this.black << n23;
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n33;
            }
            n24 = this.clipMinX;
            while (n24 < this.clipMaxX) {
                n23 = n31 + (n32 >> 5);
                n22 = nArray[n23];
                n21 = n22 >> 31 - (n32 & 0x1F) & 1;
                n20 = n29 + (n30 >> 5);
                int n34 = 31 - (n30 & 0x1F);
                int n35 = nArray2[n20];
                nArray2[n20] = n35 |= n21 << n34;
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n24;
            }
            n23 = this.clipMaxX;
            while (n23 < n15) {
                n22 = n29 + (n30 >> 5);
                n21 = 31 - (n30 & 0x1F);
                n20 = nArray2[n22];
                nArray2[n22] = n20 |= this.black << n21;
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n23;
            }
            ++n19;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferShort dataBufferShort2 = (DataBufferShort)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        short[] sArray = dataBufferShort.getData();
        int n11 = dataBufferShort.getOffset();
        short[] sArray2 = dataBufferShort2.getData();
        int n12 = dataBufferShort2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        int n19 = n14;
        while (n19 < n16) {
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f2 = (float)((Point2D)float_2).getX();
            float f3 = (float)((Point2D)float_2).getY();
            this.s_ix = (int)Math.floor(f2);
            this.s_iy = (int)Math.floor(f3);
            double d2 = (double)f2 - (double)this.s_ix;
            double d3 = (double)f3 - (double)this.s_iy;
            this.ifracx = (int)Math.floor(d2 * 1048576.0);
            this.ifracy = (int)Math.floor(d3 * 1048576.0);
            int n25 = this.s_ix;
            int n26 = this.s_iy;
            int n27 = this.ifracx;
            int n28 = this.ifracy;
            this.performScanlineClipping(n13, n14, 0, 0, 0, 0);
            int n29 = (n19 - n8) * n10 + n12;
            int n30 = n9 + (n13 - n7);
            int n31 = (this.s_iy - n2) * n4 + n11;
            int n32 = this.s_ix - n + n3;
            int n33 = n13;
            while (n33 < this.clipMinX) {
                n24 = n29 + (n30 >> 4);
                n23 = 15 - (n30 & 0xF);
                n22 = sArray2[n24];
                sArray2[n24] = (short)(n22 |= this.black << n23);
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n33;
            }
            n24 = this.clipMinX;
            while (n24 < this.clipMaxX) {
                n23 = n31 + (n32 >> 4);
                n22 = sArray[n23];
                n21 = n22 >> 15 - (n32 & 0xF) & 1;
                n20 = n29 + (n30 >> 4);
                int n34 = 15 - (n30 & 0xF);
                int n35 = sArray2[n20];
                sArray2[n20] = (short)(n35 |= n21 << n34);
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n24;
            }
            n23 = this.clipMaxX;
            while (n23 < n15) {
                n22 = n29 + (n30 >> 4);
                n21 = 15 - (n30 & 0xF);
                n20 = sArray2[n22];
                sArray2[n22] = (short)(n20 |= this.black << n21);
                if (this.ifracx < this.ifracdx1) {
                    this.s_ix += this.incx;
                    this.ifracx += this.ifracdx;
                    n32 += this.incx;
                } else {
                    this.s_ix += this.incx1;
                    this.ifracx -= this.ifracdx1;
                    n32 += this.incx1;
                }
                if (this.ifracy < this.ifracdy1) {
                    this.s_iy += this.incy;
                    this.ifracy += this.ifracdy;
                    n31 += n17;
                } else {
                    this.s_iy += this.incy1;
                    this.ifracy -= this.ifracdy1;
                    n31 += n18;
                }
                ++n30;
                ++n23;
            }
            ++n19;
        }
    }
}

