/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.PixelAccessor;
import com.sun.media.jai.util.UnpackedPixelData;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;

final class AddOpImage
extends PointOpImage {
    private int s1bd = 1;
    private int s2bd = 1;
    private PixelAccessor src1PA;
    private PixelAccessor src2PA;
    private PixelAccessor dstPA;

    public AddOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, TileCache tileCache, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, tileCache, imageLayout, true);
        this.src1PA = new PixelAccessor(renderedImage);
        this.src2PA = new PixelAccessor(renderedImage2);
        this.dstPA = new PixelAccessor(this);
        int n = PixelAccessor.getDestPixelType(this.getSources());
        if (n == -1) {
            n = 0;
        }
        int n2 = Math.min(this.src1PA.numBands, this.src2PA.numBands);
        if (this.src1PA.numBands == 1) {
            n2 = this.src2PA.numBands;
        }
        if (this.src2PA.numBands == 1) {
            n2 = this.src1PA.numBands;
        }
        if (this.dstPA.pixelType < n || this.dstPA.numBands > n2) {
            this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(n, this.tileWidth, this.tileHeight, n2);
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
            this.dstPA = new PixelAccessor(this.sampleModel, this.colorModel);
        }
        this.s1bd = this.src1PA.numBands == 1 ? 0 : 1;
        this.s2bd = this.src2PA.numBands == 1 ? 0 : 1;
        this.permitInPlaceOperation();
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        UnpackedPixelData unpackedPixelData = this.src1PA.getData(rasterArray[0], this.mapDestRect(rectangle, 0), this.dstPA.pixelType, false);
        UnpackedPixelData unpackedPixelData2 = this.src2PA.getData(rasterArray[1], this.mapDestRect(rectangle, 1), this.dstPA.pixelType, false);
        UnpackedPixelData unpackedPixelData3 = this.dstPA.getData(writableRaster, rectangle, this.dstPA.pixelType, true);
        switch (this.dstPA.pixelType) {
            case 0: {
                this.computeRectByte(unpackedPixelData, unpackedPixelData2, unpackedPixelData3);
                break;
            }
            case 1: {
                this.computeRectUShort(unpackedPixelData, unpackedPixelData2, unpackedPixelData3);
                break;
            }
            case 2: {
                this.computeRectShort(unpackedPixelData, unpackedPixelData2, unpackedPixelData3);
                break;
            }
            case 3: {
                this.computeRectInt(unpackedPixelData, unpackedPixelData2, unpackedPixelData3);
                break;
            }
            case 4: {
                this.computeRectFloat(unpackedPixelData, unpackedPixelData2, unpackedPixelData3);
                break;
            }
            case 5: {
                this.computeRectDouble(unpackedPixelData, unpackedPixelData2, unpackedPixelData3);
                break;
            }
        }
        this.dstPA.setData(unpackedPixelData3);
    }

    private void computeRectByte(UnpackedPixelData unpackedPixelData, UnpackedPixelData unpackedPixelData2, UnpackedPixelData unpackedPixelData3) {
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int[] nArray = unpackedPixelData.offsets;
        byte[][] byArray = unpackedPixelData.getByteData();
        int n3 = unpackedPixelData2.lineStride;
        int n4 = unpackedPixelData2.pixelStride;
        int[] nArray2 = unpackedPixelData2.offsets;
        byte[][] byArray2 = unpackedPixelData2.getByteData();
        int n5 = unpackedPixelData3.rect.width;
        int n6 = unpackedPixelData3.rect.height;
        int n7 = this.dstPA.numBands;
        int n8 = unpackedPixelData3.lineStride;
        int n9 = unpackedPixelData3.pixelStride;
        int[] nArray3 = unpackedPixelData3.offsets;
        byte[][] byArray3 = unpackedPixelData3.getByteData();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            byte[] byArray4 = byArray[n11];
            byte[] byArray5 = byArray2[n12];
            byte[] byArray6 = byArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n6) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                int n20 = 0;
                int n21 = 0;
                while (n21 < n5) {
                    n20 = (byArray4[n17] & 0xFF) + (byArray5[n18] & 0xFF);
                    byArray6[n19] = (byte)((n20 << 23 >> 31 | n20) & 0xFF);
                    n17 += n2;
                    n18 += n4;
                    n19 += n9;
                    ++n21;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectDouble(UnpackedPixelData unpackedPixelData, UnpackedPixelData unpackedPixelData2, UnpackedPixelData unpackedPixelData3) {
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int[] nArray = unpackedPixelData.offsets;
        double[][] dArray = unpackedPixelData.getDoubleData();
        int n3 = unpackedPixelData2.lineStride;
        int n4 = unpackedPixelData2.pixelStride;
        int[] nArray2 = unpackedPixelData2.offsets;
        double[][] dArray2 = unpackedPixelData2.getDoubleData();
        int n5 = unpackedPixelData3.rect.width;
        int n6 = unpackedPixelData3.rect.height;
        int n7 = this.dstPA.numBands;
        int n8 = unpackedPixelData3.lineStride;
        int n9 = unpackedPixelData3.pixelStride;
        int[] nArray3 = unpackedPixelData3.offsets;
        double[][] dArray3 = unpackedPixelData3.getDoubleData();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            double[] dArray4 = dArray[n11];
            double[] dArray5 = dArray2[n12];
            double[] dArray6 = dArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n6) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                int n20 = 0;
                while (n20 < n5) {
                    dArray6[n19] = dArray4[n17] + dArray5[n18];
                    n17 += n2;
                    n18 += n4;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectFloat(UnpackedPixelData unpackedPixelData, UnpackedPixelData unpackedPixelData2, UnpackedPixelData unpackedPixelData3) {
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int[] nArray = unpackedPixelData.offsets;
        float[][] fArray = unpackedPixelData.getFloatData();
        int n3 = unpackedPixelData2.lineStride;
        int n4 = unpackedPixelData2.pixelStride;
        int[] nArray2 = unpackedPixelData2.offsets;
        float[][] fArray2 = unpackedPixelData2.getFloatData();
        int n5 = unpackedPixelData3.rect.width;
        int n6 = unpackedPixelData3.rect.height;
        int n7 = this.dstPA.numBands;
        int n8 = unpackedPixelData3.lineStride;
        int n9 = unpackedPixelData3.pixelStride;
        int[] nArray3 = unpackedPixelData3.offsets;
        float[][] fArray3 = unpackedPixelData3.getFloatData();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            float[] fArray4 = fArray[n11];
            float[] fArray5 = fArray2[n12];
            float[] fArray6 = fArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n6) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                int n20 = 0;
                while (n20 < n5) {
                    fArray6[n19] = fArray4[n17] + fArray5[n18];
                    n17 += n2;
                    n18 += n4;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectInt(UnpackedPixelData unpackedPixelData, UnpackedPixelData unpackedPixelData2, UnpackedPixelData unpackedPixelData3) {
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int[] nArray = unpackedPixelData.offsets;
        int[][] nArray2 = unpackedPixelData.getIntData();
        int n3 = unpackedPixelData2.lineStride;
        int n4 = unpackedPixelData2.pixelStride;
        int[] nArray3 = unpackedPixelData2.offsets;
        int[][] nArray4 = unpackedPixelData2.getIntData();
        int n5 = unpackedPixelData3.rect.width;
        int n6 = unpackedPixelData3.rect.height;
        int n7 = this.dstPA.numBands;
        int n8 = unpackedPixelData3.lineStride;
        int n9 = unpackedPixelData3.pixelStride;
        int[] nArray5 = unpackedPixelData3.offsets;
        int[][] nArray6 = unpackedPixelData3.getIntData();
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                while (n10 < n7) {
                    int[] nArray7 = nArray2[n11];
                    int[] nArray8 = nArray4[n12];
                    int[] nArray9 = nArray6[n10];
                    int n13 = nArray[n11];
                    int n14 = nArray3[n12];
                    int n15 = nArray5[n10];
                    int n16 = 0;
                    while (n16 < n6) {
                        int n17 = n13;
                        int n18 = n14;
                        int n19 = n15;
                        n13 += n;
                        n14 += n3;
                        n15 += n8;
                        int n20 = 0;
                        int n21 = 0;
                        while (n21 < n5) {
                            n20 = (nArray7[n17] & 0xFF) + (nArray8[n18] & 0xFF);
                            nArray9[n19] = (n20 << 23 >> 31 | n20) & 0xFF;
                            n17 += n2;
                            n18 += n4;
                            n19 += n9;
                            ++n21;
                        }
                        ++n16;
                    }
                    ++n10;
                    n11 += this.s1bd;
                    n12 += this.s2bd;
                }
                break;
            }
            case 1: {
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                while (n22 < n7) {
                    int[] nArray10 = nArray2[n23];
                    int[] nArray11 = nArray4[n24];
                    int[] nArray12 = nArray6[n22];
                    int n25 = nArray[n23];
                    int n26 = nArray3[n24];
                    int n27 = nArray5[n22];
                    int n28 = 0;
                    while (n28 < n6) {
                        int n29 = n25;
                        int n30 = n26;
                        int n31 = n27;
                        n25 += n;
                        n26 += n3;
                        n27 += n8;
                        int n32 = 0;
                        while (n32 < n5) {
                            nArray12[n31] = ImageUtil.clampUShortPositive((nArray10[n29] & 0xFFFF) + (nArray11[n30] & 0xFFFF));
                            n29 += n2;
                            n30 += n4;
                            n31 += n9;
                            ++n32;
                        }
                        ++n28;
                    }
                    ++n22;
                    n23 += this.s1bd;
                    n24 += this.s2bd;
                }
                break;
            }
            case 2: {
                int n33 = 0;
                int n34 = 0;
                int n35 = 0;
                while (n33 < n7) {
                    int[] nArray13 = nArray2[n34];
                    int[] nArray14 = nArray4[n35];
                    int[] nArray15 = nArray6[n33];
                    int n36 = nArray[n34];
                    int n37 = nArray3[n35];
                    int n38 = nArray5[n33];
                    int n39 = 0;
                    while (n39 < n6) {
                        int n40 = n36;
                        int n41 = n37;
                        int n42 = n38;
                        n36 += n;
                        n37 += n3;
                        n38 += n8;
                        int n43 = 0;
                        while (n43 < n5) {
                            nArray15[n42] = ImageUtil.clampShort(nArray13[n40] + nArray14[n41]);
                            n40 += n2;
                            n41 += n4;
                            n42 += n9;
                            ++n43;
                        }
                        ++n39;
                    }
                    ++n33;
                    n34 += this.s1bd;
                    n35 += this.s2bd;
                }
                break;
            }
            case 3: {
                int n44 = 0;
                int n45 = 0;
                int n46 = 0;
                while (n44 < n7) {
                    int[] nArray16 = nArray2[n45];
                    int[] nArray17 = nArray4[n46];
                    int[] nArray18 = nArray6[n44];
                    int n47 = nArray[n45];
                    int n48 = nArray3[n46];
                    int n49 = nArray5[n44];
                    int n50 = 0;
                    while (n50 < n6) {
                        int n51 = n47;
                        int n52 = n48;
                        int n53 = n49;
                        n47 += n;
                        n48 += n3;
                        n49 += n8;
                        int n54 = 0;
                        while (n54 < n5) {
                            nArray18[n53] = ImageUtil.clampInt((long)nArray16[n51] + (long)nArray17[n52]);
                            n51 += n2;
                            n52 += n4;
                            n53 += n9;
                            ++n54;
                        }
                        ++n50;
                    }
                    ++n44;
                    n45 += this.s1bd;
                    n46 += this.s2bd;
                }
                break;
            }
        }
    }

    private void computeRectShort(UnpackedPixelData unpackedPixelData, UnpackedPixelData unpackedPixelData2, UnpackedPixelData unpackedPixelData3) {
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int[] nArray = unpackedPixelData.offsets;
        short[][] sArray = unpackedPixelData.getShortData();
        int n3 = unpackedPixelData2.lineStride;
        int n4 = unpackedPixelData2.pixelStride;
        int[] nArray2 = unpackedPixelData2.offsets;
        short[][] sArray2 = unpackedPixelData2.getShortData();
        int n5 = unpackedPixelData3.rect.width;
        int n6 = unpackedPixelData3.rect.height;
        int n7 = this.dstPA.numBands;
        int n8 = unpackedPixelData3.lineStride;
        int n9 = unpackedPixelData3.pixelStride;
        int[] nArray3 = unpackedPixelData3.offsets;
        short[][] sArray3 = unpackedPixelData3.getShortData();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n6) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                int n20 = 0;
                while (n20 < n5) {
                    sArray6[n19] = ImageUtil.clampShort(sArray4[n17] + sArray5[n18]);
                    n17 += n2;
                    n18 += n4;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectUShort(UnpackedPixelData unpackedPixelData, UnpackedPixelData unpackedPixelData2, UnpackedPixelData unpackedPixelData3) {
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int[] nArray = unpackedPixelData.offsets;
        short[][] sArray = unpackedPixelData.getShortData();
        int n3 = unpackedPixelData2.lineStride;
        int n4 = unpackedPixelData2.pixelStride;
        int[] nArray2 = unpackedPixelData2.offsets;
        short[][] sArray2 = unpackedPixelData2.getShortData();
        int n5 = unpackedPixelData3.rect.width;
        int n6 = unpackedPixelData3.rect.height;
        int n7 = this.dstPA.numBands;
        int n8 = unpackedPixelData3.lineStride;
        int n9 = unpackedPixelData3.pixelStride;
        int[] nArray3 = unpackedPixelData3.offsets;
        short[][] sArray3 = unpackedPixelData3.getShortData();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n6) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                int n20 = 0;
                while (n20 < n5) {
                    sArray6[n19] = ImageUtil.clampUShortPositive((sArray4[n17] & 0xFFFF) + (sArray5[n18] & 0xFFFF));
                    n17 += n2;
                    n18 += n4;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }
}

