/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.TileCache;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

final class MlibGradientOpImage
extends AreaOpImage {
    protected KernelJAI kernel_h;
    protected KernelJAI kernel_v;
    private int kh;
    private int kw;
    private int kx;
    private int ky;
    float[] kernel_h_data;
    float[] kernel_v_data;
    double[] dbl_kh_data;
    double[] dbl_kv_data;

    public MlibGradientOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, KernelJAI kernelJAI, KernelJAI kernelJAI2) {
        super(renderedImage, borderExtender, tileCache, imageLayout, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding(), true);
        this.kernel_h = kernelJAI;
        this.kernel_v = kernelJAI2;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = this.kw / 2;
        this.ky = this.kh / 2;
        this.kernel_h_data = kernelJAI.getKernelData();
        this.kernel_v_data = kernelJAI2.getKernelData();
        int n = this.kw * this.kh;
        this.dbl_kh_data = new double[n];
        this.dbl_kv_data = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.dbl_kh_data[n2] = this.kernel_h_data[n2];
            this.dbl_kv_data[n2] = this.kernel_v_data[n2];
            ++n2;
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        int n2 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n3 = 0;
        while (n3 < mediaLibImageArray2.length) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 2: 
                case 3: {
                    Image.GradientMxN((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.dbl_kh_data, (double[])this.dbl_kv_data, (int)this.kw, (int)this.kh, (int)this.kx, (int)this.ky, (int)((1 << n2) - 1), (int)0);
                    break;
                }
                case 4: 
                case 5: {
                    Image.GradientMxN_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.dbl_kh_data, (double[])this.dbl_kv_data, (int)this.kw, (int)this.kh, (int)this.kx, (int)this.ky, (int)((1 << n2) - 1), (int)0);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("MlibUshort"));
                }
            }
            ++n3;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

