/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.OutputStream;
import java.util.Vector;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    long firstIFDOffset = 0L;
    boolean skipByte = false;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_PALETTE = 2;
    private static final int TIFF_FULLCOLOR = 3;
    private static final int TIFF_GREYSCALE = 4;
    private static final int COMP_NONE = 1;
    private static final int[] sizeOfType;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        sizeOfType = nArray;
    }

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public final void encode(RenderedImage renderedImage) {
        int n;
        int n2;
        int[] nArray;
        Object[] objectArray;
        byte[] byArray;
        byte[] byArray2;
        int n3 = 1;
        int n4 = renderedImage.getMinX();
        int n5 = renderedImage.getMinY();
        int n6 = renderedImage.getWidth();
        int n7 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n8 = sampleModel.getNumBands();
        int[] nArray2 = sampleModel.getSampleSize();
        int n9 = sampleModel.getDataType();
        if (n9 != 0 && n9 != 2 && n9 != 1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder0"));
        }
        boolean bl = n9 == 2 || n9 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && bl) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder2"));
        }
        IndexColorModel indexColorModel = null;
        int n10 = 0;
        int[] nArray3 = null;
        int n11 = 12;
        if (bl) {
            n11 += 3;
        }
        int n12 = 2;
        int n13 = 3;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            int n14 = indexColorModel.getMapSize();
            if (nArray2[0] == 1) {
                if (n14 != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder1"));
                }
                byArray2 = new byte[n14];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n14];
                indexColorModel.getGreens(byArray);
                objectArray = new byte[n14];
                indexColorModel.getBlues((byte[])objectArray);
                n13 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (objectArray[0] & 0xFF) == 0 && (objectArray[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (objectArray[0] & 0xFF) == 255 && (objectArray[1] & 0xFF) == 0 ? 0 : 2);
            } else {
                n13 = 2;
            }
        } else {
            n13 = (colorModel == null || colorModel.getColorSpace().getType() == 6) && n8 == 1 ? 4 : 3;
        }
        switch (n13) {
            case 0: {
                n12 = 0;
                break;
            }
            case 1: {
                n12 = 1;
                break;
            }
            case 4: {
                n12 = 1;
                break;
            }
            case 2: {
                n12 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n10 = indexColorModel.getMapSize();
                byte[] byArray3 = new byte[n10];
                indexColorModel.getReds(byArray3);
                byArray2 = new byte[n10];
                indexColorModel.getGreens(byArray2);
                byArray = new byte[n10];
                indexColorModel.getBlues(byArray);
                int n15 = 0;
                int n16 = n10;
                int n17 = 2 * n10;
                nArray3 = new int[n10 * 3];
                int n18 = 0;
                while (n18 < n10) {
                    nArray3[n15++] = byArray3[n18] << 8 & 0xFFFF;
                    nArray3[n16++] = byArray2[n18] << 8 & 0xFFFF;
                    nArray3[n17++] = byArray[n18] << 8 & 0xFFFF;
                    ++n18;
                }
                n10 *= 3;
                ++n11;
                break;
            }
            case 3: {
                n12 = 2;
                break;
            }
        }
        long l2 = 8L;
        int n19 = (int)Math.ceil((double)n7 / 8.0);
        objectArray = new long[n19];
        long l3 = (long)Math.ceil((double)nArray2[0] / 8.0 * (double)n6 * (double)n8);
        long l4 = l3 * l2;
        int n20 = 0;
        while (n20 < n19) {
            objectArray[n20] = l4;
            ++n20;
        }
        long l5 = (long)n7 - l2 * (long)(n19 - 1);
        objectArray[n19 - 1] = l5 * l3;
        long l6 = l4 * (long)(n19 - 1) + objectArray[n19 - 1];
        long[] lArray = new long[n19];
        lArray[0] = 8L;
        int n21 = 1;
        while (n21 < n19) {
            lArray[n21] = lArray[n21 - 1] + objectArray[n21 - 1];
            ++n21;
        }
        TIFFField[] tIFFFieldArray = new TIFFField[n11];
        int n22 = 0;
        tIFFFieldArray[n22++] = new TIFFField(256, 4, 1, new long[]{n6});
        tIFFFieldArray[n22++] = new TIFFField(257, 4, 1, new long[]{n7});
        tIFFFieldArray[n22++] = new TIFFField(258, 3, n8, nArray2);
        tIFFFieldArray[n22++] = new TIFFField(259, 3, 1, new int[]{n3});
        tIFFFieldArray[n22++] = new TIFFField(262, 3, 1, new int[]{n12});
        tIFFFieldArray[n22++] = new TIFFField(273, 4, n19, lArray);
        tIFFFieldArray[n22++] = new TIFFField(277, 3, 1, new int[]{n8});
        tIFFFieldArray[n22++] = new TIFFField(278, 4, 1, new long[]{l2});
        tIFFFieldArray[n22++] = new TIFFField(279, 4, n19, objectArray);
        tIFFFieldArray[n22++] = new TIFFField(282, 5, 1, new long[][]{{72L, 1L}});
        tIFFFieldArray[n22++] = new TIFFField(283, 5, 1, new long[][]{{72L, 1L}});
        tIFFFieldArray[n22++] = new TIFFField(296, 3, 1, new int[]{2});
        if (nArray3 != null) {
            tIFFFieldArray[n22++] = new TIFFField(320, 3, n10, nArray3);
        }
        if (bl) {
            nArray = new int[n8];
            nArray[0] = n9 == 1 ? 1 : 2;
            int n23 = 1;
            while (n23 < n8) {
                nArray[n23] = nArray[0];
                ++n23;
            }
            tIFFFieldArray[n22++] = new TIFFField(339, 3, n8, nArray);
            int[] nArray4 = new int[n8];
            nArray4[0] = n9 == 1 ? 0 : Short.MIN_VALUE;
            n2 = 1;
            while (n2 < n8) {
                nArray4[n2] = nArray4[0];
                ++n2;
            }
            tIFFFieldArray[n22++] = new TIFFField(340, 3, n8, nArray4);
            int[] nArray5 = new int[n8];
            nArray5[0] = n9 == 1 ? 65535 : Short.MAX_VALUE;
            n = 1;
            while (n < n8) {
                nArray5[n] = nArray5[0];
                ++n;
            }
            tIFFFieldArray[n22++] = new TIFFField(341, 3, n8, nArray5);
        }
        this.firstIFDOffset = 8L + l6;
        if (this.firstIFDOffset % 2L != 0L) {
            this.skipByte = true;
            ++this.firstIFDOffset;
        }
        this.writeFileHeader(this.firstIFDOffset);
        nArray = new int[8 * n6 * n8];
        byte[] byArray4 = null;
        if (n9 == 0) {
            byArray4 = new byte[8 * n6 * n8];
        } else if (bl) {
            byArray4 = new byte[16 * n6 * n8];
        }
        int n24 = n5 + n7;
        n2 = n5;
        while (n2 < n24) {
            int n25 = Math.min(8, n24 - n2);
            n = n25 * n6 * n8;
            Raster raster = renderedImage.getData(new Rectangle(n4, n2, n6, n25));
            raster.getPixels(n4, n2, n6, n25, nArray);
            int n26 = 0;
            int n27 = 0;
            switch (nArray2[0]) {
                case 1: {
                    int n28;
                    int n29;
                    int n30 = 0;
                    int n31 = 0;
                    while (n31 < n25) {
                        n29 = 0;
                        while (n29 < n6 / 8) {
                            n26 = nArray[n30++] << 7 | nArray[n30++] << 6 | nArray[n30++] << 5 | nArray[n30++] << 4 | nArray[n30++] << 3 | nArray[n30++] << 2 | nArray[n30++] << 1 | nArray[n30++];
                            byArray4[n27++] = (byte)n26;
                            ++n29;
                        }
                        if (n6 % 8 > 0) {
                            n26 = 0;
                            n28 = 0;
                            while (n28 < n6 % 8) {
                                n26 |= nArray[n30++] << 7 - n28;
                                ++n28;
                            }
                            byArray4[n27++] = (byte)n26;
                        }
                        ++n31;
                    }
                    this.output.write(byArray4, 0, n25 * ((n6 + 7) / 8));
                    break;
                }
                case 4: {
                    int n29;
                    int n30 = 0;
                    int n31 = 0;
                    while (n31 < n25) {
                        n29 = 0;
                        while (n29 < n6 / 2) {
                            n26 = nArray[n30++] << 4 | nArray[n30++];
                            byArray4[n27++] = (byte)n26;
                            ++n29;
                        }
                        if (n6 % 2 == 1) {
                            n26 = nArray[n30++] << 4;
                            byArray4[n27++] = (byte)n26;
                        }
                        ++n31;
                    }
                    this.output.write(byArray4, 0, n25 * ((n6 + 1) / 2));
                    break;
                }
                case 8: {
                    int n31 = 0;
                    while (n31 < n) {
                        byArray4[n31] = (byte)nArray[n31];
                        ++n31;
                    }
                    this.output.write(byArray4, 0, n);
                    break;
                }
                case 16: {
                    int n28;
                    int n31 = 0;
                    int n29 = 0;
                    while (n29 < n) {
                        n28 = nArray[n29];
                        byArray4[n31++] = (byte)((n28 & 0xFF00) >> 8);
                        byArray4[n31++] = (byte)(n28 & 0xFF);
                        ++n29;
                    }
                    this.output.write(byArray4, 0, n * 2);
                    break;
                }
            }
            n2 += 8;
        }
        this.writeDirectory(tIFFFieldArray, 0);
    }

    private void writeDirectory(TIFFField[] tIFFFieldArray, int n) {
        if (this.skipByte) {
            this.output.write(0);
        }
        int n2 = tIFFFieldArray.length;
        long l2 = this.firstIFDOffset + (long)(12 * n2) + 4L + 2L;
        Vector<Integer> vector = new Vector<Integer>();
        this.writeUnsignedShort(n2);
        int n3 = 0;
        while (n3 < n2) {
            TIFFField tIFFField = tIFFFieldArray[n3];
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            this.writeLong(n6);
            if (n6 * sizeOfType[n5] > 4) {
                this.writeLong(l2);
                l2 += (long)(n6 * sizeOfType[n5]);
                vector.add(new Integer(n3));
            } else {
                this.writeValuesAsFourBytes(tIFFField);
            }
            ++n3;
        }
        this.writeLong(n);
        int n7 = 0;
        while (n7 < vector.size()) {
            int n8 = (Integer)vector.elementAt(n7);
            this.writeValues(tIFFFieldArray[n8]);
            ++n7;
        }
    }

    private void writeFileHeader(long l2) {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(l2);
    }

    private void writeLong(long l2) {
        this.output.write((int)((l2 & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l2 & 0xFF0000L) >>> 16));
        this.output.write((int)((l2 & 0xFF00L) >>> 8));
        this.output.write((int)l2 & 0xFF);
    }

    private void writeUnsignedShort(int n) {
        this.output.write((n & 0xFF00) >>> 8);
        this.output.write(n & 0xFF);
    }

    private void writeValues(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                byte[] byArray = tIFFField.getAsBytes();
                int n3 = 0;
                while (n3 < n2) {
                    this.output.write(byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 3: {
                int[] nArray = tIFFField.getAsInts();
                int n4 = 0;
                while (n4 < n2) {
                    this.writeUnsignedShort(nArray[n4]);
                    ++n4;
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                int n5 = 0;
                while (n5 < n2) {
                    this.writeLong(lArray[n5]);
                    ++n5;
                }
                break;
            }
            case 5: {
                long[][] lArray = tIFFField.getAsRationals();
                int n6 = 0;
                while (n6 < n2) {
                    this.writeLong(lArray[n6][0]);
                    this.writeLong(lArray[n6][1]);
                    ++n6;
                }
                break;
            }
        }
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                byte[] byArray = tIFFField.getAsBytes();
                int n3 = 0;
                while (n3 < n2) {
                    this.output.write(byArray[n3]);
                    ++n3;
                }
                n3 = 0;
                while (n3 < 4 - n2) {
                    this.output.write(0);
                    ++n3;
                }
                break;
            }
            case 3: {
                int[] nArray = tIFFField.getAsInts();
                int n4 = 0;
                while (n4 < n2) {
                    this.writeUnsignedShort(nArray[n4]);
                    ++n4;
                }
                n4 = 0;
                while (n4 < 2 - n2) {
                    this.writeUnsignedShort(0);
                    ++n4;
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                int n5 = 0;
                while (n5 < n2) {
                    this.writeLong(lArray[n5]);
                    ++n5;
                }
                break;
            }
        }
    }
}

