/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.util.PackedPixelData;
import com.sun.media.jai.util.PixelAccessor;
import com.sun.media.jai.util.UnpackedPixelData;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class PNMImageEncoder
extends ImageEncoderImpl {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.jai.codecimpl.PNMImageEncoder";
    private byte[] lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator")).getBytes();

    public PNMImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new PNMEncodeParam();
        }
    }

    public final void encode(RenderedImage renderedImage) {
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        PixelAccessor pixelAccessor = new PixelAccessor(renderedImage);
        int n5 = pixelAccessor.pixelType;
        int n6 = pixelAccessor.numBands;
        if (n5 < -1 || n5 > 3 || n6 != 1 && n6 != 3) {
            throw new RuntimeException(JaiI18N.getString("PNMImageEncoder0"));
        }
        int n7 = -1;
        switch (n6) {
            case 1: {
                n7 = n5 == -1 ? 52 : (n5 == 0 ? 53 : 50);
                break;
            }
            case 3: {
                n7 = n5 == 0 ? 54 : 51;
                break;
            }
        }
        if (pixelAccessor.packed && pixelAccessor.isMultiPixelPackedSM && pixelAccessor.isIndexCM) {
            IndexColorModel indexColorModel = (IndexColorModel)pixelAccessor.colorModel;
            int[] nArray = new int[indexColorModel.getMapSize()];
            indexColorModel.getRGBs(nArray);
            if ((nArray[0] & 0xFFFFFF) == 0xFFFFFF && (nArray[1] & 0xFFFFFF) == 0) {
                n7 = 52;
            }
        }
        int n8 = 1;
        switch (n5) {
            case 0: {
                n8 = 255;
                break;
            }
            case 1: {
                n8 = 65535;
                break;
            }
            case 2: {
                n8 = Short.MAX_VALUE;
                break;
            }
            case 3: {
                n8 = Integer.MAX_VALUE;
                break;
            }
        }
        if (!((PNMEncodeParam)this.param).getRaw() && this.isRaw(n7)) {
            n7 -= 3;
        }
        this.output.write(80);
        this.output.write(n7);
        this.output.write(this.lineSeparator);
        this.output.write(COMMENT.getBytes());
        this.output.write(this.lineSeparator);
        this.writeInteger(this.output, n3);
        this.output.write(32);
        this.writeInteger(this.output, n4);
        if (n7 != 52 && n7 != 49) {
            this.output.write(this.lineSeparator);
            this.writeInteger(this.output, n8);
        }
        if (this.isRaw(n7)) {
            this.output.write(10);
        }
        n4 += n2;
        int n9 = this.isRaw(n7) ? renderedImage.getTileHeight() : 8;
        switch (n7) {
            case 52: {
                int n10 = (n3 + 7) / 8;
                int n11 = n2;
                while (n11 < n4) {
                    int n12;
                    int n13 = n4 - n11;
                    if (n13 > n9) {
                        n13 = n9;
                    }
                    Rectangle rectangle = new Rectangle(n, n11, n3, n13);
                    Raster raster = renderedImage.getData(rectangle);
                    PackedPixelData packedPixelData = pixelAccessor.getPackedData(raster, rectangle, false);
                    byte[] byArray = packedPixelData.getData();
                    int n14 = packedPixelData.lineStride;
                    int n15 = packedPixelData.bitOffset;
                    if (n15 == 0) {
                        int n16 = 0;
                        n12 = packedPixelData.offsets[0];
                        while (n16 < rectangle.height) {
                            this.output.write(byArray, n12, n10);
                            ++n16;
                            n12 += n14;
                        }
                    } else {
                        byte[] byArray2 = new byte[n10];
                        n12 = n15;
                        int n17 = 8 - n12;
                        int n18 = 0;
                        int n19 = packedPixelData.offsets[0];
                        while (n18 < rectangle.height) {
                            int n20 = 0;
                            int n21 = n19;
                            while (n20 < n10) {
                                byArray2[n20] = (byte)(byArray[n21] << n12 | byArray[n21 + 1] >>> n17);
                                ++n20;
                                ++n21;
                            }
                            this.output.write(byArray2);
                            ++n18;
                            n19 += n14;
                        }
                    }
                    n11 += n9;
                }
                break;
            }
            case 53: {
                int n22 = n2;
                while (n22 < n4) {
                    int n23 = n4 - n22;
                    if (n23 > n9) {
                        n23 = n9;
                    }
                    Rectangle rectangle = new Rectangle(n, n22, n3, n23);
                    Raster raster = renderedImage.getData(rectangle);
                    UnpackedPixelData unpackedPixelData = pixelAccessor.getData(raster, rectangle, 0, false);
                    byte[] byArray = unpackedPixelData.getByteData(0);
                    int n24 = unpackedPixelData.lineStride;
                    int n25 = 0;
                    int n26 = unpackedPixelData.offsets[0];
                    while (n25 < rectangle.height) {
                        this.output.write(byArray, n26, n3);
                        ++n25;
                        n26 += n24;
                    }
                    n22 += n9;
                }
                break;
            }
            case 54: {
                byte[] byArray = new byte[n3 * 3];
                int n27 = n2;
                while (n27 < n4) {
                    int n28 = n4 - n27;
                    if (n28 > n9) {
                        n28 = n9;
                    }
                    Rectangle rectangle = new Rectangle(n, n27, n3, n28);
                    Raster raster = renderedImage.getData(rectangle);
                    UnpackedPixelData unpackedPixelData = pixelAccessor.getData(raster, rectangle, 0, false);
                    byte[][] byArray3 = unpackedPixelData.getByteData();
                    byte[] byArray4 = byArray3[0];
                    byte[] byArray5 = byArray3[1];
                    byte[] byArray6 = byArray3[2];
                    int n29 = unpackedPixelData.lineStride;
                    int n30 = unpackedPixelData.pixelStride;
                    int[] nArray = unpackedPixelData.offsets;
                    int n31 = 0;
                    int n32 = nArray[0];
                    int n33 = nArray[1];
                    int n34 = nArray[2];
                    while (n31 < rectangle.height) {
                        int n35 = 0;
                        int n36 = n32;
                        int n37 = n33;
                        int n38 = n34;
                        while (n35 < n3) {
                            int n39 = n35 * 3;
                            byArray[n39] = byArray4[n36];
                            byArray[n39 + 1] = byArray5[n37];
                            byArray[n39 + 2] = byArray6[n38];
                            ++n35;
                            n36 += n30;
                            n37 += n30;
                            n38 += n30;
                        }
                        this.output.write(byArray);
                        ++n31;
                        n32 += n29;
                        n33 += n29;
                        n34 += n29;
                    }
                    n27 += n9;
                }
                break;
            }
            case 49: {
                int n40 = n2;
                while (n40 < n4) {
                    int n41 = n4 - n40;
                    if (n41 > n9) {
                        n41 = n9;
                    }
                    Rectangle rectangle = new Rectangle(n, n40, n3, n41);
                    Raster raster = renderedImage.getData(rectangle);
                    PackedPixelData packedPixelData = pixelAccessor.getPackedData(raster, rectangle, false);
                    byte[] byArray = packedPixelData.getData();
                    int n42 = packedPixelData.lineStride;
                    int n43 = 0;
                    int n44 = packedPixelData.offsets[0];
                    while (n43 < rectangle.height) {
                        int n45 = 7 - packedPixelData.bitOffset;
                        int n46 = 0;
                        int n47 = n44;
                        while (n46 < n3) {
                            if (n46 % 40 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            int n48 = byArray[n47] >>> n45 & 1;
                            this.writeInteger(this.output, n48);
                            if (--n45 < 0) {
                                n45 = 7;
                                ++n47;
                            }
                            ++n46;
                        }
                        ++n43;
                        n44 += n42;
                    }
                    n40 += n9;
                }
                break;
            }
            case 50: {
                int n49 = n2;
                while (n49 < n4) {
                    int n50 = n4 - n49;
                    if (n50 > n9) {
                        n50 = n9;
                    }
                    Rectangle rectangle = new Rectangle(n, n49, n3, n50);
                    Raster raster = renderedImage.getData(rectangle);
                    UnpackedPixelData unpackedPixelData = pixelAccessor.getData(raster, rectangle, 3, false);
                    int[] nArray = unpackedPixelData.getIntData(0);
                    int n51 = unpackedPixelData.lineStride;
                    int n52 = unpackedPixelData.pixelStride;
                    int n53 = 0;
                    int n54 = unpackedPixelData.offsets[0];
                    while (n53 < rectangle.height) {
                        int n55 = 0;
                        int n56 = n54;
                        while (n55 < n3) {
                            if (n55 % 12 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, nArray[n56]);
                            ++n55;
                            n56 += n52;
                        }
                        ++n53;
                        n54 += n51;
                    }
                    n49 += n9;
                }
                break;
            }
            case 51: {
                int n57 = n2;
                while (n57 < n4) {
                    int n58 = n4 - n57;
                    if (n58 > n9) {
                        n58 = n9;
                    }
                    Rectangle rectangle = new Rectangle(n, n57, n3, n58);
                    Raster raster = renderedImage.getData(rectangle);
                    UnpackedPixelData unpackedPixelData = pixelAccessor.getData(raster, rectangle, 3, false);
                    int[][] nArray = unpackedPixelData.getIntData();
                    int[] nArray2 = nArray[0];
                    int[] nArray3 = nArray[1];
                    int[] nArray4 = nArray[2];
                    int n59 = unpackedPixelData.lineStride;
                    int n60 = unpackedPixelData.pixelStride;
                    int[] nArray5 = unpackedPixelData.offsets;
                    int n61 = 0;
                    int n62 = nArray5[0];
                    int n63 = nArray5[1];
                    int n64 = nArray5[2];
                    while (n61 < rectangle.height) {
                        int n65 = 0;
                        int n66 = n62;
                        int n67 = n63;
                        int n68 = n64;
                        while (n65 < n3) {
                            if ((n65 & 3) == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, nArray2[n66]);
                            this.output.write(32);
                            this.writeInteger(this.output, nArray3[n67]);
                            this.output.write(32);
                            this.writeInteger(this.output, nArray4[n68]);
                            ++n65;
                            n66 += n60;
                            n67 += n60;
                            n68 += n60;
                        }
                        ++n61;
                        n62 += n59;
                        n63 += n59;
                        n64 += n59;
                    }
                    n57 += n9;
                }
                break;
            }
        }
        this.output.flush();
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }

    private void writeByte(OutputStream outputStream, byte by) {
        outputStream.write(Byte.toString(by).getBytes());
    }

    private void writeInteger(OutputStream outputStream, int n) {
        outputStream.write(Integer.toString(n).getBytes());
    }
}

