/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.BMPImageDecoder;
import com.sun.media.jai.codecimpl.BMPImageEncoder;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class BMPCodec
extends ImageCodec {
    static Class class$com$sun$media$jai$codec$BMPEncodeParam;
    static Class class$java$lang$Object;

    public final boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 1 || n == 2 || n == 3 || n == 4 || n == 5) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (!(imageEncodeParam instanceof BMPEncodeParam)) {
                return false;
            }
            BMPEncodeParam bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
            int n2 = bMPEncodeParam.getVersion();
            if (n2 == 0 || n2 == 2) {
                return false;
            }
        }
        return true;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder((InputStream)seekableStream, null);
    }

    protected final ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder(new FileInputStream(file), null);
    }

    protected final ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder(inputStream, null);
    }

    protected final ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        BMPEncodeParam bMPEncodeParam = null;
        if (imageEncodeParam != null) {
            bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
        }
        return new BMPImageEncoder(outputStream, bMPEncodeParam);
    }

    public final Class getDecodeParamClass() {
        return class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = BMPCodec.class$("java.lang.Object"));
    }

    public final Class getEncodeParamClass() {
        return class$com$sun$media$jai$codec$BMPEncodeParam != null ? class$com$sun$media$jai$codec$BMPEncodeParam : (class$com$sun$media$jai$codec$BMPEncodeParam = BMPCodec.class$("com.sun.media.jai.codec.BMPEncodeParam"));
    }

    public final String getFormatName() {
        return "bmp";
    }

    public final int getNumHeaderBytes() {
        return 2;
    }

    public final boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 66 && byArray[1] == 77;
    }
}

