/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SectorStreamSegmentMapper;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.StreamSegment;
import com.sun.media.jai.codec.StreamSegmentMapper;
import com.sun.media.jai.codec.StreamSegmentMapperImpl;
import java.io.IOException;

public class SegmentedSeekableStream
extends SeekableStream {
    private SeekableStream stream;
    private StreamSegmentMapper mapper;
    private long pointer = 0L;
    private boolean canSeekBackwards;
    private StreamSegment streamSegment = new StreamSegment();

    public SegmentedSeekableStream(SeekableStream seekableStream, StreamSegmentMapper streamSegmentMapper, boolean bl) {
        this.stream = seekableStream;
        this.mapper = streamSegmentMapper;
        this.canSeekBackwards = bl;
        if (bl && !seekableStream.canSeekBackwards()) {
            throw new IllegalArgumentException(JaiI18N.getString("SegmentedSeekableStream0"));
        }
    }

    public SegmentedSeekableStream(SeekableStream seekableStream, long[] lArray, int n, int n2, boolean bl) {
        this(seekableStream, new SectorStreamSegmentMapper(lArray, n, n2), bl);
    }

    public SegmentedSeekableStream(SeekableStream seekableStream, long[] lArray, int[] nArray, boolean bl) {
        this(seekableStream, new StreamSegmentMapperImpl(lArray, nArray), bl);
    }

    public final boolean canSeekBackwards() {
        return this.canSeekBackwards;
    }

    public final long getFilePointer() {
        return this.pointer;
    }

    public final int read() {
        this.mapper.getStreamSegment(this.pointer, 1, this.streamSegment);
        this.stream.seek(this.streamSegment.getStartPos());
        int n = this.stream.read();
        ++this.pointer;
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.mapper.getStreamSegment(this.pointer, n2, this.streamSegment);
        this.stream.seek(this.streamSegment.getStartPos());
        int n3 = this.stream.read(byArray, n, this.streamSegment.getSegmentLength());
        this.pointer += (long)n3;
        return n3;
    }

    public final void seek(long l2) {
        if (l2 < 0L) {
            throw new IOException();
        }
        this.pointer = l2;
    }
}

