/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.FileCacheSeekableStream;
import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class SeekableStream
extends InputStream
implements DataInput {
    protected long markPos = -1L;
    private byte[] ruileBuf = new byte[4];

    public boolean canSeekBackwards() {
        return false;
    }

    protected final void finalize() {
        super.finalize();
        this.close();
    }

    public abstract long getFilePointer();

    public synchronized void mark(int n) {
        try {
            this.markPos = this.getFilePointer();
        }
        catch (IOException iOException) {
            this.markPos = -1L;
        }
    }

    public boolean markSupported() {
        return this.canSeekBackwards();
    }

    public abstract int read();

    public abstract int read(byte[] var1, int var2, int var3);

    public final boolean readBoolean() {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final char readChar() {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public final char readCharLE() {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n << 8) + n2);
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double readDoubleLE() {
        return Double.longBitsToDouble(this.readLongLE());
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float readFloatLE() {
        return Float.intBitsToFloat(this.readIntLE());
    }

    public final void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public final int readInt() {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final int readIntLE() {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public final String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    break;
                }
                case 13: {
                    bl = true;
                    long l2 = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l2);
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                    break;
                }
            }
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final long readLongLE() {
        int n = this.readIntLE();
        int n2 = this.readIntLE();
        return ((long)n2 << 32) + ((long)n & 0xFFFFFFFFL);
    }

    public final short readShort() {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final short readShortLE() {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n << 8) + n2);
    }

    public final String readUTF() {
        return DataInputStream.readUTF(this);
    }

    public final int readUnsignedByte() {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final long readUnsignedInt() {
        long l2;
        long l3;
        long l4;
        long l5 = this.read();
        if ((l5 | (l4 = (long)this.read()) | (l3 = (long)this.read()) | (l2 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (l5 << 24) + (l4 << 16) + (l3 << 8) + l2;
    }

    public final long readUnsignedIntLE() {
        this.readFully(this.ruileBuf);
        long l2 = this.ruileBuf[0] & 0xFF;
        long l3 = this.ruileBuf[1] & 0xFF;
        long l4 = this.ruileBuf[2] & 0xFF;
        long l5 = this.ruileBuf[3] & 0xFF;
        return (l5 << 24) + (l4 << 16) + (l3 << 8) + l2;
    }

    public final int readUnsignedShort() {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public final int readUnsignedShortLE() {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n << 8) + n2;
    }

    public synchronized void reset() {
        if (this.markPos != -1L) {
            this.seek(this.markPos);
        }
    }

    public abstract void seek(long var1);

    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        return (int)this.skip(n);
    }

    public static final SeekableStream wrapInputStream(InputStream inputStream, boolean bl) {
        SeekableStream seekableStream = null;
        if (bl) {
            try {
                seekableStream = new FileCacheSeekableStream(inputStream);
            }
            catch (Exception exception) {
                seekableStream = new MemoryCacheSeekableStream(inputStream);
            }
        } else {
            seekableStream = new ForwardSeekableStream(inputStream);
        }
        return seekableStream;
    }
}

