/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.PNGEncodeParam$Gray;
import com.sun.media.jai.codec.PNGEncodeParam$Palette;
import com.sun.media.jai.codec.PNGEncodeParam$RGB;
import com.sun.media.jai.codec.PNGSuggestedPaletteEntry;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Date;
import java.util.Vector;

public abstract class PNGEncodeParam
implements ImageEncodeParam {
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE = 3;
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    protected int bitDepth;
    protected boolean bitDepthSet = false;
    private boolean useInterlacing = false;
    private float[] chromaticity = null;
    private boolean chromaticitySet = false;
    private float gamma;
    private boolean gammaSet = false;
    private int[] paletteHistogram = null;
    private boolean paletteHistogramSet = false;
    private byte[] ICCProfileData = null;
    private boolean ICCProfileDataSet = false;
    private int[] physicalDimension = null;
    private boolean physicalDimensionSet = false;
    private PNGSuggestedPaletteEntry[] suggestedPalette = null;
    private boolean suggestedPaletteSet = false;
    private int[] significantBits = null;
    private boolean significantBitsSet = false;
    private int SRGBIntent;
    private boolean SRGBIntentSet = false;
    private String[] text = null;
    private boolean textSet = false;
    private Date modificationTime;
    private boolean modificationTimeSet = false;
    boolean transparencySet = false;
    private String[] zText = null;
    private boolean zTextSet = false;
    Vector chunkType = new Vector();
    Vector chunkData = new Vector();

    private static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public final synchronized void addPrivateChunk(String string, byte[] byArray) {
        this.chunkType.add(string);
        this.chunkData.add((byte[])byArray.clone());
    }

    public final int filterRow(byte[] byArray, byte[] byArray2, byte[][] byArray3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int[] nArray = new int[5];
        int n12 = 0;
        while (n12 < 5) {
            nArray[n12] = Integer.MAX_VALUE;
            ++n12;
        }
        int n13 = 0;
        int n14 = n2;
        while (n14 < n + n2) {
            int n15 = byArray[n14] & 0xFF;
            n13 += n15;
            ++n14;
        }
        nArray[0] = n13;
        byte[] byArray4 = byArray3[1];
        int n16 = 0;
        int n17 = n2;
        while (n17 < n + n2) {
            int n18 = byArray[n17] & 0xFF;
            n11 = byArray[n17 - n2] & 0xFF;
            n10 = n18 - n11;
            byArray4[n17] = (byte)n10;
            n16 += PNGEncodeParam.abs(n10);
            ++n17;
        }
        nArray[1] = n16;
        byte[] byArray5 = byArray3[2];
        n11 = 0;
        n10 = n2;
        while (n10 < n + n2) {
            int n19 = byArray[n10] & 0xFF;
            n9 = byArray2[n10] & 0xFF;
            n8 = n19 - n9;
            byArray5[n10] = (byte)n8;
            n11 += PNGEncodeParam.abs(n8);
            ++n10;
        }
        nArray[2] = n11;
        byte[] byArray6 = byArray3[3];
        n9 = 0;
        n8 = n2;
        while (n8 < n + n2) {
            int n20 = byArray[n8] & 0xFF;
            n7 = byArray[n8 - n2] & 0xFF;
            n6 = byArray2[n8] & 0xFF;
            n5 = n20 - (n7 + n6) / 2;
            byArray6[n8] = (byte)n5;
            n9 += PNGEncodeParam.abs(n5);
            ++n8;
        }
        nArray[3] = n9;
        byte[] byArray7 = byArray3[4];
        n7 = 0;
        n6 = n2;
        while (n6 < n + n2) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray[n6 - n2] & 0xFF;
            n3 = byArray2[n6] & 0xFF;
            int n21 = byArray2[n6 - n2] & 0xFF;
            int n22 = PNGEncodeParam.paethPredictor(n4, n3, n21);
            int n23 = n5 - n22;
            byArray7[n6] = (byte)n23;
            n7 += PNGEncodeParam.abs(n23);
            ++n6;
        }
        nArray[4] = n7;
        n5 = 0;
        n4 = nArray[0];
        n3 = 1;
        while (n3 < 5) {
            if (nArray[n3] < n4) {
                n4 = nArray[n3];
                n5 = n3;
            }
            ++n3;
        }
        if (n5 == 0) {
            System.arraycopy(byArray, n2, byArray3[0], n2, n);
        }
        return n5;
    }

    public final int getBitDepth() {
        if (!this.bitDepthSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam11"));
        }
        return this.bitDepth;
    }

    public final float[] getChromaticity() {
        if (!this.chromaticitySet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam12"));
        }
        return (float[])this.chromaticity.clone();
    }

    public final String[] getCompressedText() {
        if (!this.zTextSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam22"));
        }
        return this.zText;
    }

    public static final PNGEncodeParam getDefaultEncodeParam(RenderedImage renderedImage) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return new PNGEncodeParam$Palette();
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        if (n == 1 || n == 2) {
            return new PNGEncodeParam$Gray();
        }
        return new PNGEncodeParam$RGB();
    }

    public final float getGamma() {
        if (!this.gammaSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam13"));
        }
        return this.gamma;
    }

    public final byte[] getICCProfileData() {
        if (!this.ICCProfileDataSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam15"));
        }
        return (byte[])this.ICCProfileData.clone();
    }

    public final boolean getInterlacing() {
        return this.useInterlacing;
    }

    public final Date getModificationTime() {
        if (!this.modificationTimeSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam21"));
        }
        return this.modificationTime;
    }

    public final synchronized int getNumPrivateChunks() {
        return this.chunkType.size();
    }

    public final int[] getPaletteHistogram() {
        if (!this.paletteHistogramSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam14"));
        }
        return this.paletteHistogram;
    }

    public final int[] getPhysicalDimension() {
        if (!this.physicalDimensionSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam16"));
        }
        return (int[])this.physicalDimension.clone();
    }

    public final synchronized byte[] getPrivateChunkData(int n) {
        return (byte[])this.chunkData.elementAt(n);
    }

    public final synchronized String getPrivateChunkType(int n) {
        return (String)this.chunkType.elementAt(n);
    }

    public final int getSRGBIntent() {
        if (!this.SRGBIntentSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam19"));
        }
        return this.SRGBIntent;
    }

    public final int[] getSignificantBits() {
        if (!this.significantBitsSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam18"));
        }
        return (int[])this.significantBits.clone();
    }

    public final PNGSuggestedPaletteEntry[] getSuggestedPalette() {
        if (!this.suggestedPaletteSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam17"));
        }
        return (PNGSuggestedPaletteEntry[])this.suggestedPalette.clone();
    }

    public final String[] getText() {
        if (!this.textSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam20"));
        }
        return this.text;
    }

    public boolean isBackgroundSet() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam24"));
    }

    public final boolean isChromaticitySet() {
        return this.chromaticitySet;
    }

    public final boolean isCompressedTextSet() {
        return this.zTextSet;
    }

    public final boolean isGammaSet() {
        return this.gammaSet;
    }

    public final boolean isICCProfileDataSet() {
        return this.ICCProfileDataSet;
    }

    public final boolean isModificationTimeSet() {
        return this.modificationTimeSet;
    }

    public final boolean isPaletteHistogramSet() {
        return this.paletteHistogramSet;
    }

    public final boolean isPhysicalDimensionSet() {
        return this.physicalDimensionSet;
    }

    public final boolean isSRGBIntentSet() {
        return this.SRGBIntentSet;
    }

    public final boolean isSignificantBitsSet() {
        return this.significantBitsSet;
    }

    public final boolean isSuggestedPaletteSet() {
        return this.suggestedPaletteSet;
    }

    public final boolean isTextSet() {
        return this.textSet;
    }

    public final boolean isTransparencySet() {
        return this.transparencySet;
    }

    public static final int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = PNGEncodeParam.abs(n4 - n);
        int n6 = PNGEncodeParam.abs(n4 - n2);
        int n7 = PNGEncodeParam.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    public final synchronized void removeAllPrivateChunks() {
        this.chunkType = new Vector();
        this.chunkData = new Vector();
    }

    public final synchronized void removeUnsafeToCopyPrivateChunks() {
        Vector<String> vector = new Vector<String>();
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n = this.getNumPrivateChunks();
        int n2 = 0;
        while (n2 < n) {
            String string = this.getPrivateChunkType(n2);
            char c2 = string.charAt(3);
            if (c2 >= 'a' && c2 <= 'z') {
                vector.add(string);
                vector2.add(this.getPrivateChunkData(n2));
            }
            ++n2;
        }
        this.chunkType = vector;
        this.chunkData = vector2;
    }

    public abstract void setBitDepth(int var1);

    public final void setChromaticity(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float[] fArray = new float[]{f2, f3, f4, f5, f6, f7, f8, f9};
        this.setChromaticity(fArray);
    }

    public final void setChromaticity(float[] fArray) {
        if (fArray.length != 8) {
            throw new IllegalArgumentException();
        }
        this.chromaticity = (float[])fArray.clone();
        this.chromaticitySet = true;
    }

    public final void setCompressedText(String[] stringArray) {
        this.zText = stringArray;
        this.zTextSet = true;
    }

    public final void setGamma(float f2) {
        this.gamma = f2;
        this.gammaSet = true;
    }

    public final void setICCProfileData(byte[] byArray) {
        this.ICCProfileData = (byte[])byArray.clone();
        this.ICCProfileDataSet = true;
    }

    public final void setInterlacing(boolean bl) {
        this.useInterlacing = bl;
    }

    public final void setModificationTime(Date date) {
        this.modificationTime = date;
        this.modificationTimeSet = true;
    }

    public final void setPaletteHistogram(int[] nArray) {
        this.paletteHistogram = (int[])nArray.clone();
        this.paletteHistogramSet = true;
    }

    public final void setPhysicalDimension(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        this.setPhysicalDimension(nArray);
    }

    public final void setPhysicalDimension(int[] nArray) {
        this.physicalDimension = (int[])nArray.clone();
        this.physicalDimensionSet = true;
    }

    public final void setSRGBIntent(int n) {
        this.SRGBIntent = n;
        this.SRGBIntentSet = true;
    }

    public final void setSignificantBits(int[] nArray) {
        this.significantBits = (int[])nArray.clone();
        this.significantBitsSet = true;
    }

    public final void setSuggestedPalette(PNGSuggestedPaletteEntry[] pNGSuggestedPaletteEntryArray) {
        this.suggestedPalette = (PNGSuggestedPaletteEntry[])pNGSuggestedPaletteEntryArray.clone();
        this.suggestedPaletteSet = true;
    }

    public final void setText(String[] stringArray) {
        this.text = stringArray;
        this.textSet = true;
    }

    public void unsetBackground() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam23"));
    }

    public final void unsetBitDepth() {
        this.bitDepthSet = false;
    }

    public final void unsetChromaticity() {
        this.chromaticity = null;
        this.chromaticitySet = false;
    }

    public final void unsetCompressedText() {
        this.zText = null;
        this.zTextSet = false;
    }

    public final void unsetGamma() {
        this.gammaSet = false;
    }

    public final void unsetICCProfileData() {
        this.ICCProfileData = null;
        this.ICCProfileDataSet = false;
    }

    public final void unsetModificationTime() {
        this.modificationTime = null;
        this.modificationTimeSet = false;
    }

    public final void unsetPaletteHistogram() {
        this.paletteHistogram = null;
        this.paletteHistogramSet = false;
    }

    public final void unsetPhysicalDimension() {
        this.physicalDimension = null;
        this.physicalDimensionSet = false;
    }

    public final void unsetSRGBIntent() {
        this.SRGBIntentSet = false;
    }

    public final void unsetSignificantBits() {
        this.significantBits = null;
        this.significantBitsSet = false;
    }

    public final void unsetSuggestedPalette() {
        this.suggestedPalette = null;
        this.suggestedPaletteSet = false;
    }

    public final void unsetText() {
        this.text = null;
        this.textSet = false;
    }

    public final void unsetTransparency() {
        this.transparencySet = false;
    }
}

