/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.PortingUtils$1;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class PortingUtils {
    private static Rectangle SCREEN_BOUNDS = null;
    private static Area SCREEN_AREA;
    private static Rectangle[] SCREENS;
    private static Insets[] INSETS;
    private static Thread _initializationThread;
    public static boolean INITIALIZE_SCREEN_AREA_USING_THREAD;

    public static final Component getCurrentFocusComponent(AWTEvent aWTEvent) {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public static final int getFrameState(Frame frame) {
        return frame.getExtendedState();
    }

    public static final void setFrameState(Frame frame, int n) {
        frame.setExtendedState(n);
    }

    public static final int getMouseModifiers(MouseEvent mouseEvent) {
        return mouseEvent.getModifiersEx();
    }

    public static final void removeFocus(JComponent jComponent) {
        jComponent.setRequestFocusEnabled(false);
        jComponent.setFocusable(false);
    }

    public static final void removeButtonBorder(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        abstractButton.setBorder(BorderFactory.createEmptyBorder());
    }

    public static final Rectangle containsInScreenBounds(Component component, Rectangle rectangle) {
        return PortingUtils.containsInScreenBounds(component, rectangle, false);
    }

    public static final Rectangle containsInScreenBounds(Component component, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = PortingUtils.getScreenBounds(component, bl);
        Point point = rectangle.getLocation();
        if (point.x + rectangle.width > rectangle2.x + rectangle2.width) {
            point.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (point.y + rectangle.height > rectangle2.y + rectangle2.height) {
            point.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
        if (point.x < rectangle2.x) {
            point.x = rectangle2.x;
        }
        if (point.y < rectangle2.y) {
            point.y = rectangle2.y;
        }
        return new Rectangle(point, rectangle.getSize());
    }

    public static final Rectangle overlapWithScreenBounds(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = PortingUtils.getScreenBounds(component);
        Point point = rectangle.getLocation();
        if (point.x > rectangle2.x + rectangle2.width) {
            point.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (point.y > rectangle2.y + rectangle2.height) {
            point.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
        if (point.x + rectangle.width < rectangle2.x) {
            point.x = rectangle2.x;
        }
        if (point.y + rectangle.height < rectangle2.y) {
            point.y = rectangle2.y;
        }
        return new Rectangle(point, rectangle.getSize());
    }

    public static final Dimension getScreenSize(Component component) {
        PortingUtils.ensureScreenBounds();
        Dimension dimension = SCREEN_BOUNDS.getSize();
        if (component != null && !(component instanceof JApplet) && component.getGraphicsConfiguration() != null) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(component.getGraphicsConfiguration());
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
        }
        return dimension;
    }

    public static final Dimension getLocalScreenSize(Component component) {
        PortingUtils.ensureScreenBounds();
        if (component != null && !(component instanceof JApplet) && component.getGraphicsConfiguration() != null) {
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle.getSize();
        }
        return PortingUtils.getScreenSize(component);
    }

    public static final Rectangle getScreenBounds(Component component, boolean bl) {
        Rectangle rectangle;
        PortingUtils.ensureScreenBounds();
        Rectangle rectangle2 = rectangle = !bl || component == null || component.getGraphicsConfiguration() == null ? (Rectangle)SCREEN_BOUNDS.clone() : component.getGraphicsConfiguration().getBounds();
        if (component != null && !(component instanceof JApplet) && component.getGraphicsConfiguration() != null) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(component.getGraphicsConfiguration());
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
        return rectangle;
    }

    public static final Rectangle getScreenBounds(Component component) {
        return PortingUtils.getScreenBounds(component, false);
    }

    public static final Rectangle getLocalScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getMaximumWindowBounds();
    }

    private static void ensureScreenBounds() {
        if (SCREEN_BOUNDS == null) {
            GraphicsDevice[] graphicsDeviceArray;
            SCREEN_BOUNDS = new Rectangle();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
                GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                SCREEN_BOUNDS = SCREEN_BOUNDS.union(graphicsConfiguration.getBounds());
            }
        }
    }

    public static final synchronized void initializeScreenArea() {
        PortingUtils.initializeScreenArea(5);
    }

    public static final synchronized void initializeScreenArea(int n) {
        if (_initializationThread == null) {
            _initializationThread = new PortingUtils$1();
            _initializationThread.setPriority(n);
            if (INITIALIZE_SCREEN_AREA_USING_THREAD) {
                _initializationThread.start();
            } else {
                _initializationThread.run();
            }
        }
    }

    public static final boolean isInitializationThreadAlive() {
        return _initializationThread != null && _initializationThread.isAlive();
    }

    public static final boolean isInitalizationThreadStarted() {
        return _initializationThread != null;
    }

    private static void waitForInitialization() {
        PortingUtils.initializeScreenArea();
        while (_initializationThread != null && _initializationThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static final Rectangle ensureVisible(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = PortingUtils.getLocalScreenBounds();
        if (!rectangle2.contains(rectangle.getLocation())) {
            Rectangle rectangle3 = PortingUtils.getScreenBounds(component, false);
            if (rectangle.x > rectangle3.x + rectangle3.width || rectangle.x < rectangle3.x) {
                rectangle.x = rectangle2.x;
            }
            if (rectangle.y > rectangle3.y + rectangle3.height || rectangle.y < rectangle3.y) {
                rectangle.y = rectangle2.y;
            }
        }
        return rectangle;
    }

    public static final Rectangle ensureOnScreen(Rectangle rectangle) {
        int n;
        int n2;
        Rectangle rectangle2 = PortingUtils.getLocalScreenBounds();
        if (rectangle2.contains(rectangle)) {
            return rectangle;
        }
        PortingUtils.waitForInitialization();
        if (SCREEN_AREA.contains(rectangle)) {
            return rectangle;
        }
        Rectangle rectangle3 = null;
        Point point = rectangle.getLocation();
        for (Rectangle rectangle4 : SCREENS) {
            if (!rectangle4.contains(point)) continue;
            rectangle3 = rectangle4;
            break;
        }
        for (Rectangle rectangle4 : SCREENS) {
            if (!rectangle4.intersects(rectangle)) continue;
            rectangle3 = rectangle4;
            break;
        }
        if (rectangle3 == null) {
            rectangle.x = (PortingUtils.SCREENS[0].width - rectangle.width) / 2;
            rectangle.y = (PortingUtils.SCREENS[0].width - rectangle.width) / 2;
            return rectangle;
        }
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle3.x + rectangle3.width;
        if (n3 > n4) {
            rectangle.x = n4 - rectangle.width;
        }
        if (rectangle.x < rectangle3.x) {
            rectangle.x = rectangle3.x;
        }
        if ((n2 = rectangle.y + rectangle.height) > (n = rectangle3.y + rectangle3.height)) {
            rectangle.y = n - rectangle.height;
        }
        if (rectangle.y < rectangle3.y) {
            rectangle.y = rectangle3.y;
        }
        return rectangle;
    }

    public static final Rectangle getContainingScreenBounds(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2;
        int n;
        PortingUtils.waitForInitialization();
        Rectangle rectangle3 = null;
        Insets insets = null;
        Point point = rectangle.getLocation();
        for (n = 0; n < SCREENS.length; ++n) {
            rectangle2 = SCREENS[n];
            if (!rectangle2.contains(point)) continue;
            rectangle3 = rectangle2;
            insets = INSETS[n];
            break;
        }
        for (n = 0; n < SCREENS.length; ++n) {
            rectangle2 = SCREENS[n];
            if (!rectangle2.intersects(rectangle)) continue;
            rectangle3 = rectangle2;
            insets = INSETS[n];
            break;
        }
        if (rectangle3 == null) {
            rectangle3 = SCREENS[0];
            insets = INSETS[0];
        }
        Rectangle rectangle4 = new Rectangle(rectangle3);
        if (bl && insets != null) {
            rectangle4.x += insets.left;
            rectangle4.y += insets.top;
            rectangle4.width -= insets.left + insets.right;
            rectangle4.height -= insets.top + insets.bottom;
        }
        return rectangle4;
    }

    public static final Area getScreenArea() {
        PortingUtils.waitForInitialization();
        return SCREEN_AREA;
    }

    public static final void notifyUser() {
        PortingUtils.notifyUser(null);
    }

    public static final void notifyUser(Component component) {
        String string = SecurityUtils.getProperty("jide.beepNotifyUser", "true");
        if ("true".equals(string)) {
            UIManager.getLookAndFeel().provideErrorFeedback(component);
        }
    }

    public static final void prerequisiteChecking() {
        if (!SystemInfo.isJdk14Above()) {
            PortingUtils.notifyUser();
            JOptionPane.showMessageDialog(null, "J2SE 1.4 or above is required for this demo.", "JIDE Software, Inc.", 2);
            System.exit(0);
        }
        if (!SystemInfo.isJdk142Above()) {
            PortingUtils.notifyUser();
            JOptionPane.showMessageDialog(null, "J2SE 1.4.2 or above is recommended for this demo for the best experience of seamless integration with Windows XP.", "JIDE Software, Inc.", 2);
        }
        if (SystemInfo.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.brushMetalLook", "true");
        }
    }

    public static final void setPreferredSize(Component component, Dimension dimension) {
        if (SystemInfo.isJdk15Above()) {
            component.setPreferredSize(dimension);
        } else if (component instanceof JComponent) {
            ((JComponent)component).setPreferredSize(dimension);
        }
    }

    public static final void setMinimumSize(Component component, Dimension dimension) {
        if (SystemInfo.isJdk15Above()) {
            component.setMinimumSize(dimension);
        } else if (component instanceof JComponent) {
            ((JComponent)component).setMinimumSize(dimension);
        }
    }

    static final /* synthetic */ Area access$002(Area area) {
        SCREEN_AREA = area;
        return SCREEN_AREA;
    }

    static final /* synthetic */ Rectangle access$102(Rectangle rectangle) {
        SCREEN_BOUNDS = rectangle;
        return SCREEN_BOUNDS;
    }

    static final /* synthetic */ Area access$000() {
        return SCREEN_AREA;
    }

    static final /* synthetic */ Rectangle access$100() {
        return SCREEN_BOUNDS;
    }

    static final /* synthetic */ Rectangle[] access$202(Rectangle[] rectangleArray) {
        SCREENS = rectangleArray;
        return rectangleArray;
    }

    static final /* synthetic */ Insets[] access$302(Insets[] insetsArray) {
        INSETS = insetsArray;
        return insetsArray;
    }

    static final /* synthetic */ Thread access$402(Thread thread) {
        _initializationThread = thread;
        return _initializationThread;
    }

    static {
        _initializationThread = null;
        INITIALIZE_SCREEN_AREA_USING_THREAD = true;
    }
}

