/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;

public class VisibilityFocusTraversalPolicy
extends FocusTraversalPolicy {
    private FocusTraversalPolicy _defaultPolicy;
    private Set _containers;

    public VisibilityFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        this(focusTraversalPolicy, null);
    }

    public VisibilityFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy, Container container) {
        if (focusTraversalPolicy != null && focusTraversalPolicy.getClass().getName().contains("LegacyGlueFocusTraversalPolicy")) {
            throw new IllegalArgumentException("VisibilityFocusTraversalPolicy can't work well with LegacyGlueFocusTraversalPolicy.");
        }
        this._defaultPolicy = focusTraversalPolicy;
        if (container != null) {
            this._containers = new HashSet();
            this._containers.add(container);
        }
    }

    public final void addContainer(Container container) {
        if (this._containers == null) {
            this._containers = new HashSet();
        }
        this._containers.add(container);
    }

    public final void removeContainer(Container container) {
        if (this._containers != null) {
            this._containers.remove(container);
        }
    }

    public final Container[] getContainers() {
        if (this._containers == null) {
            return new Container[0];
        }
        return this._containers.toArray(new Container[this._containers.size()]);
    }

    public final FocusTraversalPolicy getDefaultPolicy() {
        return this._defaultPolicy;
    }

    public final Component getComponentAfter(Container container, Component component) {
        if (this._defaultPolicy == null) {
            return null;
        }
        Component component2 = this._defaultPolicy.getComponentAfter(container, component);
        boolean bl = true;
        block0: while (component2 != null && component != component2 && bl) {
            bl = false;
            for (Container container2 : this._containers) {
                if (!container2.isAncestorOf(component2)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), component2.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component2;
                }
                component2 = this._defaultPolicy.getComponentAfter(container, component2);
                bl = true;
                continue block0;
            }
        }
        return component2;
    }

    public final Component getComponentBefore(Container container, Component component) {
        if (this._defaultPolicy == null) {
            return null;
        }
        Component component2 = this._defaultPolicy.getComponentBefore(container, component);
        boolean bl = true;
        block0: while (component2 != null && component != component2 && bl) {
            bl = false;
            for (Container container2 : this._containers) {
                if (!container2.isAncestorOf(component2)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), component2.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component2;
                }
                component2 = this._defaultPolicy.getComponentBefore(container, component2);
                bl = true;
                continue block0;
            }
        }
        return component2;
    }

    public final Component getFirstComponent(Container container) {
        boolean bl;
        Component component;
        if (this._defaultPolicy == null) {
            return null;
        }
        Component component2 = component = this._defaultPolicy.getFirstComponent(container);
        block0: do {
            bl = false;
            for (Container container2 : this._containers) {
                if (!container2.isAncestorOf(component)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component;
                }
                component = this._defaultPolicy.getComponentAfter(container, component);
                bl = true;
                continue block0;
            }
        } while (component != null && component2 != component && bl);
        return component;
    }

    public final Component getLastComponent(Container container) {
        boolean bl;
        Component component;
        if (this._defaultPolicy == null) {
            return null;
        }
        Component component2 = component = this._defaultPolicy.getLastComponent(container);
        block0: do {
            bl = false;
            for (Container container2 : this._containers) {
                if (!container2.isAncestorOf(component)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component;
                }
                component = this._defaultPolicy.getComponentBefore(container, component);
                bl = true;
                continue block0;
            }
        } while (component != null && component2 != component && bl);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component getDefaultComponent(Container container) {
        boolean bl;
        Component component;
        if (this._defaultPolicy == null) {
            return null;
        }
        Component component2 = component = this._defaultPolicy.getDefaultComponent(container);
        boolean bl2 = bl = this._defaultPolicy instanceof SortingFocusTraversalPolicy && ((SortingFocusTraversalPolicy)this._defaultPolicy).getImplicitDownCycleTraversal();
        if (this._defaultPolicy instanceof SortingFocusTraversalPolicy) {
            ((SortingFocusTraversalPolicy)this._defaultPolicy).setImplicitDownCycleTraversal(false);
        }
        try {
            boolean bl3;
            block4: do {
                bl3 = false;
                for (Container container2 : this._containers) {
                    if (!container2.isAncestorOf(component)) continue;
                    Rectangle rectangle = container2.getBounds();
                    Container container3 = container2.getParent();
                    Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), container3);
                    if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                        Component component3 = component;
                        return component3;
                    }
                    component = this._defaultPolicy.getComponentAfter(container, component);
                    bl3 = true;
                    continue block4;
                }
            } while (component != null && component2 != component && bl3);
            Component component4 = component;
            return component4;
        }
        finally {
            if (this._defaultPolicy instanceof SortingFocusTraversalPolicy) {
                ((SortingFocusTraversalPolicy)this._defaultPolicy).setImplicitDownCycleTraversal(bl);
            }
        }
    }

    public final Component getInitialComponent(Window window) {
        if (this._defaultPolicy == null) {
            return null;
        }
        return this._defaultPolicy.getInitialComponent(window);
    }
}

