/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder$ParsedStyleResult;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StyledLabelBuilder {
    private StringBuffer buffer = new StringBuffer();
    private List ranges = new ArrayList();
    private int start = 0;
    private Map styles = new HashMap();
    private static int[] colorShorthandTable = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static Map colorNamesMap = new TreeMap();

    public final void clear() {
        this.buffer.delete(0, this.buffer.length());
        this.ranges.clear();
        this.start = 0;
    }

    public final StyledLabelBuilder register(String string, Color color) {
        this.styles.put(string, new StyleRange(color));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n) {
        this.styles.put(string, new StyleRange(n));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n, Color color) {
        this.styles.put(string, new StyleRange(n, color));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n, Color color, int n2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n, Color color, int n2, Color color2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2, color2));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n, Color color, int n2, Color color2, Stroke stroke) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2, color2, stroke));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n, Color color, int n2, Color color2, Stroke stroke, float f2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, color, n2, color2, stroke, f2));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n, int n2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, n2));
        return this;
    }

    public final StyledLabelBuilder register(String string, int n, int n2, float f2) {
        this.styles.put(string, new StyleRange(this.start, string.length(), n, n2, f2));
        return this;
    }

    public final StyledLabelBuilder register(String string, String string2) {
        StyledLabelBuilder$ParsedStyleResult styledLabelBuilder$ParsedStyleResult = StyledLabelBuilder.parseStyleAnnotation(string2.toCharArray(), 0, this);
        this.styles.put(string, new StyleRange(styledLabelBuilder$ParsedStyleResult.fontStyle, styledLabelBuilder$ParsedStyleResult.fontColor, styledLabelBuilder$ParsedStyleResult.backgroundColor, styledLabelBuilder$ParsedStyleResult.additionalStyle, styledLabelBuilder$ParsedStyleResult.lineColor));
        return this;
    }

    public final StyledLabelBuilder add(String string) {
        this.buffer.append(string);
        this.start += string.length();
        return this;
    }

    public final StyledLabelBuilder add(String string, Color color) {
        this.ranges.add(new StyleRange(this.start, string.length(), color));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n) {
        this.ranges.add(new StyleRange(this.start, string.length(), n));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n, Color color) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n, Color color, int n2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, n2));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n, Color color, int n2, Color color2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, n2, color2));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n, Color color, Color color2, int n2, Color color3) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, color2, n2, color3));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n, Color color, Color color2, int n2, Color color3, Stroke stroke) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, color2, n2, color3, stroke));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n, Color color, int n2, Color color2, Stroke stroke, float f2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, color, n2, color2, stroke, f2));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, String string2) {
        StyleRange styleRange = (StyleRange)this.styles.get(string2);
        if (styleRange == null) {
            StyledLabelBuilder$ParsedStyleResult styledLabelBuilder$ParsedStyleResult = StyledLabelBuilder.parseStyleAnnotation(string2.toCharArray(), 0, this);
            return this.add(string, styledLabelBuilder$ParsedStyleResult.fontStyle, styledLabelBuilder$ParsedStyleResult.fontColor, styledLabelBuilder$ParsedStyleResult.backgroundColor, styledLabelBuilder$ParsedStyleResult.additionalStyle, styledLabelBuilder$ParsedStyleResult.lineColor);
        }
        return this.add(string, styleRange.getFontStyle(), styleRange.getFontColor(), styleRange.getAdditionalStyle(), styleRange.getLineColor(), styleRange.getLineStroke(), styleRange.getFontShrinkRatio());
    }

    public final StyledLabelBuilder add(String string, int n, int n2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, n2));
        return this.add(string);
    }

    public final StyledLabelBuilder add(String string, int n, int n2, float f2) {
        this.ranges.add(new StyleRange(this.start, string.length(), n, n2, f2));
        return this.add(string);
    }

    public final StyledLabel configure(StyledLabel styledLabel, String string) {
        StyledLabelBuilder.setStyledText(styledLabel, string, this);
        return styledLabel;
    }

    public final StyledLabel configure(StyledLabel styledLabel) {
        styledLabel.setText(this.buffer.toString());
        int n = this.ranges.size();
        for (int i2 = 0; i2 < n; ++i2) {
            styledLabel.addStyleRange((StyleRange)this.ranges.get(i2));
        }
        return styledLabel;
    }

    public final StyledLabel createLabel() {
        return this.configure(new StyledLabel());
    }

    public static final StyledLabel createStyledLabel(String string) {
        StyledLabel styledLabel = new StyledLabel();
        StyledLabelBuilder.setStyledText(styledLabel, string);
        return styledLabel;
    }

    public static final void setStyledText(StyledLabel styledLabel, String string) {
        StyledLabelBuilder.setStyledText(styledLabel, string.toCharArray());
    }

    private static void setStyledText(StyledLabel styledLabel, String string, StyledLabelBuilder styledLabelBuilder) {
        StyledLabelBuilder.setStyledText(styledLabel, string.toCharArray(), styledLabelBuilder);
    }

    public static final void setStyledText(StyledLabel styledLabel, char[] cArray) {
        StyledLabelBuilder.setStyledText(styledLabel, cArray, null);
    }

    private static void setStyledText(StyledLabel styledLabel, char[] cArray, StyledLabelBuilder styledLabelBuilder) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        boolean bl = false;
        styledLabel.clearStyleRanges();
        styledLabel.setLineWrap(false);
        int n2 = cArray.length;
        for (n = cArray.length - 1; n >= 0; --n) {
            if (cArray[n] != '@') continue;
            if (!StyledLabelBuilder.isGlobalConfiguration(styledLabel, cArray, n + 1)) break;
            n2 = n;
            break;
        }
        block5: for (n = 0; n < n2; ++n) {
            if (bl) {
                stringBuffer.append(cArray[n]);
                bl = false;
                continue;
            }
            switch (cArray[n]) {
                case '{': {
                    StyledLabelBuilder$ParsedStyleResult styledLabelBuilder$ParsedStyleResult = StyledLabelBuilder.parseStylePart(cArray, n + 1, styledLabelBuilder);
                    if (styledLabelBuilder$ParsedStyleResult == null) {
                        stringBuffer.append(cArray[n]);
                        continue block5;
                    }
                    int n3 = stringBuffer.length();
                    stringBuffer.append(styledLabelBuilder$ParsedStyleResult.text);
                    if (styledLabelBuilder$ParsedStyleResult.text.length() > 0) {
                        styledLabel.addStyleRange(new StyleRange(n3, styledLabelBuilder$ParsedStyleResult.text.length(), styledLabelBuilder$ParsedStyleResult.fontStyle, styledLabelBuilder$ParsedStyleResult.fontColor, styledLabelBuilder$ParsedStyleResult.backgroundColor, styledLabelBuilder$ParsedStyleResult.additionalStyle, styledLabelBuilder$ParsedStyleResult.lineColor));
                    }
                    n = Math.max(n, styledLabelBuilder$ParsedStyleResult.endOffset);
                    continue block5;
                }
                case '\\': {
                    bl = true;
                    continue block5;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
        }
        styledLabel.setText(stringBuffer.toString());
    }

    private static boolean isGlobalConfiguration(StyledLabel styledLabel, char[] cArray, int n) {
        String string = new String(cArray, n, cArray.length - n);
        String[] stringArray = string.split(",");
        if (stringArray.length <= 0 || stringArray[0] == null) {
            return false;
        }
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length <= 0 || stringArray2[0] == null) {
                return false;
            }
            String string3 = stringArray2[0].trim().toLowerCase();
            if ("rows".equals(string3) || "row".equals(string3) || "r".equals(string3)) {
                if (stringArray2.length > 4 || stringArray2.length < 1) {
                    return false;
                }
                if (stringArray2.length >= 2 && stringArray2[1].trim().length() > 0) {
                    try {
                        n2 = Integer.valueOf(stringArray2[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                if (stringArray2.length >= 3 && stringArray2[2].trim().length() > 0) {
                    try {
                        n4 = Integer.valueOf(stringArray2[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    if (n4 > n2 || n4 < 0) {
                        if (stringArray2[1].trim().length() > 0) {
                            n4 = 0;
                        } else if (n4 > n2) {
                            n2 = n4;
                        } else {
                            n4 = 0;
                        }
                    }
                }
                if (stringArray2.length < 4 || stringArray2[3].trim().length() <= 0) continue;
                try {
                    n3 = Integer.valueOf(stringArray2[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (n3 >= n2 && n3 >= 0) continue;
                n3 = 0;
                continue;
            }
            if ("w".equals(string3) || "width".equals(string3) || "preferredwidth".equals(string3)) {
                if (stringArray2.length != 2) {
                    return false;
                }
                if (stringArray2[1].trim().length() <= 0) continue;
                try {
                    n5 = Integer.valueOf(stringArray2[1]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return false;
        }
        styledLabel.setLineWrap(true);
        styledLabel.setRows(n2);
        styledLabel.setMaxRows(n3);
        styledLabel.setMinRows(n4);
        styledLabel.setPreferredWidth(n5);
        if (n2 == 1 && n3 == 1 && n4 == 1) {
            styledLabel.setLineWrap(false);
        }
        return true;
    }

    public static final String parseToVoidStyledTextConfusion(String string) {
        String string2 = string.replaceAll("\\\\", "\\\\\\\\");
        string2 = string2.replaceAll("\\{", "\\\\{");
        return string2;
    }

    private static StyledLabelBuilder$ParsedStyleResult parseStylePart(char[] cArray, int n, StyledLabelBuilder styledLabelBuilder) {
        StyledLabelBuilder$ParsedStyleResult styledLabelBuilder$ParsedStyleResult = new StyledLabelBuilder$ParsedStyleResult(null);
        int n2 = n;
        int n3 = StyledLabelBuilder.findNext(cArray, ':', n2);
        int n4 = StyledLabelBuilder.findMatchingBracket(cArray, n);
        if (n3 < 0 || n3 > n4) {
            return null;
        }
        styledLabelBuilder$ParsedStyleResult.text = StyledLabelBuilder.createTrimmedString(cArray, n2, n3 - 1);
        return StyledLabelBuilder.parseStyleAnnotation(cArray, n3 + 1, styledLabelBuilder, styledLabelBuilder$ParsedStyleResult);
    }

    private static int findMatchingBracket(char[] cArray, int n) {
        if (cArray.length == 0) {
            return -1;
        }
        if (n >= cArray.length) {
            return -1;
        }
        int n2 = 1;
        int n3 = cArray.length - n;
        int n4 = 0;
        while (n4 < n3) {
            char c2 = cArray[n];
            if (c2 == '{') {
                ++n2;
            } else if (c2 == '}' && --n2 == 0) {
                return n;
            }
            ++n4;
            ++n;
        }
        return -1;
    }

    private static StyledLabelBuilder$ParsedStyleResult parseStyleAnnotation(char[] cArray, int n, StyledLabelBuilder styledLabelBuilder) {
        StyledLabelBuilder$ParsedStyleResult styledLabelBuilder$ParsedStyleResult = new StyledLabelBuilder$ParsedStyleResult(null);
        return StyledLabelBuilder.parseStyleAnnotation(cArray, n, styledLabelBuilder, styledLabelBuilder$ParsedStyleResult);
    }

    private static StyledLabelBuilder$ParsedStyleResult parseStyleAnnotation(char[] cArray, int n, StyledLabelBuilder styledLabelBuilder, StyledLabelBuilder$ParsedStyleResult styledLabelBuilder$ParsedStyleResult) {
        int n2 = n;
        char[] cArray2 = new char[]{',', '}'};
        boolean bl = false;
        while (n2 < cArray.length && !bl) {
            Object object;
            String string;
            int n3;
            n = StyledLabelBuilder.findNextOf(cArray, cArray2, n2);
            if (n == -1 || cArray[n] == '}') {
                bl = true;
            }
            if ((n3 = (string = StyledLabelBuilder.createTrimmedString(cArray, n2, n == -1 ? cArray.length - 1 : n - 1)).indexOf(58)) != -1) {
                object = string.substring(n3 + 1);
                if (((String)object).length() > 1) {
                    if (((String)object).charAt(0) == '(') {
                        n = StyledLabelBuilder.findNext(cArray, ')', n2 + n3 + 1);
                        string = StyledLabelBuilder.createTrimmedString(cArray, n2, n + 1);
                        object = string.substring(n3 + 1);
                        if (cArray[n + 1] == '}') {
                            bl = true;
                        }
                        ++n;
                    }
                    if (string.charAt(0) == 'f') {
                        styledLabelBuilder$ParsedStyleResult.fontColor = StyledLabelBuilder.toColor((String)object);
                    } else if (string.charAt(0) == 'b') {
                        styledLabelBuilder$ParsedStyleResult.backgroundColor = StyledLabelBuilder.toColor((String)object);
                    } else {
                        styledLabelBuilder$ParsedStyleResult.lineColor = StyledLabelBuilder.toColor((String)object);
                    }
                }
            } else if (string.equals("plain") || string.equals("p")) {
                styledLabelBuilder$ParsedStyleResult.fontStyle = 0;
            } else if (string.equals("bold") || string.equals("b")) {
                styledLabelBuilder$ParsedStyleResult.fontStyle = 1;
            } else if (string.equals("italic") || string.equals("i")) {
                styledLabelBuilder$ParsedStyleResult.fontStyle = 2;
            } else if (string.equals("bolditalic") || string.equals("bi")) {
                styledLabelBuilder$ParsedStyleResult.fontStyle = 3;
            } else if (string.equals("strike") || string.equals("s")) {
                styledLabelBuilder$ParsedStyleResult.additionalStyle |= 1;
            } else if (string.equals("doublestrike") || string.equals("ds")) {
                styledLabelBuilder$ParsedStyleResult.additionalStyle |= 2;
            } else if (string.equals("waved") || string.equals("w")) {
                styledLabelBuilder$ParsedStyleResult.additionalStyle |= 4;
            } else if (string.equals("underlined") || string.equals("u")) {
                styledLabelBuilder$ParsedStyleResult.additionalStyle |= 8;
            } else if (string.equals("dotted") || string.equals("d")) {
                styledLabelBuilder$ParsedStyleResult.additionalStyle |= 0x10;
            } else if (string.equals("superscript") || string.equals("sp")) {
                styledLabelBuilder$ParsedStyleResult.additionalStyle |= 0x20;
            } else if (string.equals("subscript") || string.equals("sb")) {
                styledLabelBuilder$ParsedStyleResult.additionalStyle |= 0x40;
            } else if (styledLabelBuilder != null && styledLabelBuilder.styles.containsKey(string)) {
                object = (StyleRange)styledLabelBuilder.styles.get(string);
                styledLabelBuilder$ParsedStyleResult.fontStyle = ((StyleRange)object).getFontStyle();
                styledLabelBuilder$ParsedStyleResult.fontColor = ((StyleRange)object).getFontColor();
                styledLabelBuilder$ParsedStyleResult.backgroundColor = ((StyleRange)object).getBackgroundColor();
                styledLabelBuilder$ParsedStyleResult.additionalStyle = ((StyleRange)object).getAdditionalStyle();
                styledLabelBuilder$ParsedStyleResult.lineColor = ((StyleRange)object).getLineColor();
            } else if (string.length() > 0) {
                // empty if block
            }
            n2 = n + 1;
        }
        styledLabelBuilder$ParsedStyleResult.endOffset = n2 - 1;
        return styledLabelBuilder$ParsedStyleResult;
    }

    private static Color toColor(String string) {
        switch (string.charAt(0)) {
            case '(': {
                int n = StyledLabelBuilder.nextColorInt(string, 1);
                int n2 = string.indexOf(44);
                int n3 = StyledLabelBuilder.nextColorInt(string, n2 + 1);
                n2 = string.indexOf(44, n2 + 1);
                int n4 = StyledLabelBuilder.nextColorInt(string, n2 + 1);
                return new Color(n, n3, n4);
            }
            case '#': {
                if (string.length() == 4) {
                    return new Color(StyledLabelBuilder.getShorthandValue(string.charAt(1)), StyledLabelBuilder.getShorthandValue(string.charAt(2)), StyledLabelBuilder.getShorthandValue(string.charAt(3)));
                }
                return new Color(Integer.parseInt(string.substring(1), 16));
            }
            case '0': {
                return new Color(Integer.parseInt(string.substring(2), 16));
            }
        }
        return (Color)colorNamesMap.get(string);
    }

    private static int nextColorInt(String string, int n) {
        char c2;
        int n2;
        while (n < string.length() && (48 > (n2 = (int)string.charAt(n)) || n2 > 57)) {
            ++n;
        }
        for (n2 = n; n2 < n + 3 && (c2 = string.charAt(n2)) >= '0' && '9' >= c2; ++n2) {
        }
        return Integer.parseInt(string.substring(n, n2));
    }

    private static int getShorthandValue(char c2) {
        if ('A' <= (c2 = Character.toUpperCase(c2)) && c2 <= 'F') {
            return colorShorthandTable[c2 - 65 + 10];
        }
        return colorShorthandTable[c2 - 48];
    }

    public static final Map getColorNamesMap() {
        return colorNamesMap;
    }

    private static String createTrimmedString(char[] cArray, int n, int n2) {
        while ((cArray[n] == ' ' || cArray[n] == '\t') && n < cArray.length) {
            ++n;
        }
        while ((cArray[n2] == ' ' || cArray[n2] == '\t') && n < n2) {
            --n2;
        }
        if (n2 >= n) {
            StringBuffer stringBuffer = new StringBuffer(n2 - n);
            boolean bl = false;
            for (int i2 = n; i2 <= n2; ++i2) {
                if (cArray[i2] == '\\' && !bl) {
                    bl = true;
                    continue;
                }
                stringBuffer.append(cArray[i2]);
                if (!bl) continue;
                bl = false;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private static int findNextOf(char[] cArray, char[] cArray2, int n) {
        boolean bl = false;
        for (int i2 = n; i2 < cArray.length; ++i2) {
            if (bl) {
                bl = false;
                continue;
            }
            if (cArray[i2] == '\\') {
                bl = true;
                continue;
            }
            for (char c2 : cArray2) {
                if (cArray[i2] != c2) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int findNext(char[] cArray, char c2, int n) {
        boolean bl = false;
        for (int i2 = n; i2 < cArray.length; ++i2) {
            if (bl) {
                bl = false;
                continue;
            }
            if (cArray[i2] == '\\') {
                bl = true;
                continue;
            }
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    static {
        colorNamesMap.put("white", new Color(0xFFFFFF));
        colorNamesMap.put("lightGray", new Color(0xC0C0C0));
        colorNamesMap.put("gray", new Color(0x808080));
        colorNamesMap.put("darkGray", new Color(0x404040));
        colorNamesMap.put("black", new Color(0));
        colorNamesMap.put("red", new Color(0xFF0000));
        colorNamesMap.put("pink", new Color(0xFFAFAF));
        colorNamesMap.put("orange", new Color(16762880));
        colorNamesMap.put("yellow", new Color(0xFFFF00));
        colorNamesMap.put("green", new Color(65280));
        colorNamesMap.put("magenta", new Color(0xFF00FF));
        colorNamesMap.put("cyan", new Color(65535));
        colorNamesMap.put("blue", new Color(255));
    }
}

