/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Sticky$StickyMouseMotionListener;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class Sticky {
    private JComponent _target;
    private static final Sticky$StickyMouseMotionListener STICKY_MOUSE_MOTION_LISTENER = new Sticky$StickyMouseMotionListener(null);

    public Sticky(JList jList) {
        this._target = jList;
        this.install();
    }

    public Sticky(JTree jTree) {
        this._target = jTree;
        this.install();
    }

    public Sticky(JTable jTable) {
        this._target = jTable;
        this.install();
    }

    public final void install() {
        this._target.addMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    public final void uninstall() {
        this._target.removeMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    private static void updateListSelectionForEvent(MouseEvent mouseEvent, JList jList, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (jList == null) {
            return;
        }
        int n = jList.locationToIndex(point);
        if (n == -1) {
            if (point.y < 0) {
                n = 0;
            } else {
                int n2 = n = jList.getModel() == null ? 0 : jList.getModel().getSize() - 1;
            }
        }
        if (jList.getSelectedIndex() != n && n >= 0 && n < jList.getModel().getSize()) {
            jList.setSelectedIndex(n);
            if (bl) {
                jList.ensureIndexIsVisible(n);
            }
        }
    }

    private static void updateTreeSelectionForEvent(MouseEvent mouseEvent, JTree jTree, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (jTree == null) {
            return;
        }
        int n = jTree.getRowForLocation(point.x, point.y);
        if (n != -1) {
            TreePath treePath = jTree.getPathForRow(n);
            if (jTree.getSelectionPath() != treePath) {
                jTree.setSelectionRow(n);
                if (bl) {
                    jTree.makeVisible(treePath);
                }
            }
        }
    }

    private static void updateTableSelectionForEvent(MouseEvent mouseEvent, JTable jTable, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (jTable == null) {
            return;
        }
        int n = jTable.rowAtPoint(point);
        if (n == -1) {
            if (point.y < 0) {
                n = 0;
            } else {
                int n2 = n = jTable.getModel() == null ? 0 : jTable.getModel().getRowCount() - 1;
            }
        }
        if (jTable.getSelectedRow() != n) {
            jTable.getSelectionModel().setSelectionInterval(n, n);
            if (bl) {
                JideSwingUtilities.ensureRowVisible(jTable, n);
            }
        }
    }

    static final /* synthetic */ void access$100(MouseEvent mouseEvent, JList jList, boolean bl) {
        Sticky.updateListSelectionForEvent(mouseEvent, jList, bl);
    }

    static final /* synthetic */ void access$200(MouseEvent mouseEvent, JTree jTree, boolean bl) {
        Sticky.updateTreeSelectionForEvent(mouseEvent, jTree, bl);
    }

    static final /* synthetic */ void access$300(MouseEvent mouseEvent, JTable jTable, boolean bl) {
        Sticky.updateTableSelectionForEvent(mouseEvent, jTable, bl);
    }
}

