/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public abstract class SelectionModelGroup
implements Serializable {
    private static final long serialVersionUID = 2434517670879999353L;
    protected List _models = new Vector();
    protected Object _selectionListener = this.createSelectionListener();

    protected abstract Object createSelectionListener();

    protected abstract void addSelectionListener(Object var1, Object var2);

    protected abstract void removeSelectionListener(Object var1, Object var2);

    public void add(Object object) {
        if (object == null) {
            return;
        }
        if (!this._models.contains(object)) {
            this._models.add(object);
            this.addSelectionListener(object, this._selectionListener);
        }
    }

    public void add(int n, Object object) {
        if (object == null) {
            return;
        }
        if (!this._models.contains(object)) {
            if (n < 0 || n > this._models.size()) {
                this._models.add(object);
            } else {
                this._models.add(n, object);
            }
            this.addSelectionListener(object, this._selectionListener);
        }
    }

    public void remove(Object object) {
        if (object == null) {
            return;
        }
        if (this._models.remove(object)) {
            this.removeSelectionListener(object, this._selectionListener);
        }
    }

    public void removeAll() {
        if (this._models == null) {
            return;
        }
        for (Object e2 : this._models) {
            this.removeSelectionListener(e2, this._selectionListener);
        }
    }

    public List getElements() {
        return Collections.unmodifiableList(this._models);
    }

    public List getModels() {
        return this._models;
    }

    public int getModelCount() {
        if (this._models == null) {
            return 0;
        }
        return this._models.size();
    }
}

