/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.Searchable$1;
import com.jidesoft.swing.Searchable$2;
import com.jidesoft.swing.Searchable$3;
import com.jidesoft.swing.Searchable$4;
import com.jidesoft.swing.Searchable$5;
import com.jidesoft.swing.Searchable$DefaultSearchPopup;
import com.jidesoft.swing.Searchable$SearchPopup;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.WildcardSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public abstract class Searchable {
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    protected final JComponent _component;
    private Searchable$SearchPopup _popup;
    private JLayeredPane _layeredPane;
    private boolean _heavyweightComponentEnabled;
    private SearchableProvider _searchableProvider;
    private Pattern _pattern;
    private String _searchText;
    private String _previousSearchText;
    private boolean _fromStart = true;
    private boolean _caseSensitive = false;
    private boolean _repeats = false;
    private boolean _wildcardEnabled = true;
    private WildcardSupport _wildcardSupport = null;
    private Color _mismatchForeground;
    private Color _foreground = null;
    private Color _background = null;
    protected ComponentListener _componentListener;
    protected KeyListener _keyListener;
    protected FocusListener _focusListener;
    private SearchableListener _searchableListener;
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    private int _cursor = -1;
    private String _searchLabel = null;
    private int _popupLocation = 1;
    private int _searchingDelay = 0;
    private int _popupTimeout = 0;
    private Timer _popupTimer;
    private boolean _reverseOrder = false;
    protected EventListenerList listenerList = new EventListenerList();
    private Component _popupLocationRelativeTo;
    public static final String CLIENT_PROPERTY_SEARCHABLE = "Searchable";
    private Set _selection;
    private boolean _processModelChangeEvent = true;
    private boolean _hideSearchPopupOnEvent = true;

    public Searchable(JComponent jComponent) {
        Searchable searchable = Searchable.getSearchable(jComponent);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this._previousSearchText = null;
        this._component = jComponent;
        this._selection = new HashSet();
        this.installListeners();
        this.updateClientProperty(this._component, this);
    }

    public Searchable(JComponent jComponent, SearchableProvider searchableProvider) {
        Searchable searchable = Searchable.getSearchable(jComponent);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this._searchableProvider = searchableProvider;
        this._previousSearchText = null;
        this._component = jComponent;
        this._selection = new HashSet();
        this.installListeners();
        this.updateClientProperty(this._component, this);
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1, boolean var2);

    public final void adjustSelectedIndex(int n, boolean bl) {
        this.setSelectedIndex(n, bl);
    }

    protected abstract int getElementCount();

    protected abstract Object getElementAt(int var1);

    protected abstract String convertElementToString(Object var1);

    public final String convertToString(Object object) {
        return this.convertElementToString(object);
    }

    public final boolean isHideSearchPopupOnEvent() {
        return this._hideSearchPopupOnEvent;
    }

    public final void setHideSearchPopupOnEvent(boolean bl) {
        this._hideSearchPopupOnEvent = bl;
    }

    public void hidePopup() {
        if (this._popup != null) {
            if (this.isHeavyweightComponentEnabled()) {
                this._popup.hidePopupImmediately();
            } else if (this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            }
            this._popup = null;
            this._searchableProvider = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3000, "", this.getCurrentIndex(), this._previousSearchText));
        }
        this.setCursor(-1);
    }

    public final SearchableProvider getSearchableProvider() {
        return this._searchableProvider;
    }

    public final void setSearchableProvider(SearchableProvider searchableProvider) {
        this._searchableProvider = searchableProvider;
    }

    public void installListeners() {
        if (this._componentListener == null) {
            this._componentListener = this.createComponentListener();
        }
        this._component.addComponentListener(this._componentListener);
        Component component = JideSwingUtilities.getScrollPane(this._component);
        if (component != null) {
            component.addComponentListener(this._componentListener);
        }
        if (this._keyListener == null) {
            this._keyListener = this.createKeyListener();
        }
        JideSwingUtilities.insertKeyListener(this.getComponent(), this._keyListener, 0);
        if (this._focusListener == null) {
            this._focusListener = this.createFocusListener();
        }
        this.getComponent().addFocusListener(this._focusListener);
        if (this._searchableListener == null) {
            this._searchableListener = new Searchable$1(this);
        }
        this.addSearchableListener(this._searchableListener);
    }

    protected final ComponentListener createComponentListener() {
        return new Searchable$2(this);
    }

    protected final KeyListener createKeyListener() {
        return new Searchable$3(this);
    }

    protected FocusListener createFocusListener() {
        return new Searchable$4(this);
    }

    public void uninstallListeners() {
        if (this._componentListener != null) {
            this.getComponent().removeComponentListener(this._componentListener);
            Component component = JideSwingUtilities.getScrollPane(this.getComponent());
            if (component != null) {
                component.removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            this.getComponent().removeKeyListener(this._keyListener);
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            this.getComponent().removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        if (this._searchableListener != null) {
            this.removeSearchableListener(this._searchableListener);
            this._searchableListener = null;
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public final void firePropertyChangeEvent(String string) {
        if (!string.equals(this._previousSearchText)) {
            this._propertyChangeSupport.firePropertyChange(PROPERTY_SEARCH_TEXT, this._previousSearchText, string);
            this.fireSearchableEvent(new SearchableEvent(this, 3004, string, this.getCurrentIndex(), this._previousSearchText));
            this._previousSearchText = string;
            if (string.length() == 0) {
                this.searchingTextEmpty();
            }
        }
    }

    protected void searchingTextEmpty() {
    }

    protected final boolean compare(Object object, String string) {
        String string2 = this.convertElementToString(object);
        return string2 != null && this.compare(this.isCaseSensitive() ? string2 : string2.toLowerCase(), string);
    }

    protected final boolean compare(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return true;
        }
        if (!this.isWildcardEnabled()) {
            return string2 != null && (string2.equals(string) || string2.length() > 0 && (this.isFromStart() ? string.startsWith(string2) : string.indexOf(string2) != -1));
        }
        if (this._searchText != null && this._searchText.equals(string2) && this._pattern != null) {
            return this._pattern.matcher(string).find();
        }
        WildcardSupport wildcardSupport = this.getWildcardSupport();
        String string3 = wildcardSupport.convert(string2);
        if (string2.equals(string3)) {
            return this.isFromStart() ? string.startsWith(string2) : string.indexOf(string2) != -1;
        }
        this._searchText = string2;
        try {
            this._pattern = Pattern.compile(this.isFromStart() ? "^" + string3 : string3, this.isCaseSensitive() ? 0 : 2);
            return this._pattern.matcher(string).find();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public final int getCursor() {
        return this._cursor;
    }

    public final void setCursor(int n) {
        this.setCursor(n, false);
    }

    public final void setCursor(int n, boolean bl) {
        if (!bl || this._cursor < 0) {
            this._selection.clear();
        }
        if (this._cursor >= 0) {
            this._selection.add(n);
        }
        this._cursor = n;
    }

    protected final void highlightAll() {
        int n = -1;
        int n2 = this.getSelectedIndex();
        String string = this.getSearchingText();
        while (n2 != -1) {
            int n3 = this.findNext(string);
            if ((n2 = n2 == n3 ? -1 : n3) == -1) continue;
            if (n == -1) {
                n = n2;
            }
            this.select(n2, string);
        }
        if (n != -1) {
            this.select(n, string);
        }
    }

    protected final void cancelHighlightAll() {
    }

    protected final void select(int n, String string) {
        if (n != -1) {
            this.setSelectedIndex(n, true);
            this.setCursor(n, true);
            Object object = this.getElementAt(n);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, string, object, this.convertElementToString(object)));
        } else {
            this.setSelectedIndex(-1, false);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, string));
        }
    }

    public int findNext(String string) {
        Object object;
        int n;
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        int n3 = this.getCurrentIndex();
        for (n = n3 + 1; n < n2; ++n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string2)) continue;
            return n;
        }
        if (this.isRepeats()) {
            for (n = 0; n < n3; ++n) {
                object = this.getElementAt(n);
                if (!this.compare(object, string2)) continue;
                return n;
            }
        }
        return n3 == -1 ? -1 : (this.compare(this.getElementAt(n3), string2) ? n3 : -1);
    }

    protected final int getCurrentIndex() {
        if (this._selection.contains(this.getSelectedIndex())) {
            return this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        }
        this._selection.clear();
        return this.getSelectedIndex();
    }

    public int findPrevious(String string) {
        Object object;
        int n;
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        int n3 = this.getCurrentIndex();
        for (n = n3 - 1; n >= 0; --n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string2)) continue;
            return n;
        }
        if (this.isRepeats()) {
            for (n = n2 - 1; n >= n3; --n) {
                object = this.getElementAt(n);
                if (!this.compare(object, string2)) continue;
                return n;
            }
        }
        return n3 == -1 ? -1 : (this.compare(this.getElementAt(n3), string2) ? n3 : -1);
    }

    public int findFromCursor(String string) {
        Object object;
        int n;
        int n2;
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n3 = this.getCurrentIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n = n3; n < n2; ++n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string2)) continue;
            return n;
        }
        for (n = 0; n < n3; ++n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string2)) continue;
            return n;
        }
        return -1;
    }

    public int reverseFindFromCursor(String string) {
        Object object;
        int n;
        int n2;
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n3 = this.getCurrentIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n = n3; n >= 0; --n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string2)) continue;
            return n;
        }
        for (n = n2 - 1; n >= n3; --n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string2)) continue;
            return n;
        }
        return -1;
    }

    public int findFirst(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n = this.getElementCount();
        if (n == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = this.getIndex(n, i2);
            Object object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        return -1;
    }

    public int findLast(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n = this.getElementCount();
        if (n == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = n - 1; i2 >= 0; --i2) {
            Object object = this.getElementAt(i2);
            if (!this.compare(object, string2)) continue;
            return i2;
        }
        return -1;
    }

    protected final void keyTypedOrPressed(KeyEvent keyEvent) {
        if (this._searchableProvider != null && this._searchableProvider.isPassive()) {
            this._searchableProvider.processKeyEvent(keyEvent);
            return;
        }
        if (this.isActivateKey(keyEvent)) {
            String string = "";
            if (keyEvent.getID() == 400) {
                if (JideSwingUtilities.isMenuShortcutKeyDown(keyEvent)) {
                    return;
                }
                if (keyEvent.isAltDown()) {
                    return;
                }
                string = String.valueOf(keyEvent.getKeyChar());
            }
            this.showPopup(string);
            if (keyEvent.getKeyCode() != 10) {
                keyEvent.consume();
            }
        }
    }

    private int getIndex(int n, int n2) {
        return this.isReverseOrder() ? n - n2 - 1 : n2;
    }

    public void showPopup(String string) {
        if (this._searchableProvider == null) {
            this.fireSearchableEvent(new SearchableEvent(this, 2999, string));
            this.showPopup(this.createSearchPopup(string));
            this._searchableProvider = new Searchable$5(this);
        }
    }

    protected final Searchable$SearchPopup createSearchPopup(String string) {
        return new Searchable$DefaultSearchPopup(this, string);
    }

    public final String getSearchingText() {
        return this._searchableProvider != null ? this._searchableProvider.getSearchingText() : "";
    }

    private void showPopup(Searchable$SearchPopup searchable$SearchPopup) {
        JRootPane jRootPane = this._component.getRootPane();
        this._layeredPane = jRootPane != null ? jRootPane.getLayeredPane() : null;
        if (this._layeredPane == null || this.isHeavyweightComponentEnabled()) {
            this._popup = searchable$SearchPopup;
            Point point = this.updateSizeAndLocation();
            if (point != null) {
                searchable$SearchPopup.showPopup(point.x, point.y);
                this._popup.setVisible(true);
            } else {
                this._popup = null;
            }
        } else {
            if (this._popup != null && this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            } else {
                this._popup = !this._component.isShowing() ? null : searchable$SearchPopup;
            }
            if (this._popup == null || !this._component.isDisplayable()) {
                return;
            }
            if (this._layeredPane == null) {
                System.err.println("Failed to find layeredPane.");
                return;
            }
            this._layeredPane.add((Component)this._popup, JLayeredPane.POPUP_LAYER);
            this.updateSizeAndLocation();
            this._popup.setVisible(true);
            this._popup.validate();
        }
    }

    private Point updateSizeAndLocation() {
        Component component = this.getPopupLocationRelativeTo();
        if (component == null) {
            component = JideSwingUtilities.getScrollPane(this._component);
        }
        if (component == null) {
            component = this._component;
        }
        if (this._popup != null) {
            Point point;
            Dimension dimension = this._popup.getPreferredSize();
            switch (this.getPopupLocation()) {
                case 3: {
                    try {
                        point = component.getLocationOnScreen();
                        point.y += component.getHeight();
                        if (this.isHeavyweightComponentEnabled()) break;
                        SwingUtilities.convertPointFromScreen(point, this._layeredPane);
                        if (point.y + dimension.height <= this._layeredPane.getHeight()) break;
                        point.y = this._layeredPane.getHeight() - dimension.height;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
                default: {
                    try {
                        point = component.getLocationOnScreen();
                        if (!this.isHeavyweightComponentEnabled()) {
                            SwingUtilities.convertPointFromScreen(point, this._layeredPane);
                        }
                        point.y -= dimension.height;
                        if (point.y >= 0) break;
                        point.y = 0;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
            }
            if (!this.isHeavyweightComponentEnabled()) {
                this._popup.setLocation(point);
                this._popup.setSize(dimension);
            } else {
                this._popup.packPopup();
            }
            return point;
        }
        return null;
    }

    protected final boolean isFindFirstKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 36;
    }

    protected final boolean isFindLastKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 35;
    }

    protected boolean isFindPreviousKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 38;
    }

    protected boolean isFindNextKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 40;
    }

    protected final boolean isNavigationKey(KeyEvent keyEvent) {
        return this.isFindFirstKey(keyEvent) || this.isFindLastKey(keyEvent) || this.isFindNextKey(keyEvent) || this.isFindPreviousKey(keyEvent);
    }

    protected boolean isActivateKey(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return keyEvent.getID() == 400 && c2 > ' ' && c2 != '\u007f';
    }

    protected final boolean isDeactivateKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        return n == 10 || n == 27 || n == 33 || n == 34 || n == 36 || n == 35 || n == 37 || n == 39 || n == 38 || n == 40;
    }

    protected final boolean isSelectAllKey(KeyEvent keyEvent) {
        return JideSwingUtilities.isMenuShortcutKeyDown(keyEvent) && keyEvent.getKeyCode() == 65;
    }

    protected final boolean isIncrementalSelectKey(KeyEvent keyEvent) {
        return JideSwingUtilities.isMenuShortcutKeyDown(keyEvent);
    }

    public final Color getMismatchForeground() {
        if (this._mismatchForeground == null) {
            return Color.RED;
        }
        return this._mismatchForeground;
    }

    public final void setMismatchForeground(Color color) {
        this._mismatchForeground = color;
    }

    public final boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public final void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }

    public final int getSearchingDelay() {
        return this._searchingDelay;
    }

    public final void setSearchingDelay(int n) {
        this._searchingDelay = n;
    }

    public final boolean isRepeats() {
        return this._repeats;
    }

    public final void setRepeats(boolean bl) {
        this._repeats = bl;
    }

    public final Color getForeground() {
        if (this._foreground == null) {
            return UIDefaultsLookup.getColor("ToolTip.foreground");
        }
        return this._foreground;
    }

    public final void setForeground(Color color) {
        this._foreground = color;
    }

    public final Color getBackground() {
        if (this._background == null) {
            return UIDefaultsLookup.getColor("ToolTip.background");
        }
        return this._background;
    }

    public final void setBackground(Color color) {
        this._background = color;
    }

    public final boolean isWildcardEnabled() {
        return this._wildcardEnabled;
    }

    public final void setWildcardEnabled(boolean bl) {
        this._wildcardEnabled = bl;
    }

    public final WildcardSupport getWildcardSupport() {
        if (this._wildcardSupport == null) {
            this._wildcardSupport = new DefaultWildcardSupport();
        }
        return this._wildcardSupport;
    }

    public final void setWildcardSupport(WildcardSupport wildcardSupport) {
        this._wildcardSupport = wildcardSupport;
    }

    public final String getSearchLabel() {
        if (this._searchLabel == null) {
            return this.getResourceString("Searchable.searchFor");
        }
        return this._searchLabel;
    }

    public final void setSearchLabel(String string) {
        this._searchLabel = string;
    }

    public final void addSearchableListener(SearchableListener searchableListener) {
        this.listenerList.add(SearchableListener.class, searchableListener);
    }

    public final void removeSearchableListener(SearchableListener searchableListener) {
        this.listenerList.remove(SearchableListener.class, searchableListener);
    }

    public final SearchableListener[] getSearchableListeners() {
        return (SearchableListener[])this.listenerList.getListeners(SearchableListener.class);
    }

    public final boolean isSearchableListenerInstalled(SearchableListener searchableListener) {
        SearchableListener[] searchableListenerArray;
        for (SearchableListener searchableListener2 : searchableListenerArray = this.getSearchableListeners()) {
            if (searchableListener2 != searchableListener) continue;
            return true;
        }
        return false;
    }

    protected final void fireSearchableEvent(SearchableEvent searchableEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SearchableListener.class) continue;
            ((SearchableListener)objectArray[i2 + 1]).searchableEventFired(searchableEvent);
        }
    }

    public final Component getComponent() {
        return this._component;
    }

    public final int getPopupLocation() {
        return this._popupLocation;
    }

    public final void setPopupLocation(int n) {
        this._popupLocation = n;
    }

    public final boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public final void setReverseOrder(boolean bl) {
        this._reverseOrder = bl;
    }

    protected final String getResourceString(String string) {
        return Resource.getResourceBundle(this._component != null ? this._component.getLocale() : Locale.getDefault()).getString(string);
    }

    public final boolean isPopupVisible() {
        return this._popup != null;
    }

    public final boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public final void setHeavyweightComponentEnabled(boolean bl) {
        this._heavyweightComponentEnabled = bl;
    }

    public final Component getPopupLocationRelativeTo() {
        return this._popupLocationRelativeTo;
    }

    public final void setPopupLocationRelativeTo(Component component) {
        this._popupLocationRelativeTo = component;
    }

    public final boolean isFromStart() {
        return this._fromStart;
    }

    public final void setFromStart(boolean bl) {
        this.hidePopup();
        this._fromStart = bl;
    }

    public static final Searchable getSearchable(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
        if (object instanceof Searchable) {
            return (Searchable)object;
        }
        return null;
    }

    private void updateClientProperty(JComponent jComponent, Searchable searchable) {
        if (jComponent != null) {
            Object object = this._component.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
            if (object instanceof Searchable) {
                ((Searchable)object).uninstallListeners();
            }
            jComponent.putClientProperty(CLIENT_PROPERTY_SEARCHABLE, searchable);
        }
    }

    public final boolean isProcessModelChangeEvent() {
        return this._processModelChangeEvent;
    }

    public final void setProcessModelChangeEvent(boolean bl) {
        this._processModelChangeEvent = bl;
    }

    public final int getPopupTimeout() {
        return this._popupTimeout;
    }

    public final void setPopupTimeout(int n) {
        this._popupTimeout = n;
    }

    public final List findAll(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = this.getElementCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Object object = this.getElementAt(i2);
            if (!this.compare(object, string2)) continue;
            arrayList.add(i2);
        }
        return arrayList;
    }

    public final String getElementAtAsString(int n) {
        return this.convertElementToString(this.getElementAt(n));
    }

    protected final void textChanged(String string) {
        if (string == null || string.length() == 0) {
            this.firePropertyChangeEvent("");
            return;
        }
        int n = this.findFromCursor(string);
        if (n == -1) {
            this.firePropertyChangeEvent(string);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, string));
        } else {
            this.firePropertyChangeEvent(string);
            Object object = this.getElementAt(n);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, string, object, this.convertElementToString(object)));
        }
    }

    static final /* synthetic */ Searchable$SearchPopup access$200(Searchable searchable) {
        return searchable._popup;
    }

    static final /* synthetic */ Timer access$302(Searchable searchable, Timer timer) {
        searchable._popupTimer = timer;
        return searchable._popupTimer;
    }

    static final /* synthetic */ Timer access$300(Searchable searchable) {
        return searchable._popupTimer;
    }

    static final /* synthetic */ SearchableProvider access$400(Searchable searchable) {
        return searchable._searchableProvider;
    }

    static final /* synthetic */ Point access$500(Searchable searchable) {
        return searchable.updateSizeAndLocation();
    }
}

