/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.Resizable$ResizeCorner;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ResizableMouseInputAdapter
extends MouseInputAdapter {
    private static Rectangle _startingBounds;
    private int _eventMouseScreenX;
    private int _eventMouseScreenY;
    private int _resizeCorner;
    protected static final int RESIZE_NONE = 0;
    private boolean _discardRelease = false;
    private Resizable _resizable;

    public ResizableMouseInputAdapter(Resizable resizable) {
        this._resizable = resizable;
    }

    private boolean isResizable(int n) {
        return this._resizable != null && (this._resizable.getResizableCorners() & n) != 0;
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        Serializable serializable;
        Point point;
        this._resizeCorner = 0;
        _startingBounds = this._resizable.getComponent().getBounds();
        if (this._resizable.isTopLevel()) {
            point = new Point(ResizableMouseInputAdapter._startingBounds.x, ResizableMouseInputAdapter._startingBounds.y);
            SwingUtilities.convertPointToScreen(point, this._resizable.getComponent());
            ResizableMouseInputAdapter._startingBounds.x = point.x;
            ResizableMouseInputAdapter._startingBounds.y = point.y;
        }
        point = new Point(mouseEvent.getX(), mouseEvent.getY());
        SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
        this._eventMouseScreenX = point.x;
        this._eventMouseScreenY = point.y;
        if (mouseEvent.getSource() instanceof Resizable$ResizeCorner) {
            serializable = (Resizable$ResizeCorner)mouseEvent.getSource();
            this._resizeCorner = serializable.getCorner();
        } else if (mouseEvent.getSource() == this._resizable.getComponent()) {
            serializable = this._resizable.getResizeInsets();
            if (mouseEvent.getX() <= ((Insets)serializable).left) {
                this._resizeCorner = ((Insets)serializable).top > 0 && mouseEvent.getY() < this._resizable.getResizeCornerSize() + ((Insets)serializable).top ? 1 : (((Insets)serializable).bottom > 0 && mouseEvent.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - ((Insets)serializable).bottom ? 64 : 128);
            } else if (((Insets)serializable).right > 0 && mouseEvent.getX() >= this._resizable.getComponent().getWidth() - ((Insets)serializable).right) {
                this._resizeCorner = ((Insets)serializable).top > 0 && mouseEvent.getY() < this._resizable.getResizeCornerSize() + ((Insets)serializable).top ? 4 : (((Insets)serializable).bottom > 0 && mouseEvent.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - ((Insets)serializable).bottom ? 16 : 8);
            } else if (((Insets)serializable).top > 0 && mouseEvent.getY() <= ((Insets)serializable).top) {
                this._resizeCorner = ((Insets)serializable).left > 0 && mouseEvent.getX() < this._resizable.getResizeCornerSize() + ((Insets)serializable).left ? 1 : (((Insets)serializable).right > 0 && mouseEvent.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - ((Insets)serializable).right ? 4 : 2);
            } else if (((Insets)serializable).bottom > 0 && mouseEvent.getY() >= this._resizable.getComponent().getHeight() - ((Insets)serializable).bottom) {
                this._resizeCorner = ((Insets)serializable).left > 0 && mouseEvent.getX() < this._resizable.getResizeCornerSize() + ((Insets)serializable).left ? 64 : (((Insets)serializable).right > 0 && mouseEvent.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - ((Insets)serializable).right ? 16 : 32);
            } else {
                this._discardRelease = true;
                return;
            }
        }
        serializable = Cursor.getDefaultCursor();
        if (this.isResizable(this._resizeCorner)) {
            boolean bl = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
            switch (this._resizeCorner) {
                case 32: {
                    serializable = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 2: {
                    serializable = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 128: {
                    serializable = Cursor.getPredefinedCursor(bl ? 10 : 11);
                    break;
                }
                case 8: {
                    serializable = Cursor.getPredefinedCursor(bl ? 11 : 10);
                    break;
                }
                case 16: {
                    serializable = Cursor.getPredefinedCursor(bl ? 5 : 4);
                    break;
                }
                case 64: {
                    serializable = Cursor.getPredefinedCursor(bl ? 4 : 5);
                    break;
                }
                case 1: {
                    serializable = Cursor.getPredefinedCursor(bl ? 6 : 7);
                    break;
                }
                case 4: {
                    serializable = Cursor.getPredefinedCursor(bl ? 7 : 6);
                }
            }
            Container container = this._resizable.getComponent().getTopLevelAncestor();
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setVisible(true);
                ((JFrame)container).getGlassPane().setCursor((Cursor)serializable);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setVisible(true);
                ((JApplet)container).getGlassPane().setCursor((Cursor)serializable);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setVisible(true);
                ((JWindow)container).getGlassPane().setCursor((Cursor)serializable);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setVisible(true);
                ((JDialog)container).getGlassPane().setCursor((Cursor)serializable);
            }
            this._resizable.beginResizing(this._resizeCorner);
        } else {
            this._resizeCorner = 0;
        }
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (_startingBounds == null) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Component component = (Component)mouseEvent.getSource();
        SwingUtilities.convertPointToScreen(point, component);
        int n3 = this._eventMouseScreenX - point.x;
        int n4 = this._eventMouseScreenY - point.y;
        Dimension dimension = this._resizable.getComponent().getMinimumSize();
        Dimension dimension2 = this._resizable.getComponent().getMaximumSize();
        Point point2 = new Point(this._resizable.getComponent().getX(), this._resizable.getComponent().getY());
        if (this._resizable.isTopLevel()) {
            SwingUtilities.convertPointToScreen(point2, this._resizable.getComponent());
        }
        int n5 = point2.x;
        int n6 = point2.y;
        Rectangle rectangle = this._resizable.isTopLevel() ? new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE) : this._resizable.getComponent().getParent().getBounds();
        int n7 = this._resizeCorner;
        boolean bl = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
        if (!bl) {
            switch (this._resizeCorner) {
                case 1: {
                    n7 = 4;
                }
                case 4: {
                    n7 = 1;
                }
                case 64: {
                    n7 = 16;
                }
                case 16: {
                    n7 = 64;
                }
                case 128: {
                    n7 = 8;
                }
                case 8: {
                    n7 = 128;
                }
            }
        }
        int n8 = this._resizable.getSnapGridSize();
        switch (n7) {
            case 0: {
                return;
            }
            case 2: {
                if (ResizableMouseInputAdapter._startingBounds.height + n4 < dimension.height) {
                    n4 = -(ResizableMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + n4 > dimension2.height) {
                    n4 = dimension2.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                n5 = ResizableMouseInputAdapter._startingBounds.x;
                n6 = ResizableMouseInputAdapter._startingBounds.y - n4;
                if (n8 > 0 && n6 % n8 != 0) {
                    n6 = n6 > 0 ? (n6 % n8 > n8 / 2 ? (n6 += n8 - n6 % n8) : (n6 -= n6 % n8)) : (-n6 % n8 > n8 / 2 ? (n6 -= n8 - -n6 % n8) : (n6 += -n6 % n8));
                }
                n4 = ResizableMouseInputAdapter._startingBounds.y - n6;
                n2 = ResizableMouseInputAdapter._startingBounds.width;
                n = ResizableMouseInputAdapter._startingBounds.height + n4;
                break;
            }
            case 4: {
                if (ResizableMouseInputAdapter._startingBounds.height + n4 < dimension.height) {
                    n4 = -(ResizableMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + n4 > dimension2.height) {
                    n4 = dimension2.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                if (ResizableMouseInputAdapter._startingBounds.width - n3 < dimension.width) {
                    n3 = ResizableMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - n3 > dimension2.width) {
                    n3 = -(dimension2.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - n3 > rectangle.width) {
                    n3 = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                n5 = ResizableMouseInputAdapter._startingBounds.x;
                n6 = ResizableMouseInputAdapter._startingBounds.y - n4;
                if (n8 > 0 && n6 % n8 != 0) {
                    n6 = n6 > 0 ? (n6 % n8 > n8 / 2 ? (n6 += n8 - n6 % n8) : (n6 -= n6 % n8)) : (-n6 % n8 > n8 / 2 ? (n6 -= n8 - -n6 % n8) : (n6 += -n6 % n8));
                }
                n4 = ResizableMouseInputAdapter._startingBounds.y - n6;
                n2 = ResizableMouseInputAdapter._startingBounds.width - n3;
                if (n8 > 0 && n2 % n8 != 0) {
                    n2 = n2 > 0 ? (n2 % n8 > n8 / 2 ? (n2 += n8 - n2 % n8) : (n2 -= n2 % n8)) : (-n2 % n8 > n8 / 2 ? (n2 -= n8 - -n2 % n8) : (n2 += -n2 % n8));
                }
                n = ResizableMouseInputAdapter._startingBounds.height + n4;
                break;
            }
            case 8: {
                if (ResizableMouseInputAdapter._startingBounds.width - n3 < dimension.width) {
                    n3 = ResizableMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - n3 > dimension2.width) {
                    n3 = -(dimension2.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - n3 > rectangle.width) {
                    n3 = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                n2 = ResizableMouseInputAdapter._startingBounds.width - n3;
                if (n8 > 0 && n2 % n8 != 0) {
                    n2 = n2 > 0 ? (n2 % n8 > n8 / 2 ? (n2 += n8 - n2 % n8) : (n2 -= n2 % n8)) : (-n2 % n8 > n8 / 2 ? (n2 -= n8 - -n2 % n8) : (n2 += -n2 % n8));
                }
                n = ResizableMouseInputAdapter._startingBounds.height;
                break;
            }
            case 16: {
                if (ResizableMouseInputAdapter._startingBounds.width - n3 < dimension.width) {
                    n3 = ResizableMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - n3 > dimension2.width) {
                    n3 = -(dimension2.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - n3 > rectangle.width) {
                    n3 = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                if (ResizableMouseInputAdapter._startingBounds.height - n4 < dimension.height) {
                    n4 = ResizableMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - n4 > dimension2.height) {
                    n4 = -(dimension2.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - n4 > rectangle.height) {
                    n4 = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                n2 = ResizableMouseInputAdapter._startingBounds.width - n3;
                n = ResizableMouseInputAdapter._startingBounds.height - n4;
                if (n8 > 0 && n % n8 != 0) {
                    n = n > 0 ? (n % n8 > n8 / 2 ? (n += n8 - n % n8) : (n -= n % n8)) : (-n % n8 > n8 / 2 ? (n -= n8 - -n % n8) : (n += -n % n8));
                }
                if (n8 <= 0 || n2 % n8 == 0) break;
                if (n2 > 0) {
                    if (n2 % n8 > n8 / 2) {
                        n2 += n8 - n2 % n8;
                        break;
                    }
                    n2 -= n2 % n8;
                    break;
                }
                if (-n2 % n8 > n8 / 2) {
                    n2 -= n8 - -n2 % n8;
                    break;
                }
                n2 += -n2 % n8;
                break;
            }
            case 32: {
                if (ResizableMouseInputAdapter._startingBounds.height - n4 < dimension.height) {
                    n4 = ResizableMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - n4 > dimension2.height) {
                    n4 = -(dimension2.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - n4 > rectangle.height) {
                    n4 = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                n2 = ResizableMouseInputAdapter._startingBounds.width;
                n = ResizableMouseInputAdapter._startingBounds.height - n4;
                if (n8 <= 0 || n % n8 == 0) break;
                if (n > 0) {
                    if (n % n8 > n8 / 2) {
                        n += n8 - n % n8;
                        break;
                    }
                    n -= n % n8;
                    break;
                }
                if (-n % n8 > n8 / 2) {
                    n -= n8 - -n % n8;
                    break;
                }
                n += -n % n8;
                break;
            }
            case 64: {
                if (ResizableMouseInputAdapter._startingBounds.height - n4 < dimension.height) {
                    n4 = ResizableMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - n4 > dimension2.height) {
                    n4 = -(dimension2.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - n4 > rectangle.height) {
                    n4 = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                if (ResizableMouseInputAdapter._startingBounds.width + n3 < dimension.width) {
                    n3 = -(ResizableMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + n3 > dimension2.width) {
                    n3 = dimension2.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                n5 = ResizableMouseInputAdapter._startingBounds.x - n3;
                if (n8 > 0 && n5 % n8 != 0) {
                    n5 = n5 > 0 ? (n5 % n8 > n8 / 2 ? (n5 += n8 - n5 % n8) : (n5 -= n5 % n8)) : (-n5 % n8 > n8 / 2 ? (n5 -= n8 - -n5 % n8) : (n5 += -n5 % n8));
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x - n5;
                n6 = ResizableMouseInputAdapter._startingBounds.y;
                n2 = ResizableMouseInputAdapter._startingBounds.width + n3;
                n = ResizableMouseInputAdapter._startingBounds.height - n4;
                if (n8 <= 0 || n % n8 == 0) break;
                if (n > 0) {
                    if (n % n8 > n8 / 2) {
                        n += n8 - n % n8;
                        break;
                    }
                    n -= n % n8;
                    break;
                }
                if (-n % n8 > n8 / 2) {
                    n -= n8 - -n % n8;
                    break;
                }
                n += -n % n8;
                break;
            }
            case 128: {
                if (ResizableMouseInputAdapter._startingBounds.width + n3 < dimension.width) {
                    n3 = -(ResizableMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + n3 > dimension2.width) {
                    n3 = dimension2.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                n5 = ResizableMouseInputAdapter._startingBounds.x - n3;
                if (n8 > 0 && n5 % n8 != 0) {
                    n5 = n5 > 0 ? (n5 % n8 > n8 / 2 ? (n5 += n8 - n5 % n8) : (n5 -= n5 % n8)) : (-n5 % n8 > n8 / 2 ? (n5 -= n8 - -n5 % n8) : (n5 += -n5 % n8));
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x - n5;
                n6 = ResizableMouseInputAdapter._startingBounds.y;
                n2 = ResizableMouseInputAdapter._startingBounds.width + n3;
                n = ResizableMouseInputAdapter._startingBounds.height;
                break;
            }
            case 1: {
                if (ResizableMouseInputAdapter._startingBounds.width + n3 < dimension.width) {
                    n3 = -(ResizableMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + n3 > dimension2.width) {
                    n3 = dimension2.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                if (ResizableMouseInputAdapter._startingBounds.height + n4 < dimension.height) {
                    n4 = -(ResizableMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + n4 > dimension2.height) {
                    n4 = dimension2.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                n5 = ResizableMouseInputAdapter._startingBounds.x - n3;
                if (n8 > 0 && n5 % n8 != 0) {
                    n5 = n5 > 0 ? (n5 % n8 > n8 / 2 ? (n5 += n8 - n5 % n8) : (n5 -= n5 % n8)) : (-n5 % n8 > n8 / 2 ? (n5 -= n8 - -n5 % n8) : (n5 += -n5 % n8));
                }
                n3 = ResizableMouseInputAdapter._startingBounds.x - n5;
                n6 = ResizableMouseInputAdapter._startingBounds.y - n4;
                if (n8 > 0 && n6 % n8 != 0) {
                    n6 = n6 > 0 ? (n6 % n8 > n8 / 2 ? (n6 += n8 - n6 % n8) : (n6 -= n6 % n8)) : (-n6 % n8 > n8 / 2 ? (n6 -= n8 - -n6 % n8) : (n6 += -n6 % n8));
                }
                n4 = ResizableMouseInputAdapter._startingBounds.y - n6;
                n2 = ResizableMouseInputAdapter._startingBounds.width + n3;
                n = ResizableMouseInputAdapter._startingBounds.height + n4;
                break;
            }
            default: {
                return;
            }
        }
        Rectangle rectangle2 = PortingUtils.getScreenBounds(this._resizable.getComponent());
        n5 = Math.max(n5, rectangle2.x);
        n6 = Math.max(n6, rectangle2.y);
        if (n5 + n2 > rectangle2.width) {
            n2 = rectangle2.width - n5;
        }
        if (n6 + n > rectangle2.height) {
            n = rectangle2.height - n6;
        }
        this._resizable.resizing(this._resizeCorner, n5, n6, n2, n);
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        _startingBounds = null;
        if (this._discardRelease) {
            this._discardRelease = false;
            return;
        }
        if (this._resizeCorner != 0) {
            Container container = this._resizable.getComponent().getTopLevelAncestor();
            if (container instanceof JFrame) {
                ((JFrame)this._resizable.getComponent().getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JFrame)this._resizable.getComponent().getTopLevelAncestor()).getGlassPane().setVisible(false);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JApplet)container).getGlassPane().setVisible(false);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JWindow)container).getGlassPane().setVisible(false);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JDialog)container).getGlassPane().setVisible(false);
            }
            this._resizable.endResizing(this._resizeCorner);
            this._eventMouseScreenX = 0;
            this._eventMouseScreenY = 0;
            _startingBounds = null;
            this._resizeCorner = 0;
        }
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Resizable$ResizeCorner) {
            Resizable$ResizeCorner resizable$ResizeCorner = (Resizable$ResizeCorner)mouseEvent.getSource();
            boolean bl = resizable$ResizeCorner.getComponentOrientation().isLeftToRight();
            switch (resizable$ResizeCorner.getCorner()) {
                case 16: {
                    resizable$ResizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                    return;
                }
                case 4: {
                    resizable$ResizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                    return;
                }
                case 64: {
                    resizable$ResizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                    return;
                }
                case 1: {
                    resizable$ResizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                    return;
                }
            }
        } else if (mouseEvent.getSource() == this._resizable.getComponent()) {
            Insets insets = this._resizable.getResizeInsets();
            boolean bl = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
            if (mouseEvent.getX() <= insets.left) {
                if (this.isResizable(1) && insets.top > 0 && mouseEvent.getY() < this._resizable.getResizeCornerSize() + insets.top) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                } else if (this.isResizable(64) && insets.bottom > 0 && mouseEvent.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - insets.bottom) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                } else if (this.isResizable(128)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 10 : 11));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (mouseEvent.getX() >= this._resizable.getComponent().getWidth() - insets.right) {
                if (this.isResizable(4) && insets.top > 0 && mouseEvent.getY() < this._resizable.getResizeCornerSize() + insets.top) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                } else if (this.isResizable(64) && insets.bottom > 0 && mouseEvent.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - insets.bottom) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                } else if (this.isResizable(8)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 11 : 10));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (mouseEvent.getY() <= insets.top) {
                if (this.isResizable(1) && insets.left > 0 && mouseEvent.getX() < this._resizable.getResizeCornerSize() + insets.left) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                } else if (this.isResizable(4) && insets.right > 0 && mouseEvent.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - insets.right) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                } else if (this.isResizable(2)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(8));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (mouseEvent.getY() >= this._resizable.getComponent().getHeight() - insets.bottom) {
                if (this.isResizable(64) && insets.left > 0 && mouseEvent.getX() < this._resizable.getResizeCornerSize() + insets.left) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                } else if (this.isResizable(16) && insets.right > 0 && mouseEvent.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - insets.right) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                } else if (this.isResizable(32)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(9));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else {
                this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
            }
            return;
        }
        this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Resizable$ResizeCorner) {
            Resizable$ResizeCorner resizable$ResizeCorner = (Resizable$ResizeCorner)mouseEvent.getSource();
            resizable$ResizeCorner.setCursor(Cursor.getDefaultCursor());
        } else {
            this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

