/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PaintPanel
extends JPanel {
    private Paint _backgroundPaint;
    protected Color _startColor;
    protected Color _endColor;
    protected boolean _isVertical;

    public PaintPanel() {
    }

    public PaintPanel(boolean bl) {
        super(bl);
    }

    public PaintPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public PaintPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public final Paint getBackgroundPaint() {
        return this._backgroundPaint;
    }

    public final void setBackgroundPaint(Paint paint) {
        this._backgroundPaint = paint;
    }

    public static final TexturePaint createTexturePaint(JPanel jPanel, Image image, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, n, n2, Color.white, jPanel);
        Rectangle rectangle = new Rectangle(0, 0, n3, n4);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public final void setGradientPaint(Color color, Color color2, boolean bl) {
        this.setStartColor(color);
        this.setEndColor(color2);
        this.setVertical(bl);
    }

    public final Color getStartColor() {
        return this._startColor;
    }

    public final void setStartColor(Color color) {
        this._startColor = color;
    }

    public final Color getEndColor() {
        return this._endColor;
    }

    public final void setEndColor(Color color) {
        this._endColor = color;
    }

    public final boolean isVertical() {
        return this._isVertical;
    }

    public final void setVertical(boolean bl) {
        this._isVertical = bl;
    }

    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getStartColor() != null && this.getEndColor() != null) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.getStartColor(), this.getEndColor(), this.isVertical());
        } else if (this.isOpaque() && this.getBackgroundPaint() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

