/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JidePopupMenu$ToolTipSwitchPopupMenuListener;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.PopupMenuUI;

public class JidePopupMenu
extends JPopupMenu
implements Scrollable {
    private static final String uiClassID = "JidePopupMenuUI";
    private static final String uiClassIDAlternative = "PopupMenuUI";
    private boolean _useLightWeightPopup;

    public JidePopupMenu() {
        this.setupPopupMenu();
    }

    public JidePopupMenu(String string) {
        super(string);
        this.setupPopupMenu();
    }

    public final String getUIClassID() {
        return UIDefaultsLookup.getBoolean("JidePopupMenu.uiExtensionDisabled") ? uiClassIDAlternative : uiClassID;
    }

    private void setupPopupMenu() {
        this.addPopupMenuListener(new JidePopupMenu$ToolTipSwitchPopupMenuListener(this, null));
    }

    public final void updateUI() {
        if (UIDefaultsLookup.get(this.getUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    public final void show(Component component, int n, int n2) {
        Point point = this.getPopupMenuOrigin(component, n, n2);
        super.show(component, point.x, point.y);
    }

    protected final Point getPopupMenuOrigin(Component component, int n, int n2) {
        Dimension dimension = this.getPreferredSize();
        if (dimension.width == 0) {
            dimension = this.getPreferredScrollableViewportSize();
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point, component);
        Rectangle rectangle = PortingUtils.ensureOnScreen(new Rectangle(point, dimension));
        point = rectangle.getLocation();
        SwingUtilities.convertPointFromScreen(point, component);
        return point;
    }

    public final void setLocation(int n, int n2) {
        if (this.isVisible() && n2 <= 0) {
            this.move(n, n2);
        } else {
            super.setLocation(n, n2);
        }
    }

    public final Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = PortingUtils.getLocalScreenSize(this);
        Container container = SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this);
        if (container instanceof SimpleScrollPane) {
            SimpleScrollPane simpleScrollPane = (SimpleScrollPane)container;
            dimension.height = Math.min(dimension.height, dimension2.height - simpleScrollPane.getScrollUpButton().getPreferredSize().height - simpleScrollPane.getScrollDownButton().getPreferredSize().height);
        }
        return dimension;
    }

    public final int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return new JMenuItem((String)"ABC").getPreferredSize().height;
    }

    public final int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return new JMenuItem((String)"ABC").getPreferredSize().height * 5;
    }

    public final boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public final boolean getScrollableTracksViewportHeight() {
        return false;
    }

    static final /* synthetic */ boolean access$102(JidePopupMenu jidePopupMenu, boolean bl) {
        jidePopupMenu._useLightWeightPopup = bl;
        return jidePopupMenu._useLightWeightPopup;
    }

    static final /* synthetic */ boolean access$100(JidePopupMenu jidePopupMenu) {
        return jidePopupMenu._useLightWeightPopup;
    }
}

