/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTree$CellRendererPropertyChangeListener;
import com.jidesoft.swing.CheckBoxTree$Handler;
import com.jidesoft.swing.CheckBoxTree$ModelPropertyChangeListener;
import com.jidesoft.swing.CheckBoxTreeCellRenderer;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TristateCheckBox;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    public static final String PROPERTY_DIG_IN = "digIn";
    protected CheckBoxTreeCellRenderer _treeCellRenderer;
    private CheckBoxTreeSelectionModel _checkBoxTreeSelectionModel;
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private PropertyChangeListener _modelChangeListener;
    private TristateCheckBox _checkBox;
    private boolean _selectPartialOnToggling = true;
    private TreeCellRenderer _defaultRenderer;

    public CheckBoxTree() {
        this.init();
    }

    public CheckBoxTree(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public CheckBoxTree(Vector vector) {
        super(vector);
        this.init();
    }

    public CheckBoxTree(Hashtable hashtable) {
        super(hashtable);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode) {
        super(treeNode);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.init();
    }

    public CheckBoxTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    protected final void init() {
        this._checkBoxTreeSelectionModel = this.createCheckBoxTreeSelectionModel(this.getModel());
        this._checkBoxTreeSelectionModel.setTree(this);
        CheckBoxTree$Handler checkBoxTree$Handler = this.createHandler();
        JideSwingUtilities.insertMouseListener(this, checkBoxTree$Handler, 0);
        this.addKeyListener(checkBoxTree$Handler);
        this._checkBoxTreeSelectionModel.addTreeSelectionListener(checkBoxTree$Handler);
        if (this._modelChangeListener == null) {
            this._modelChangeListener = new CheckBoxTree$ModelPropertyChangeListener(this, null);
        }
        this.addPropertyChangeListener("selectionModel", this._modelChangeListener);
        this.addPropertyChangeListener("model", this._modelChangeListener);
        this.updateRowMapper();
    }

    protected final CheckBoxTreeSelectionModel createCheckBoxTreeSelectionModel(TreeModel treeModel) {
        return new CheckBoxTreeSelectionModel(treeModel);
    }

    private void updateRowMapper() {
        this._checkBoxTreeSelectionModel.setRowMapper(this.getSelectionModel().getRowMapper());
    }

    public final TreeCellRenderer getCellRenderer() {
        TreeCellRenderer treeCellRenderer = this.getActualCellRenderer();
        if (treeCellRenderer == null) {
            treeCellRenderer = this.getDefaultRenderer();
        }
        if (this._treeCellRenderer == null) {
            this._treeCellRenderer = this.createCellRenderer(treeCellRenderer);
        } else {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
        return this._treeCellRenderer;
    }

    private TreeCellRenderer getDefaultRenderer() {
        if (this._defaultRenderer == null) {
            this._defaultRenderer = new DefaultTreeCellRenderer();
        }
        return this._defaultRenderer;
    }

    public final TreeCellRenderer getActualCellRenderer() {
        if (this._treeCellRenderer != null) {
            return this._treeCellRenderer.getActualTreeRenderer();
        }
        return super.getCellRenderer();
    }

    public final void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (treeCellRenderer == null) {
            treeCellRenderer = this.getDefaultRenderer();
        }
        super.setCellRenderer(treeCellRenderer);
        if (this._treeCellRenderer != null) {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
    }

    protected final CheckBoxTreeCellRenderer createCellRenderer(TreeCellRenderer treeCellRenderer) {
        CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = new CheckBoxTreeCellRenderer(treeCellRenderer, this.getCheckBox());
        this.addPropertyChangeListener("cellRenderer", new CheckBoxTree$CellRendererPropertyChangeListener(this, checkBoxTreeCellRenderer));
        return checkBoxTreeCellRenderer;
    }

    protected final CheckBoxTree$Handler createHandler() {
        return new CheckBoxTree$Handler(this);
    }

    public final TristateCheckBox getCheckBox() {
        return this._checkBox;
    }

    public final void setCheckBox(TristateCheckBox tristateCheckBox) {
        if (this._checkBox != tristateCheckBox) {
            this._checkBox = tristateCheckBox;
            this._treeCellRenderer = null;
            this.revalidate();
            this.repaint();
        }
    }

    public final boolean isSelectPartialOnToggling() {
        return this._selectPartialOnToggling;
    }

    public final void setSelectPartialOnToggling(boolean bl) {
        this._selectPartialOnToggling = bl;
    }

    public final TreePath getNextMatch(String string, int n, Position.Bias bias) {
        return null;
    }

    public final CheckBoxTreeSelectionModel getCheckBoxTreeSelectionModel() {
        return this._checkBoxTreeSelectionModel;
    }

    public final boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public final void setCheckBoxEnabled(boolean bl) {
        if (bl != this._checkBoxEnabled) {
            Boolean bl2 = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, bl3);
            this.repaint();
        }
    }

    public boolean isCheckBoxEnabled(TreePath treePath) {
        return true;
    }

    public boolean isCheckBoxVisible(TreePath treePath) {
        return true;
    }

    public final boolean isDigIn() {
        return this.getCheckBoxTreeSelectionModel().isDigIn();
    }

    public final void setDigIn(boolean bl) {
        boolean bl2 = this.isDigIn();
        if (bl2 != bl) {
            this.getCheckBoxTreeSelectionModel().setDigIn(bl);
            this.firePropertyChange(PROPERTY_DIG_IN, bl2, bl);
        }
    }

    public final boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public final void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this._clickInCheckBoxOnly) {
            boolean bl2 = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this._clickInCheckBoxOnly);
        }
    }

    static final /* synthetic */ void access$100(CheckBoxTree checkBoxTree) {
        checkBoxTree.updateRowMapper();
    }

    static final /* synthetic */ CheckBoxTreeSelectionModel access$200(CheckBoxTree checkBoxTree) {
        return checkBoxTree._checkBoxTreeSelectionModel;
    }
}

