/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.AutoCompletion$1;
import com.jidesoft.swing.AutoCompletion$2;
import com.jidesoft.swing.AutoCompletion$3;
import com.jidesoft.swing.AutoCompletion$4;
import com.jidesoft.swing.AutoCompletion$5;
import com.jidesoft.swing.AutoCompletion$6;
import com.jidesoft.swing.AutoCompletion$AutoCompletionDocument;
import com.jidesoft.swing.ComboBoxSearchable;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.Searchable;
import com.jidesoft.utils.SystemInfo;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AutoCompletion {
    private Searchable _searchable;
    private JTextComponent _textComponent;
    private AutoCompletion$AutoCompletionDocument _document;
    private boolean _selecting = false;
    private boolean _hidePopupOnFocusLoss;
    private boolean _keyTyped = false;
    private boolean _hitBackspace = false;
    private boolean _hitBackspaceOnSelection;
    private KeyListener _editorKeyListener;
    private boolean _strict = true;
    private boolean _strictCompletion = true;
    private PropertyChangeListener _propertyChangeListener;
    private JComboBox _comboBox;
    private Document _oldDocument;
    public static final String CLIENT_PROPERTY_AUTO_COMPLETION = "AutoCompletion";

    public AutoCompletion(JComboBox jComboBox) {
        this(jComboBox, (Searchable)new ComboBoxSearchable(jComboBox));
    }

    public AutoCompletion(JComboBox jComboBox, Searchable searchable) {
        this._searchable = searchable;
        this._propertyChangeListener = new AutoCompletion$1(this);
        this._comboBox = jComboBox;
        this._searchable.setWildcardEnabled(false);
        if (this._searchable instanceof ComboBoxSearchable) {
            ((ComboBoxSearchable)this._searchable).setShowPopupDuringSearching(false);
        }
        this._textComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        this.installListeners();
    }

    public AutoCompletion(JTextComponent jTextComponent, Searchable searchable) {
        this._searchable = searchable;
        this._searchable.setWildcardEnabled(false);
        this._textComponent = jTextComponent;
        this.registerSelectionListener(this.getSearchable());
        this.installListeners();
    }

    public AutoCompletion(JTextComponent jTextComponent, List list) {
        this(jTextComponent, (Searchable)new AutoCompletion$2((JComponent)new JLabel(), list));
    }

    public AutoCompletion(JTextComponent jTextComponent, Object[] objectArray) {
        this(jTextComponent, (Searchable)new AutoCompletion$3((JComponent)new JLabel(), objectArray));
    }

    private void registerSelectionListener(Searchable searchable) {
        if (searchable.getComponent() instanceof JList) {
            JList jList = (JList)this.getSearchable().getComponent();
            jList.getSelectionModel().addListSelectionListener(new AutoCompletion$4(this, jList));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(34, 0));
        } else if (searchable.getComponent() instanceof JTree) {
            JTree jTree = (JTree)this.getSearchable().getComponent();
            jTree.getSelectionModel().addTreeSelectionListener(new AutoCompletion$5(this, jTree));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(34, 0));
        }
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean bl) {
        this._keyTyped = bl;
    }

    private void setInitValue() {
        int n = this.getSearchable().getSelectedIndex();
        if (n != -1) {
            Object object = this.getSearchable().getElementAt(n);
            if (object != null) {
                this._document.setText(this.getSearchable().convertElementToString(object));
            }
            this.highlightCompletedText(0);
        } else {
            this._document.setText("");
        }
    }

    public final void uninstallListeners() {
        if (this._propertyChangeListener != null && this._comboBox != null) {
            this._comboBox.removePropertyChangeListener(this._propertyChangeListener);
        }
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this._editorKeyListener);
            String string = this.getTextComponent().getText();
            if (this._oldDocument != null) {
                this.getTextComponent().setDocument(this._oldDocument);
                this._oldDocument = null;
            }
            this.getTextComponent().setText(string);
        }
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, null);
    }

    public final void installListeners() {
        if (this._comboBox != null && this._propertyChangeListener != null) {
            this._comboBox.addPropertyChangeListener(this._propertyChangeListener);
        }
        this._editorKeyListener = new AutoCompletion$6(this);
        this._hidePopupOnFocusLoss = SystemInfo.isJdk15Above();
        this._document = this.createDocument();
        this.configureEditor(this.getTextComponent());
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, this);
    }

    protected final AutoCompletion$AutoCompletionDocument createDocument() {
        return new AutoCompletion$AutoCompletionDocument(this);
    }

    private void configureEditor(JTextComponent jTextComponent) {
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this._editorKeyListener);
        }
        if (jTextComponent != null) {
            this._textComponent = jTextComponent;
            this.getTextComponent().addKeyListener(this._editorKeyListener);
            String string = this.getTextComponent().getText();
            this._oldDocument = this.getTextComponent().getDocument();
            if (this._oldDocument instanceof AbstractDocument && this._document != null) {
                this._document.setDocumentFilter(((AbstractDocument)this._oldDocument).getDocumentFilter());
            }
            this.getTextComponent().setDocument(this._document);
            this.getTextComponent().setText(string);
        }
    }

    private void highlightCompletedText(int n) {
        int n2 = this.getTextComponent().getDocument().getLength();
        this.getTextComponent().setCaretPosition(n2);
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        this.getTextComponent().moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this._selecting = true;
        int n = this.getSearchable().getElementCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Object object2 = this.getSearchable().getElementAt(i2);
            if (object != object2) continue;
            this.getSearchable().setSelectedIndex(i2, false);
        }
        this._selecting = false;
    }

    public final boolean isStrict() {
        return this._strict;
    }

    public final void setStrict(boolean bl) {
        this._strict = bl;
    }

    public final boolean isStrictCompletion() {
        return this._strictCompletion;
    }

    public final void setStrictCompletion(boolean bl) {
        this._strictCompletion = bl;
    }

    protected final JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public final Searchable getSearchable() {
        return this._searchable;
    }

    public static final AutoCompletion getAutoCompletion(JComponent jComponent) {
        if (jComponent == null) {
            return null;
        }
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION);
        if (object instanceof AutoCompletion) {
            return (AutoCompletion)object;
        }
        return null;
    }

    static final /* synthetic */ JTextComponent access$002(AutoCompletion autoCompletion, JTextComponent jTextComponent) {
        autoCompletion._textComponent = jTextComponent;
        return autoCompletion._textComponent;
    }

    static final /* synthetic */ void access$100(AutoCompletion autoCompletion, JTextComponent jTextComponent) {
        autoCompletion.configureEditor(jTextComponent);
    }

    static final /* synthetic */ void access$200(AutoCompletion autoCompletion, int n) {
        autoCompletion.highlightCompletedText(n);
    }

    static final /* synthetic */ boolean access$302(AutoCompletion autoCompletion, boolean bl) {
        autoCompletion._hitBackspace = bl;
        return autoCompletion._hitBackspace;
    }

    static final /* synthetic */ void access$400(AutoCompletion autoCompletion, boolean bl) {
        autoCompletion.setKeyTyped(bl);
    }

    static final /* synthetic */ boolean access$502(AutoCompletion autoCompletion, boolean bl) {
        autoCompletion._hitBackspaceOnSelection = bl;
        return autoCompletion._hitBackspaceOnSelection;
    }

    static final /* synthetic */ void access$600(AutoCompletion autoCompletion, Object object) {
        autoCompletion.setSelectedItem(object);
    }

    static final /* synthetic */ JTextComponent access$000(AutoCompletion autoCompletion) {
        return autoCompletion._textComponent;
    }

    static final /* synthetic */ boolean access$700(AutoCompletion autoCompletion) {
        return autoCompletion._selecting;
    }

    static final /* synthetic */ boolean access$300(AutoCompletion autoCompletion) {
        return autoCompletion._hitBackspace;
    }

    static final /* synthetic */ boolean access$500(AutoCompletion autoCompletion) {
        return autoCompletion._hitBackspaceOnSelection;
    }

    static final /* synthetic */ boolean access$800(AutoCompletion autoCompletion) {
        return autoCompletion.isKeyTyped();
    }
}

