/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.AnimatorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class Animator
implements ActionListener {
    private final Component _source;
    private Timer _timer;
    private final int _totalSteps;
    private int _currentStep;
    private EventListenerList _listenerList = new EventListenerList();

    public Animator(Component component) {
        this(component, 50, 10, 10);
    }

    public Animator(Component component, int n, int n2, int n3) {
        this._source = component;
        this._totalSteps = n3;
        this._timer = this.createTimer(n2, this);
        this._timer.setInitialDelay(n);
    }

    protected final Timer createTimer(int n, ActionListener actionListener) {
        return new Timer(n, actionListener);
    }

    public final void addAnimatorListener(AnimatorListener animatorListener) {
        this._listenerList.add(AnimatorListener.class, animatorListener);
    }

    public final void removeAnimatorListener(AnimatorListener animatorListener) {
        this._listenerList.remove(AnimatorListener.class, animatorListener);
    }

    public final AnimatorListener[] getAnimatorListeners() {
        return (AnimatorListener[])this._listenerList.getListeners(AnimatorListener.class);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        if (this._source != null) {
            AnimatorListener[] animatorListenerArray;
            if (this._listenerList != null) {
                for (AnimatorListener animatorListener : animatorListenerArray = this.getAnimatorListeners()) {
                    animatorListener.animationFrame(this._source, this._totalSteps, this._currentStep);
                }
            }
            ++this._currentStep;
            if (this._totalSteps != -1 && this._currentStep > this._totalSteps) {
                this.stop();
                if (this._listenerList != null) {
                    for (AnimatorListener animatorListener : animatorListenerArray = this.getAnimatorListeners()) {
                        animatorListener.animationEnds(this._source);
                    }
                }
            }
        }
    }

    public final void start() {
        if (this._listenerList != null) {
            AnimatorListener[] animatorListenerArray;
            for (AnimatorListener animatorListener : animatorListenerArray = this.getAnimatorListeners()) {
                animatorListener.animationStarts(this._source);
            }
        }
        if (this._timer != null) {
            this._timer.start();
        }
        this._currentStep = 0;
    }

    public final void stop() {
        if (this._timer != null) {
            this._timer.stop();
        }
        this._currentStep = 0;
    }

    public final void interrupt() {
        if (this._timer != null) {
            this._timer.stop();
        }
    }

    public final boolean isRunning() {
        return this._timer != null && this._timer.isRunning();
    }

    public final void setDelay(int n) {
        this._timer.setDelay(n);
    }

    public final void dispose() {
        this.stop();
        this._timer.removeActionListener(this);
        this._timer = null;
    }
}

