/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFolderChooserIconsFactory;
import com.jidesoft.plaf.basic.FolderChooserResource;
import com.jidesoft.plaf.basic.FolderToolBar$1;
import com.jidesoft.plaf.basic.FolderToolBar$2;
import com.jidesoft.plaf.basic.FolderToolBar$3;
import com.jidesoft.plaf.basic.FolderToolBar$4;
import com.jidesoft.plaf.basic.FolderToolBar$5;
import com.jidesoft.plaf.basic.FolderToolBar$6;
import com.jidesoft.plaf.basic.FolderToolBar$FileListCellRenderer;
import com.jidesoft.plaf.basic.FolderToolBar$NoFocusButton;
import com.jidesoft.plaf.basic.FolderToolBarListener;
import com.jidesoft.utils.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileSystemView;

public class FolderToolBar
extends JToolBar {
    private static final FileSystemView _fsv = FileSystemView.getFileSystemView();
    private JButton _deleteFolderBtn;
    private JButton _newFolderBtn;
    private JButton _refreshBtn;
    private JButton _desktopBtn;
    private JButton _myDocumentsBtn;
    private JComboBox _recentFoldersList;
    private List _listeners = new ArrayList(1);
    public static final String DELETE_BUTTON_NAME = "FolderChooser.toolbar.delete";
    public static final String NEW_BUTTON_NAME = "FolderChooser.toolbar.new";
    public static final String REFRESH_BUTTON_NAME = "FolderChooser.toolbar.refresh";
    public static final String DESKTOP_BUTTON_NAME = "FolderChooser.toolbar.desktop";
    public static final String MY_DOCUMENTS_BUTTON_NAME = "FolderChooser.toolbar.mydocuments";

    public FolderToolBar(boolean bl, List list) {
        this.setFloatable(false);
        this.setupToolBar(bl, list);
    }

    public final void enableDelete() {
        this._deleteFolderBtn.setEnabled(true);
    }

    public final void disableDelete() {
        this._deleteFolderBtn.setEnabled(false);
    }

    public final void enableNewFolder() {
        this._newFolderBtn.setEnabled(true);
    }

    public final void disableNewFolder() {
        this._newFolderBtn.setEnabled(false);
    }

    public final JButton getButton(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(DELETE_BUTTON_NAME)) {
            return this._deleteFolderBtn;
        }
        if (string.equals(NEW_BUTTON_NAME)) {
            return this._newFolderBtn;
        }
        if (string.equals(REFRESH_BUTTON_NAME)) {
            return this._refreshBtn;
        }
        if (string.equals(DESKTOP_BUTTON_NAME)) {
            return this._desktopBtn;
        }
        if (string.equals(MY_DOCUMENTS_BUTTON_NAME)) {
            return this._myDocumentsBtn;
        }
        return null;
    }

    private void setupToolBar(boolean bl, List list) {
        ResourceBundle resourceBundle;
        if (bl) {
            this._recentFoldersList = new JComboBox(new DefaultComboBoxModel());
            if (list != null && list.size() > 0) {
                this._recentFoldersList.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            }
            this._recentFoldersList.setEditable(false);
            this._recentFoldersList.setRenderer(new FolderToolBar$FileListCellRenderer(this, this._recentFoldersList.getRenderer(), null));
            this._recentFoldersList.addPopupMenuListener(new FolderToolBar$1(this));
            this._recentFoldersList.setPrototypeDisplayValue("AAAAAAAAAAAAAAAAAA");
            resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
            this.add(new JLabel(resourceBundle.getString("FolderChooser.toolbar.recent")));
            this.add(this._recentFoldersList);
        } else {
            this.add(Box.createHorizontalGlue());
        }
        this._desktopBtn = new FolderToolBar$NoFocusButton(new FolderToolBar$2(this, null, SystemInfo.isWindows() ? _fsv.getSystemIcon(_fsv.getHomeDirectory()) : BasicFolderChooserIconsFactory.getImageIcon("icons/home.png")));
        resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
        this._desktopBtn.setToolTipText(SystemInfo.isWindows() ? resourceBundle.getString(DESKTOP_BUTTON_NAME) : resourceBundle.getString("FolderChooser.toolbar.home"));
        this._desktopBtn.setName(DESKTOP_BUTTON_NAME);
        this.add(this._desktopBtn);
        if (SystemInfo.isWindows()) {
            this._myDocumentsBtn = new FolderToolBar$NoFocusButton(new FolderToolBar$3(this, null, _fsv.getSystemIcon(_fsv.getDefaultDirectory())));
            this._myDocumentsBtn.setToolTipText(resourceBundle.getString(MY_DOCUMENTS_BUTTON_NAME));
            this._myDocumentsBtn.setName(MY_DOCUMENTS_BUTTON_NAME);
            this.add(this._myDocumentsBtn);
        }
        ImageIcon imageIcon = BasicFolderChooserIconsFactory.getImageIcon("icons/delete.png");
        this._deleteFolderBtn = new FolderToolBar$NoFocusButton(new FolderToolBar$4(this, null, imageIcon));
        this._deleteFolderBtn.setToolTipText(resourceBundle.getString(DELETE_BUTTON_NAME));
        this._deleteFolderBtn.setName(DELETE_BUTTON_NAME);
        ImageIcon imageIcon2 = BasicFolderChooserIconsFactory.getImageIcon("icons/new.png");
        this._newFolderBtn = new FolderToolBar$NoFocusButton(new FolderToolBar$5(this, null, imageIcon2));
        this._newFolderBtn.setToolTipText(resourceBundle.getString(NEW_BUTTON_NAME));
        this._newFolderBtn.setName(NEW_BUTTON_NAME);
        ImageIcon imageIcon3 = BasicFolderChooserIconsFactory.getImageIcon("icons/refresh.png");
        this._refreshBtn = new FolderToolBar$NoFocusButton(new FolderToolBar$6(this, null, imageIcon3));
        this._refreshBtn.setToolTipText(resourceBundle.getString(REFRESH_BUTTON_NAME));
        this._refreshBtn.setName(REFRESH_BUTTON_NAME);
        this.add(this._deleteFolderBtn);
        this.add(this._newFolderBtn);
        this.add(this._refreshBtn);
    }

    final boolean isButtonVisible(String string, int n) {
        if (DELETE_BUTTON_NAME.equals(string)) {
            return (n & 1) != 0;
        }
        if (NEW_BUTTON_NAME.equals(string)) {
            return (n & 2) != 0;
        }
        if (REFRESH_BUTTON_NAME.equals(string)) {
            return (n & 4) != 0;
        }
        if (DESKTOP_BUTTON_NAME.equals(string)) {
            return (n & 8) != 0;
        }
        if (MY_DOCUMENTS_BUTTON_NAME.equals(string)) {
            return (n & 0x10) != 0;
        }
        return true;
    }

    public final void addListener(FolderToolBarListener folderToolBarListener) {
        this._listeners.add(folderToolBarListener);
    }

    public final void removeListener(FolderToolBarListener folderToolBarListener) {
        this._listeners.remove(folderToolBarListener);
    }

    public final void clearListeners() {
        this._listeners.clear();
    }

    private void deleteFolderButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.deleteFolderButtonClicked();
        }
    }

    private void newFolderButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.newFolderButtonClicked();
        }
    }

    private void refreshButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.refreshButtonClicked();
        }
    }

    private void myDocumentsButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.myDocumentsButtonClicked();
        }
    }

    private void desktopButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.desktopButtonClicked();
        }
    }

    private void recentFolderSelected(File file) {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.recentFolderSelected(file);
        }
    }

    public final void setRecentList(List list) {
        if (list != null) {
            this._recentFoldersList.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        }
    }

    static final /* synthetic */ void access$100(FolderToolBar folderToolBar, File file) {
        folderToolBar.recentFolderSelected(file);
    }

    static final /* synthetic */ void access$200(FolderToolBar folderToolBar) {
        folderToolBar.desktopButtonClicked();
    }

    static final /* synthetic */ void access$300(FolderToolBar folderToolBar) {
        folderToolBar.myDocumentsButtonClicked();
    }

    static final /* synthetic */ void access$400(FolderToolBar folderToolBar) {
        folderToolBar.deleteFolderButtonClicked();
    }

    static final /* synthetic */ void access$500(FolderToolBar folderToolBar) {
        folderToolBar.newFolderButtonClicked();
    }

    static final /* synthetic */ void access$600(FolderToolBar folderToolBar) {
        folderToolBar.refreshButtonClicked();
    }

    static final /* synthetic */ FileSystemView access$700() {
        return _fsv;
    }
}

