/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.PopupUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJidePopupUI$PopupLayout;
import com.jidesoft.plaf.basic.BasicJidePopupUI$PopupPropertyChangeListener;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.Gripper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicJidePopupUI
extends PopupUI {
    protected JidePopup _popup;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _dockableFrameLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected Gripper _titlePane;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;

    public static final ComponentUI createUI(JComponent jComponent) {
        return new BasicJidePopupUI((JidePopup)jComponent);
    }

    public BasicJidePopupUI() {
    }

    public BasicJidePopupUI(JidePopup jidePopup) {
        this._popup = jidePopup;
    }

    public final void installUI(JComponent jComponent) {
        this._popup = (JidePopup)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this._popup.setOpaque(true);
    }

    public final void uninstallUI(JComponent jComponent) {
        if (jComponent != this._popup) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this._popup + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._popup = null;
    }

    protected final void installDefaults() {
        Color color;
        JComponent jComponent = (JComponent)this._popup.getContentPane();
        if (jComponent != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
        this._dockableFrameLayout = this.createLayoutManager();
        this._popup.setLayout(this._dockableFrameLayout);
        this._popup.setBackground(UIDefaultsLookup.getColor("JideButton.background"));
        LookAndFeel.installBorder(this._popup, "Popup.border");
    }

    protected final void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._popup, actionMap);
    }

    private final ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get("Popup.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Popup.actionMap", actionMap);
        }
        return actionMap;
    }

    private final ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        return actionMapUIResource;
    }

    protected final void installComponents() {
        this.setNorthPane(this.createNorthPane(this._popup));
        this.setSouthPane(this.createSouthPane(this._popup));
        this.setEastPane(this.createEastPane(this._popup));
        this.setWestPane(this.createWestPane(this._popup));
    }

    protected final void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._popup.addPropertyChangeListener(this._propertyChangeListener);
    }

    private final InputMap getInputMap(int n) {
        if (n == 2) {
            return this.createInputMap(n);
        }
        return null;
    }

    private final InputMap createInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIDefaultsLookup.get("Popup.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._popup, objectArray);
        }
        return null;
    }

    protected final void uninstallDefaults() {
        this._dockableFrameLayout = null;
        this._popup.setLayout(null);
        LookAndFeel.uninstallBorder(this._popup);
    }

    protected final void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this._titlePane = null;
    }

    protected final void uninstallListeners() {
        this._popup.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
    }

    protected final void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this._popup, 2, null);
        SwingUtilities.replaceUIActionMap(this._popup, null);
    }

    public final Component getGripper() {
        return this._titlePane;
    }

    protected final LayoutManager createLayoutManager() {
        return new BasicJidePopupUI$PopupLayout(this);
    }

    protected final PropertyChangeListener createPropertyChangeListener() {
        return new BasicJidePopupUI$PopupPropertyChangeListener(this);
    }

    public final Dimension getPreferredSize(JComponent jComponent) {
        if (this._popup == jComponent && this._popup.getLayout() != null) {
            return this._popup.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    public final Dimension getMinimumSize(JComponent jComponent) {
        if (this._popup == jComponent) {
            return this._popup.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public final Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected final void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this._popup.remove(jComponent);
        }
        if (jComponent2 != null) {
            this._popup.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    protected final void deinstallMouseHandlers(JComponent jComponent) {
    }

    protected final void installMouseHandlers(JComponent jComponent) {
    }

    protected final JComponent createNorthPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 1 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected final JComponent createSouthPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 5 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected final JComponent createWestPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 7 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected final JComponent createEastPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 3 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
        this.keyBindingRegistered = bl;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final void setKeyBindingActive(boolean bl) {
        this.keyBindingActive = bl;
    }

    protected final void setupMenuOpenKey() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this._popup, 2, inputMap);
    }

    protected final void setupMenuCloseKey() {
    }

    public final JComponent getNorthPane() {
        return this._northPane;
    }

    protected final void setNorthPane(JComponent jComponent) {
        this.replacePane(this._northPane, jComponent);
        this._northPane = jComponent;
    }

    public final JComponent getSouthPane() {
        return this._southPane;
    }

    protected final void setSouthPane(JComponent jComponent) {
        this.replacePane(this._southPane, jComponent);
        this._southPane = jComponent;
    }

    public final JComponent getWestPane() {
        return this._westPane;
    }

    protected final void setWestPane(JComponent jComponent) {
        this.replacePane(this._westPane, jComponent);
        this._westPane = jComponent;
    }

    public final JComponent getEastPane() {
        return this._eastPane;
    }

    protected final void setEastPane(JComponent jComponent) {
        this.replacePane(this._eastPane, jComponent);
        this._eastPane = jComponent;
    }
}

