/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFolderChooserUI;
import com.jidesoft.plaf.basic.LazyMutableTreeNode;
import com.jidesoft.swing.FolderChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

class BasicFileSystemTreeNode
extends LazyMutableTreeNode
implements Comparable {
    private FolderChooser _folderChooser;
    private File _file;
    static HashMap _icons = new HashMap();
    static HashMap _nodes = new HashMap();

    protected BasicFileSystemTreeNode(File file) {
        this(file, null);
    }

    protected BasicFileSystemTreeNode(File file, FolderChooser folderChooser) {
        this._file = file;
        this._folderChooser = folderChooser;
    }

    public final boolean isLeaf() {
        if (!this.isLoaded()) {
            return false;
        }
        return super.isLeaf();
    }

    public final boolean hasChildren() {
        if (!this._loaded) {
            if (BasicFolderChooserUI.isFileSystem(this._file) && this._file.isDirectory()) {
                File[] fileArray;
                for (File file : fileArray = this._folderChooser.getFileSystemView().getFiles(this._file, this._folderChooser.isFileHidingEnabled())) {
                    if (!file.isDirectory()) continue;
                    return true;
                }
                this._loaded = true;
            }
            return false;
        }
        return this.getChildCount() != 0;
    }

    protected final void initChildren() {
        if (this._folderChooser == null) {
            return;
        }
        if (this._file.isDirectory()) {
            File[] fileArray = new File[]{};
            try {
                fileArray = this._folderChooser.getFileSystemView().getFiles(this._file, this._folderChooser.isFileHidingEnabled());
            }
            catch (Error error) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<BasicFileSystemTreeNode> arrayList = new ArrayList<BasicFileSystemTreeNode>();
            for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                BasicFileSystemTreeNode comparable = BasicFileSystemTreeNode.createFileSystemTreeNode(file, this._folderChooser);
                arrayList.add(comparable);
            }
            Comparable<File>[] comparableArray = arrayList.toArray(new BasicFileSystemTreeNode[arrayList.size()]);
            Arrays.sort(comparableArray);
            for (Comparable<File> comparable : comparableArray) {
                this.add((MutableTreeNode)((Object)comparable));
            }
        }
    }

    public final File getFile() {
        return this._file;
    }

    public final String getName() {
        return this.getName(this.getFile());
    }

    public final Icon getIcon() {
        Icon icon = (Icon)_icons.get(this);
        if (icon == null) {
            icon = this.getIcon(this.getFile());
            _icons.put(this, icon);
            return icon;
        }
        return icon;
    }

    public final String getTypeDescription() {
        String string = this.getTypeDescription(this.getFile());
        return string == null ? "" : string;
    }

    public final Icon getIcon(File file) {
        return this._folderChooser.getFileSystemView().getSystemIcon(file);
    }

    public final String getTypeDescription(File file) {
        return this._folderChooser.getFileSystemView().getSystemTypeDescription(file);
    }

    public final String getName(File file) {
        return this._folderChooser.getFileSystemView().getSystemDisplayName(file);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicFileSystemTreeNode basicFileSystemTreeNode = (BasicFileSystemTreeNode)object;
        return !(this._file == null ? basicFileSystemTreeNode._file != null : !this._file.equals(basicFileSystemTreeNode._file));
    }

    public final int compareTo(Object object) {
        if (!(object instanceof BasicFileSystemTreeNode)) {
            return 0;
        }
        return this.getFile().compareTo(((BasicFileSystemTreeNode)object).getFile());
    }

    public final int hashCode() {
        return this._file != null ? this._file.hashCode() : 0;
    }

    public final boolean canEnqueue() {
        return !this.isLoaded() && !this._folderChooser.getFileSystemView().isFloppyDrive(this.getFile()) && !this._folderChooser.getFileSystemView().isFileSystemRoot(this.getFile());
    }

    public final String toString() {
        return this._file != null ? this._file.toString() : "null";
    }

    public static final BasicFileSystemTreeNode createFileSystemTreeNode(File file, FolderChooser folderChooser) {
        BasicFileSystemTreeNode basicFileSystemTreeNode = (BasicFileSystemTreeNode)_nodes.get(file);
        if (basicFileSystemTreeNode == null) {
            basicFileSystemTreeNode = new BasicFileSystemTreeNode(file, folderChooser);
            _nodes.put(file, basicFileSystemTreeNode);
        }
        return basicFileSystemTreeNode;
    }

    public static final void clearCache() {
        _nodes.clear();
    }
}

