/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty$1;
import com.jidesoft.plaf.WindowsDesktopProperty$WeakPCL;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class WindowsDesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private WindowsDesktopProperty$WeakPCL pcl;
    private String key;
    private Object value;
    private Object fallback;
    private Toolkit toolkit;
    private float fontSize = -1.0f;
    private int fontStyle = -1;

    private static synchronized void setUpdatePending(boolean bl) {
        updatePending = bl;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            WindowsDesktopProperty.updateWindowUI(frame);
        }
    }

    private static void updateWindowUI(Window window) {
        Window[] windowArray;
        SwingUtilities.updateComponentTreeUI(window);
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            WindowsDesktopProperty.updateWindowUI(window2);
        }
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit, float f2) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
        this.fontSize = f2;
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit, float f2, int n) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
        this.fontSize = f2;
        this.fontStyle = n;
    }

    public final Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    protected final Object getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        Object object = this.toolkit.getDesktopProperty(this.getKey());
        this.pcl = new WindowsDesktopProperty$WeakPCL(this, this.toolkit);
        this.toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        return object;
    }

    protected final Object getDefaultValue() {
        if (this.fallback instanceof String) {
            return UIDefaultsLookup.get(this.fallback);
        }
        return this.fallback;
    }

    public final void invalidate() {
        if (this.pcl != null) {
            this.toolkit.removePropertyChangeListener(this.getKey(), this.pcl);
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected final void updateUI() {
        if (!WindowsDesktopProperty.isUpdatePending()) {
            WindowsDesktopProperty.setUpdatePending(true);
            WindowsDesktopProperty$1 windowsDesktopProperty$1 = new WindowsDesktopProperty$1(this);
            SwingUtilities.invokeLater(windowsDesktopProperty$1);
        }
    }

    protected final Object configureValue(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return new ColorUIResource((Color)object);
            }
            if (object instanceof Font) {
                if (this.fontSize != -1.0f && (float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontStyle, this.fontSize));
                }
                if (this.fontSize != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontSize));
                }
                if ((float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontStyle));
                }
                return new FontUIResource((Font)object);
            }
            if (object instanceof UIDefaults.ProxyLazyValue) {
                object = ((UIDefaults.ProxyLazyValue)object).createValue(null);
            } else if (object instanceof UIDefaults.ActiveValue) {
                object = ((UIDefaults.ActiveValue)object).createValue(null);
            }
        }
        return object;
    }

    protected final String getKey() {
        return this.key;
    }

    static final /* synthetic */ void access$000() {
        WindowsDesktopProperty.updateAllUIs();
    }

    static final /* synthetic */ void access$100(boolean bl) {
        WindowsDesktopProperty.setUpdatePending(bl);
    }
}

