/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonPanel;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SizeRequirements;

class ButtonPanelLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private Container _target;
    private transient SizeRequirements[] _xChildren;
    private transient SizeRequirements[] _yChildren;
    private transient SizeRequirements _xTotal;
    private transient SizeRequirements _yTotal;
    private List _affirmativeButtons = new Vector(13);
    private List _cancelButtons = new Vector(13);
    private List _helpButtons = new Vector(13);
    private List _otherButtons = new Vector(13);
    int _minWidth;
    int _maxWidth;
    int _groupGap = 10;
    int _buttonGap = 6;
    private int _sizeConstraint = 1;
    private String _buttonOrder = "ACO";
    private String _oppositeButtonOrder = "H";
    private int _minButtonWidth = 75;
    private int _axis = 0;
    private int _alignment = 11;
    private static final long serialVersionUID = -738156624351781041L;

    public ButtonPanelLayout(Container container, int n, int n2, int n3, String string, String string2, int n4, int n5) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n;
        this._target = container;
        this._alignment = n2;
        this._sizeConstraint = n3;
        this._buttonOrder = string;
        this._oppositeButtonOrder = string2;
        this._buttonGap = n4;
        this._groupGap = n5;
    }

    public synchronized void invalidateLayout(Container container) {
        this.checkContainer(container);
        this._xChildren = null;
        this._yChildren = null;
        this._xTotal = null;
        this._yTotal = null;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void removeLayoutComponent(Component component) {
        if (this._affirmativeButtons.contains(component)) {
            this._affirmativeButtons.remove(component);
        }
        if (this._cancelButtons.contains(component)) {
            this._cancelButtons.remove(component);
        }
        if (this._helpButtons.contains(component)) {
            this._helpButtons.remove(component);
        }
        if (this._otherButtons.contains(component)) {
            this._otherButtons.remove(component);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if ("AFFIRMATIVE".equals(object) && !this._affirmativeButtons.contains(component)) {
            this._affirmativeButtons.add(component);
        }
        if ("CANCEL".equals(object) && !this._cancelButtons.contains(component)) {
            this._cancelButtons.add(component);
        }
        if ("HELP".equals(object) && !this._helpButtons.contains(component)) {
            this._helpButtons.add(component);
        }
        if ("ALTERNATIVE".equals(object) && !this._otherButtons.contains(component)) {
            this._otherButtons.add(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.preferred, this._yTotal.preferred);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.minimum, this._yTotal.minimum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        Dimension dimension2 = this.preferredLayoutSize(container);
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.maximum, this._yTotal.maximum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        Dimension dimension2 = this.preferredLayoutSize(container);
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public synchronized float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this._xTotal.alignment;
    }

    public synchronized float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this._yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        this.checkContainer(container);
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        int n = this.resolveAxis(this._axis, componentOrientation);
        boolean bl = componentOrientation.isLeftToRight();
        int n2 = this._alignment;
        if (this._alignment == 10) {
            n2 = bl ? 2 : 4;
        } else if (this._alignment == 11) {
            n2 = bl ? 4 : 2;
        }
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkRequests();
            this.resetBounds();
            if (n == 0) {
                int n3 = insets.top;
                if (n2 == 0) {
                    char c2;
                    int n4;
                    Dimension dimension2 = this.preferredLayoutSize(container);
                    int n5 = (dimension.width + dimension2.width) / 2;
                    for (n4 = 0; n4 < this.getButtonOrder().length(); ++n4) {
                        c2 = this.getButtonOrder().charAt(this.getButtonOrder().length() - n4 - 1);
                        if (c2 == 'A' || c2 == 'a') {
                            n5 = this.layoutButtonsRightAlign(this._affirmativeButtons, n5, n3, dimension, bl);
                            continue;
                        }
                        if (c2 == 'C' || c2 == 'c') {
                            n5 = this.layoutButtonsRightAlign(this._cancelButtons, n5, n3, dimension, bl);
                            continue;
                        }
                        if (c2 == 'H' || c2 == 'h') {
                            n5 = this.layoutButtonsRightAlign(this._helpButtons, n5, n3, dimension, bl);
                            continue;
                        }
                        if (c2 != 'O' && c2 != 'o') continue;
                        n5 = this.layoutButtonsRightAlign(this._otherButtons, n5, n3, dimension, bl);
                    }
                    n5 = (dimension.width - dimension2.width) / 2;
                    for (n4 = 0; n4 < this.getOppositeButtonOrder().length(); ++n4) {
                        c2 = this.getOppositeButtonOrder().charAt(n4);
                        if (c2 == 'A' || c2 == 'a') {
                            n5 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n5, n3, dimension, bl);
                            continue;
                        }
                        if (c2 == 'C' || c2 == 'c') {
                            n5 = this.layoutButtonsLeftAlign(this._cancelButtons, n5, n3, dimension, bl);
                            continue;
                        }
                        if (c2 == 'H' || c2 == 'h') {
                            n5 = this.layoutButtonsLeftAlign(this._helpButtons, n5, n3, dimension, bl);
                            continue;
                        }
                        if (c2 != 'O' && c2 != 'o') continue;
                        n5 = this.layoutButtonsLeftAlign(this._otherButtons, n5, n3, dimension, bl);
                    }
                } else if (n2 == 4) {
                    char c3;
                    int n6;
                    int n7 = insets.left + dimension.width;
                    for (n6 = 0; n6 < this.getButtonOrder().length(); ++n6) {
                        c3 = this.getButtonOrder().charAt(bl ? this.getButtonOrder().length() - n6 - 1 : n6);
                        if (c3 == 'A' || c3 == 'a') {
                            n7 = this.layoutButtonsRightAlign(this._affirmativeButtons, n7, n3, dimension, bl);
                            continue;
                        }
                        if (c3 == 'C' || c3 == 'c') {
                            n7 = this.layoutButtonsRightAlign(this._cancelButtons, n7, n3, dimension, bl);
                            continue;
                        }
                        if (c3 == 'H' || c3 == 'h') {
                            n7 = this.layoutButtonsRightAlign(this._helpButtons, n7, n3, dimension, bl);
                            continue;
                        }
                        if (c3 != 'O' && c3 != 'o') continue;
                        n7 = this.layoutButtonsRightAlign(this._otherButtons, n7, n3, dimension, bl);
                    }
                    n7 = insets.left;
                    for (n6 = 0; n6 < this.getOppositeButtonOrder().length(); ++n6) {
                        c3 = this.getOppositeButtonOrder().charAt(bl ? n6 : this.getOppositeButtonOrder().length() - n6 - 1);
                        if (c3 == 'A' || c3 == 'a') {
                            n7 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n7, n3, dimension, bl);
                            continue;
                        }
                        if (c3 == 'C' || c3 == 'c') {
                            n7 = this.layoutButtonsLeftAlign(this._cancelButtons, n7, n3, dimension, bl);
                            continue;
                        }
                        if (c3 == 'H' || c3 == 'h') {
                            n7 = this.layoutButtonsLeftAlign(this._helpButtons, n7, n3, dimension, bl);
                            continue;
                        }
                        if (c3 != 'O' && c3 != 'o') continue;
                        n7 = this.layoutButtonsLeftAlign(this._otherButtons, n7, n3, dimension, bl);
                    }
                } else if (n2 == 2) {
                    char c4;
                    int n8;
                    int n9 = insets.left;
                    for (n8 = 0; n8 < this.getButtonOrder().length(); ++n8) {
                        c4 = this.getButtonOrder().charAt(bl ? n8 : this.getButtonOrder().length() - n8 - 1);
                        if (c4 == 'A' || c4 == 'a') {
                            n9 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n9, n3, dimension, bl);
                            continue;
                        }
                        if (c4 == 'C' || c4 == 'c') {
                            n9 = this.layoutButtonsLeftAlign(this._cancelButtons, n9, n3, dimension, bl);
                            continue;
                        }
                        if (c4 == 'H' || c4 == 'h') {
                            n9 = this.layoutButtonsLeftAlign(this._helpButtons, n9, n3, dimension, bl);
                            continue;
                        }
                        if (c4 != 'O' && c4 != 'o') continue;
                        n9 = this.layoutButtonsLeftAlign(this._otherButtons, n9, n3, dimension, bl);
                    }
                    n9 = insets.left + dimension.width;
                    for (n8 = 0; n8 < this.getOppositeButtonOrder().length(); ++n8) {
                        c4 = this.getOppositeButtonOrder().charAt(bl ? this.getOppositeButtonOrder().length() - n8 - 1 : n8);
                        if (c4 == 'A' || c4 == 'a') {
                            n9 = this.layoutButtonsRightAlign(this._affirmativeButtons, n9, n3, dimension, bl);
                            continue;
                        }
                        if (c4 == 'C' || c4 == 'c') {
                            n9 = this.layoutButtonsRightAlign(this._cancelButtons, n9, n3, dimension, bl);
                            continue;
                        }
                        if (c4 == 'H' || c4 == 'h') {
                            n9 = this.layoutButtonsRightAlign(this._helpButtons, n9, n3, dimension, bl);
                            continue;
                        }
                        if (c4 != 'O' && c4 != 'o') continue;
                        n9 = this.layoutButtonsRightAlign(this._otherButtons, n9, n3, dimension, bl);
                    }
                }
            } else {
                int n10 = insets.left;
                if (n2 == 1) {
                    char c5;
                    int n11;
                    int n12 = insets.top;
                    for (n11 = 0; n11 < this.getButtonOrder().length(); ++n11) {
                        c5 = this.getButtonOrder().charAt(n11);
                        if (c5 == 'A' || c5 == 'a') {
                            n12 = this.layoutButtonsTopAlign(this._affirmativeButtons, n10, n12, dimension);
                            continue;
                        }
                        if (c5 == 'C' || c5 == 'c') {
                            n12 = this.layoutButtonsTopAlign(this._cancelButtons, n10, n12, dimension);
                            continue;
                        }
                        if (c5 == 'H' || c5 == 'h') {
                            n12 = this.layoutButtonsTopAlign(this._helpButtons, n10, n12, dimension);
                            continue;
                        }
                        if (c5 != 'O' && c5 != 'o') continue;
                        n12 = this.layoutButtonsTopAlign(this._otherButtons, n10, n12, dimension);
                    }
                    n12 = insets.top + dimension.height;
                    for (n11 = 0; n11 < this.getOppositeButtonOrder().length(); ++n11) {
                        c5 = this.getOppositeButtonOrder().charAt(this.getOppositeButtonOrder().length() - n11 - 1);
                        if (c5 == 'A' || c5 == 'a') {
                            n12 = this.layoutButtonsBottomAlign(this._affirmativeButtons, n10, n12, dimension);
                            continue;
                        }
                        if (c5 == 'C' || c5 == 'c') {
                            n12 = this.layoutButtonsBottomAlign(this._cancelButtons, n10, n12, dimension);
                            continue;
                        }
                        if (c5 == 'H' || c5 == 'h') {
                            n12 = this.layoutButtonsBottomAlign(this._helpButtons, n10, n12, dimension);
                            continue;
                        }
                        if (c5 != 'O' && c5 != 'o') continue;
                        n12 = this.layoutButtonsBottomAlign(this._otherButtons, n10, n12, dimension);
                    }
                } else if (n2 == 3) {
                    char c6;
                    int n13;
                    int n14 = insets.top + dimension.height;
                    for (n13 = 0; n13 < this.getButtonOrder().length(); ++n13) {
                        c6 = this.getButtonOrder().charAt(this.getButtonOrder().length() - n13 - 1);
                        if (c6 == 'A' || c6 == 'a') {
                            n14 = this.layoutButtonsBottomAlign(this._affirmativeButtons, n10, n14, dimension);
                            continue;
                        }
                        if (c6 == 'C' || c6 == 'c') {
                            n14 = this.layoutButtonsBottomAlign(this._cancelButtons, n10, n14, dimension);
                            continue;
                        }
                        if (c6 == 'H' || c6 == 'h') {
                            n14 = this.layoutButtonsBottomAlign(this._helpButtons, n10, n14, dimension);
                            continue;
                        }
                        if (c6 != 'O' && c6 != 'o') continue;
                        n14 = this.layoutButtonsBottomAlign(this._otherButtons, n10, n14, dimension);
                    }
                    n14 = insets.top;
                    for (n13 = 0; n13 < this.getOppositeButtonOrder().length(); ++n13) {
                        c6 = this.getOppositeButtonOrder().charAt(n13);
                        if (c6 == 'A' || c6 == 'a') {
                            n14 = this.layoutButtonsTopAlign(this._affirmativeButtons, n10, n14, dimension);
                            continue;
                        }
                        if (c6 == 'C' || c6 == 'c') {
                            n14 = this.layoutButtonsTopAlign(this._cancelButtons, n10, n14, dimension);
                            continue;
                        }
                        if (c6 == 'H' || c6 == 'h') {
                            n14 = this.layoutButtonsTopAlign(this._helpButtons, n10, n14, dimension);
                            continue;
                        }
                        if (c6 != 'O' && c6 != 'o') continue;
                        n14 = this.layoutButtonsTopAlign(this._otherButtons, n10, n14, dimension);
                    }
                }
            }
        }
    }

    private int layoutButtonsRightAlign(List list, int n, int n2, Dimension dimension, boolean bl) {
        boolean bl2 = false;
        for (int i2 = this._target.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = bl ? this._target.getComponent(i2) : this._target.getComponent(this._target.getComponentCount() - 1 - i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            if (bl2) {
                n -= this._buttonGap;
            }
            bl2 = true;
            int n3 = component.getPreferredSize().width;
            int n4 = n3 > this._minWidth || this.shouldKeepPreferredWidth(component) ? n3 : this._minWidth;
            component.setBounds(n - n4, n2, n4, dimension.height);
            n -= n4;
        }
        if (list.size() != 0 && bl2) {
            n -= this._groupGap;
        }
        return n;
    }

    private int layoutButtonsLeftAlign(List list, int n, int n2, Dimension dimension, boolean bl) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = bl ? this._target.getComponent(i2) : this._target.getComponent(this._target.getComponentCount() - 1 - i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            bl2 = true;
            int n3 = component.getPreferredSize().width;
            int n4 = n3 > this._minWidth || this.shouldKeepPreferredWidth(component) ? n3 : this._minWidth;
            component.setBounds(n, n2, n4, dimension.height);
            n += n4 + this._buttonGap;
        }
        if (bl2) {
            n -= this._buttonGap;
            n += this._groupGap;
        }
        return n;
    }

    private int layoutButtonsBottomAlign(List list, int n, int n2, Dimension dimension) {
        boolean bl = false;
        for (int i2 = this._target.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            if (bl) {
                n2 -= this._buttonGap;
            }
            bl = true;
            Dimension dimension2 = component.getPreferredSize();
            int n3 = dimension2.height;
            int n4 = dimension2.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? dimension.width - n4 + n : n, n2 - n3, this.shouldKeepPreferredWidth(component) ? n4 : dimension.width, n3);
            n2 -= n3;
        }
        if (list.size() != 0 && bl) {
            n2 -= this._groupGap;
        }
        return n2;
    }

    private int layoutButtonsTopAlign(List list, int n, int n2, Dimension dimension) {
        boolean bl = false;
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !list.contains(component)) continue;
            bl = true;
            Dimension dimension2 = component.getPreferredSize();
            int n3 = dimension2.height;
            int n4 = dimension2.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? dimension.width - n4 + n : n, n2, this.shouldKeepPreferredWidth(component) ? n4 : dimension.width, n3);
            n2 += n3 + this._buttonGap;
        }
        if (bl) {
            n2 -= this._buttonGap;
            n2 += this._groupGap;
        }
        return n2;
    }

    private boolean shouldKeepPreferredWidth(Component component) {
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("keepPreferredWidth"));
    }

    void checkContainer(Container container) {
        if (this._target != container) {
            throw new AWTError("BorderPaneLayout can't be shared");
        }
        if (!(container instanceof ButtonPanel)) {
            throw new AWTError("Target is not a ButtonPanel");
        }
    }

    int getButtonCountof(List list) {
        int n = 0;
        for (Component component : list) {
            if (!component.isVisible()) continue;
            ++n;
        }
        return n;
    }

    void checkRequests() {
        int n = (this.getButtonCountof(this._affirmativeButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._otherButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._cancelButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._helpButtons) == 0 ? 0 : 1);
        int n2 = this.getButtonCountof(this._affirmativeButtons) + this.getButtonCountof(this._otherButtons) + this.getButtonCountof(this._cancelButtons) + this.getButtonCountof(this._helpButtons);
        if (this._xChildren == null || this._yChildren == null) {
            int n3;
            int n4;
            int n5;
            int n6 = n5 = this._target.getComponentCount();
            for (n4 = 0; n4 < n5; ++n4) {
                if (this._target.getComponent(n4).isVisible()) continue;
                --n6;
            }
            this._xChildren = new SizeRequirements[n6];
            this._yChildren = new SizeRequirements[n6];
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                Component component = this._target.getComponent(n3);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension serializable = component.getMaximumSize();
                this._xChildren[n4] = new SizeRequirements(dimension.width, dimension2.width, serializable.width, component.getAlignmentX());
                this._yChildren[n4] = new SizeRequirements(dimension.height, dimension2.height, serializable.height, component.getAlignmentY());
                if (this.shouldKeepPreferredWidth(this._target.getComponent(n3))) {
                    this._xChildren[n4].maximum = 0;
                }
                ++n4;
            }
            n3 = this.resolveAxis(this._axis, this._target.getComponentOrientation());
            if (n3 == 0) {
                int n7;
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getAlignedSizeRequirements(this._yChildren);
                this._maxWidth = SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._xChildren).maximum;
                if (this._sizeConstraint == 0) {
                    n7 = this.getMinButtonWidth();
                    if (this._maxWidth < n7) {
                        this._maxWidth = n7;
                    }
                    this._minWidth = this._maxWidth;
                } else {
                    n7 = this.getMinButtonWidth();
                    this._minWidth = n7 == 0 ? 75 : n7;
                }
                for (SizeRequirements sizeRequirements : this._xChildren) {
                    if (sizeRequirements.preferred >= this._minWidth) continue;
                    sizeRequirements.preferred = this._minWidth;
                }
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._xTotal.preferred += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
                this._xTotal.minimum += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
            } else {
                this._xTotal = SizeRequirements.getAlignedSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getTiledSizeRequirements(this._yChildren);
                int n8 = this.getMinButtonWidth();
                this._maxWidth = n8 == 0 ? 75 : n8;
                this._minWidth = this._maxWidth;
                this._xTotal.preferred = this._maxWidth > this._xTotal.maximum ? this._maxWidth : this._xTotal.preferred;
                this._yTotal.preferred += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
                this._yTotal.minimum += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
            }
        }
    }

    private int resolveAxis(int n, ComponentOrientation componentOrientation) {
        int n2 = n == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n);
        return n2;
    }

    public int getGroupGap() {
        return this._groupGap;
    }

    public void setGroupGap(int n) {
        this._groupGap = n;
        this.invalidateLayout(this._target);
    }

    public int getButtonGap() {
        return this._buttonGap;
    }

    public void setButtonGap(int n) {
        this._buttonGap = n;
        this.invalidateLayout(this._target);
    }

    public int getSizeConstraint() {
        return this._sizeConstraint;
    }

    public void setSizeConstraint(int n) {
        this._sizeConstraint = n;
        this.invalidateLayout(this._target);
    }

    public int getMinButtonWidth() {
        return this._minButtonWidth;
    }

    public void setMinButtonWidth(int n) {
        this._minButtonWidth = n;
        this.invalidateLayout(this._target);
    }

    public String getButtonOrder() {
        if (this._buttonOrder == null) {
            return "";
        }
        return this._buttonOrder;
    }

    public void setButtonOrder(String string) {
        this._buttonOrder = string;
        this.invalidateLayout(this._target);
    }

    public String getOppositeButtonOrder() {
        if (this._oppositeButtonOrder == null) {
            return "";
        }
        return this._oppositeButtonOrder;
    }

    public void setOppositeButtonOrder(String string) {
        this._oppositeButtonOrder = string;
        this.invalidateLayout(this._target);
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int n) {
        this._axis = n;
        this.invalidateLayout(this._target);
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int n) {
        this._alignment = n;
        this.invalidateLayout(this._target);
    }

    void resetBounds() {
        for (Component component : this._affirmativeButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._cancelButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._otherButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._helpButtons) {
            component.setBounds(0, 0, 0, 0);
        }
    }
}

