/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.Laziness;
import com.jidesoft.dialog.PageEvent;
import com.jidesoft.dialog.PageListener;
import java.awt.Graphics;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public abstract class AbstractPage
extends JPanel
implements Laziness {
    private static final long serialVersionUID = 3566789990192642869L;
    public static int INVOKE_ON_ALL = -1;
    public static int INVOKE_ON_NONE = 0;
    public static int INVOKE_ON_PAINT = 1;
    public static int INVOKE_ON_REPAINT = 2;
    public static int INVOKE_ON_UPDATE = 4;
    public static int INVOKE_ON_VALIDATE = 8;
    private boolean _allowClosing = true;
    private int _invokeCondition = INVOKE_ON_PAINT | INVOKE_ON_REPAINT | INVOKE_ON_UPDATE;
    protected transient PageEvent _pageEvent = null;
    private boolean _lazyConstructorCalled = false;
    private static final Logger LOGGER_EVENT = Logger.getLogger(PageEvent.class.getName());

    protected AbstractPage() {
    }

    public final int getInvokeCondition() {
        return this._invokeCondition;
    }

    public final void setInvokeCondition(int n) {
        this._invokeCondition = n;
    }

    public final void invalidate() {
        if ((this.getInvokeCondition() & INVOKE_ON_VALIDATE) != 0) {
            this.initialize();
        }
        super.invalidate();
    }

    public final void revalidate() {
        if ((this.getInvokeCondition() & INVOKE_ON_VALIDATE) != 0) {
            this.initialize();
        }
        super.revalidate();
    }

    public final void paint(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paint(graphics);
    }

    public final void paintAll(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paintAll(graphics);
    }

    public final void paintComponents(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paintComponents(graphics);
    }

    public final void repaint() {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint();
    }

    public final void repaint(long l2) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(l2);
    }

    public final void repaint(int n, int n2, int n3, int n4) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(n, n2, n3, n4);
    }

    public final void repaint(long l2, int n, int n2, int n3, int n4) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(l2, n, n2, n3, n4);
    }

    public final void update(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_UPDATE) != 0) {
            this.initialize();
        }
        super.update(graphics);
    }

    public final synchronized void initialize() {
        if (!this._lazyConstructorCalled) {
            this._lazyConstructorCalled = true;
            this.lazyInitialize();
            this.validate();
        }
    }

    public final synchronized void reset() {
        this._lazyConstructorCalled = false;
        this.removeAll();
    }

    public final void addPageListener(PageListener pageListener) {
        this.listenerList.add(PageListener.class, pageListener);
    }

    public final void removePageListener(PageListener pageListener) {
        this.listenerList.remove(PageListener.class, pageListener);
    }

    public final PageListener[] getPageListeners() {
        return (PageListener[])this.listenerList.getListeners(PageListener.class);
    }

    public final void firePageEvent(int n) {
        this.firePageEvent(this, n);
    }

    public final void firePageEvent(Object object, int n) {
        this.initialize();
        if (object == null) {
            object = this;
        }
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 3199: {
                    LOGGER_EVENT.fine("Page \"" + this + " is opened, source is " + object.getClass().getName());
                    break;
                }
                case 3200: {
                    LOGGER_EVENT.fine("Page \"" + this + " is closing, source is " + object.getClass().getName());
                    break;
                }
                case 3201: {
                    LOGGER_EVENT.fine("Page \"" + this + " is closed, source is " + object.getClass().getName());
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PageListener.class) continue;
            this._pageEvent = new PageEvent(object, n);
            ((PageListener)objectArray[i2 + 1]).pageEventFired(this._pageEvent);
        }
    }

    public final void setAllowClosing(boolean bl) {
        this._allowClosing = bl;
    }

    public final boolean allowClosing() {
        return this._allowClosing;
    }
}

