/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.windows.WindowsArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public final class WindowsSpinnerUI
extends com.sun.java.swing.plaf.windows.WindowsSpinnerUI {
    private static final ExtBasicArrowButtonHandler NEXT_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler PREVIOUS_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("decrement", false);

    public static final ComponentUI createUI(JComponent jComponent) {
        return new WindowsSpinnerUI();
    }

    protected final Component createPreviousButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createPreviousButton();
        }
        WindowsArrowButton windowsArrowButton = new WindowsArrowButton(5);
        windowsArrowButton.addActionListener(PREVIOUS_BUTTON_HANDLER);
        windowsArrowButton.addMouseListener(PREVIOUS_BUTTON_HANDLER);
        return windowsArrowButton;
    }

    protected final Component createNextButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createNextButton();
        }
        WindowsArrowButton windowsArrowButton = new WindowsArrowButton(1);
        windowsArrowButton.addActionListener(NEXT_BUTTON_HANDLER);
        windowsArrowButton.addMouseListener(NEXT_BUTTON_HANDLER);
        return windowsArrowButton;
    }

    protected final JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.configureEditorBorder(jComponent);
        return jComponent;
    }

    protected final LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected final void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.configureEditorBorder(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void configureEditorBorder(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            jFormattedTextField.setBorder(new EmptyBorder(insets));
        } else if (jComponent instanceof JPanel && jComponent.getBorder() == null && jComponent.getComponentCount() > 0) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(0);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            jComponent2.setBorder(new EmptyBorder(insets));
        }
    }
}

