/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticTreeUI$LineStyleHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;

public final class PlasticTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;

    public static final ComponentUI createUI(JComponent jComponent) {
        return new PlasticTreeUI();
    }

    public final void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateLineStyle(jComponent.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new PlasticTreeUI$LineStyleHandler(this, null);
        jComponent.addPropertyChangeListener(this.lineStyleHandler);
    }

    public final void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(jComponent);
    }

    protected final void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(graphics, n, n2, n3);
        }
    }

    protected final void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(graphics, n, n2, n3);
        }
    }

    protected final void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, n - icon.getIconWidth() / 2 - 1, n2 - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object object) {
        this.linesEnabled = !"None".equals(object);
    }

    static final void access$100(PlasticTreeUI plasticTreeUI, Object object) {
        plasticTreeUI.updateLineStyle(object);
    }
}

