/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticToolBarUI$1;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public final class PlasticToolBarUI
extends MetalToolBarUI {
    private static final String PROPERTY_PREFIX = "ToolBar.";
    private PropertyChangeListener listener;

    public static final ComponentUI createUI(JComponent jComponent) {
        return new PlasticToolBarUI();
    }

    protected final Border createRolloverBorder() {
        return PlasticBorders.getRolloverButtonBorder();
    }

    protected final void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            super.setBorderToRollover(component);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                super.setBorderToRollover(container.getComponent(i2));
            }
        }
    }

    protected final void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    protected final void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    protected final void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PlasticToolBarUI$1(this);
    }

    private void installSpecialBorder() {
        HeaderStyle headerStyle;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "Plastic.borderStyle");
        String string = borderStyle == BorderStyle.EMPTY ? "emptyBorder" : (borderStyle == BorderStyle.ETCHED ? "etchedBorder" : (borderStyle == BorderStyle.SEPARATOR ? "separatorBorder" : ((headerStyle = HeaderStyle.from(this.toolBar)) == HeaderStyle.BOTH ? "headerBorder" : (headerStyle == HeaderStyle.SINGLE && this.is3D() ? "etchedBorder" : "border"))));
        LookAndFeel.installBorder(this.toolBar, PROPERTY_PREFIX + string);
    }

    public final void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.is3D()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                boolean bl = ((JToolBar)jComponent).getOrientation() == 0;
                PlasticUtils.addLight3DEffekt(graphics, rectangle, bl);
            }
        }
        this.paint(graphics, jComponent);
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.toolBar)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.toolBar)) {
            return false;
        }
        return PlasticUtils.is3D(PROPERTY_PREFIX) && HeaderStyle.from(this.toolBar) != null && BorderStyle.from(this.toolBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }

    static final void access$000(PlasticToolBarUI plasticToolBarUI) {
        plasticToolBarUI.installSpecialBorder();
    }
}

