/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$AbstractRenderer;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$MyPropertyChangeHandler;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollTabsBackwardAction;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollTabsForwardAction;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollableTabSupport;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$TabSelectionHandler;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$TabbedPaneLayout;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$TabbedPaneScrollLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public final class PlasticTabbedPaneUI
extends MetalTabbedPaneUI {
    private static boolean isTabIconsEnabled = Options.isTabIconsEnabled();
    private Boolean noContentBorder;
    private Boolean embeddedTabs;
    private PlasticTabbedPaneUI$AbstractRenderer renderer;
    private PlasticTabbedPaneUI$ScrollableTabSupport tabScroller;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static final ComponentUI createUI(JComponent jComponent) {
        return new PlasticTabbedPaneUI();
    }

    public final void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.embeddedTabs = (Boolean)jComponent.getClientProperty("jgoodies.embeddedTabs");
        this.noContentBorder = (Boolean)jComponent.getClientProperty("jgoodies.noContentBorder");
        this.renderer = this.createRenderer(this.tabPane);
    }

    public final void uninstallUI(JComponent jComponent) {
        this.renderer = null;
        super.uninstallUI(jComponent);
    }

    protected final void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new PlasticTabbedPaneUI$ScrollableTabSupport(this, this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
    }

    protected final void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected final void installListeners() {
        super.installListeners();
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4 && this.scrollableTabLayoutEnabled()) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
    }

    protected final void uninstallListeners() {
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        super.uninstallListeners();
    }

    protected final void installKeyboardActions() {
        super.installKeyboardActions();
        if (this.scrollableTabLayoutEnabled()) {
            PlasticTabbedPaneUI$ScrollTabsForwardAction plasticTabbedPaneUI$ScrollTabsForwardAction = new PlasticTabbedPaneUI$ScrollTabsForwardAction(null);
            PlasticTabbedPaneUI$ScrollTabsBackwardAction plasticTabbedPaneUI$ScrollTabsBackwardAction = new PlasticTabbedPaneUI$ScrollTabsBackwardAction(null);
            ActionMap actionMap = SwingUtilities.getUIActionMap(this.tabPane);
            actionMap.put("scrollTabsForwardAction", plasticTabbedPaneUI$ScrollTabsForwardAction);
            actionMap.put("scrollTabsBackwardAction", plasticTabbedPaneUI$ScrollTabsBackwardAction);
            this.tabScroller.scrollForwardButton.setAction(plasticTabbedPaneUI$ScrollTabsForwardAction);
            this.tabScroller.scrollBackwardButton.setAction(plasticTabbedPaneUI$ScrollTabsBackwardAction);
        }
    }

    private boolean hasNoContentBorder() {
        return Boolean.TRUE.equals(this.noContentBorder);
    }

    private boolean hasEmbeddedTabs() {
        return Boolean.TRUE.equals(this.embeddedTabs);
    }

    private PlasticTabbedPaneUI$AbstractRenderer createRenderer(JTabbedPane jTabbedPane) {
        return this.hasEmbeddedTabs() ? PlasticTabbedPaneUI$AbstractRenderer.access$200(jTabbedPane) : PlasticTabbedPaneUI$AbstractRenderer.access$300(this.tabPane);
    }

    protected final PropertyChangeListener createPropertyChangeListener() {
        return new PlasticTabbedPaneUI$MyPropertyChangeHandler(this, null);
    }

    protected final ChangeListener createChangeListener() {
        return new PlasticTabbedPaneUI$TabSelectionHandler(this, null);
    }

    private void doLayout() {
        this.tabPane.revalidate();
        this.tabPane.repaint();
    }

    private void tabPlacementChanged() {
        this.renderer = this.createRenderer(this.tabPane);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.createButtons();
        }
        this.doLayout();
    }

    private void embeddedTabsPropertyChanged(Boolean bl) {
        this.embeddedTabs = bl;
        this.renderer = this.createRenderer(this.tabPane);
        this.doLayout();
    }

    private void noContentBorderPropertyChanged(Boolean bl) {
        this.noContentBorder = bl;
        this.tabPane.repaint();
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n2, n);
        }
        this.paintContentBorder(graphics, n2, n);
    }

    protected final void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n4 = 0;
        int n5 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n) {
                case 2: 
                case 4: {
                    int n6 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n6 || rectangle3.y + rectangle3.height <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = rectangle3.x;
                    n5 = n6 - 1;
                    break;
                }
                default: {
                    int n6 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n6 || rectangle3.x + rectangle3.width <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = n6 - 1;
                    n5 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        object = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, (String)object, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, (String)object, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n, n2, bl, n4, n5);
            graphics.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n, Rectangle rectangle, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n3 = rectangle.width;
                n4 = rectangle.x;
                n5 = rectangle.x + rectangle.width;
                n6 = rectangle.y;
                break;
            }
            default: {
                n3 = rectangle.height;
                n4 = rectangle.y;
                n5 = rectangle.y + rectangle.height;
                n6 = rectangle.x;
            }
        }
        int n7 = n3 / 12;
        if (n3 % 12 > 0) {
            ++n7;
        }
        int n8 = 2 + n7 * 8;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = 0;
        nArray[n9] = n6;
        nArray2[n9++] = n5;
        nArray[n9] = n6;
        nArray2[n9++] = n4;
        block3: for (int i2 = 0; i2 < n7; ++i2) {
            for (int i3 = 0; i3 < this.xCropLen.length; ++i3) {
                nArray[n9] = n2 - this.xCropLen[i3];
                nArray2[n9] = n4 + i2 * 12 + this.yCropLen[i3];
                if (nArray2[n9] >= n5) {
                    nArray2[n9] = n5;
                    ++n9;
                    continue block3;
                }
                ++n9;
            }
        }
        if (n == 1 || n == 3) {
            return new Polygon(nArray, nArray2, n9);
        }
        return new Polygon(nArray2, nArray, n9);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n, int n2, boolean bl, int n3, int n4) {
        switch (n) {
            case 2: 
            case 4: {
                graphics.setColor(this.shadow);
                for (int i2 = n3; i2 <= n3 + this.rects[n2].width; i2 += 12) {
                    for (int i3 = 0; i3 < this.xCropLen.length; i3 += 2) {
                        graphics.drawLine(i2 + this.yCropLen[i3], n4 - this.xCropLen[i3], i2 + this.yCropLen[i3 + 1] - 1, n4 - this.xCropLen[i3 + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this.shadow);
                for (int i4 = n4; i4 <= n4 + this.rects[n2].height; i4 += 12) {
                    for (int i5 = 0; i5 < this.xCropLen.length; i5 += 2) {
                        graphics.drawLine(n3 - this.xCropLen[i5], i4 + this.yCropLen[i5], n3 - this.xCropLen[i5 + 1], i4 + this.yCropLen[i5 + 1] - 1);
                    }
                }
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            PlasticTabbedPaneUI$TabbedPaneLayout plasticTabbedPaneUI$TabbedPaneLayout = (PlasticTabbedPaneUI$TabbedPaneLayout)this.tabPane.getLayout();
            plasticTabbedPaneUI$TabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public final int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n, n2, point);
            Rectangle rectangle = this.tabScroller.viewport.getViewRect();
            if (!rectangle.contains(point)) {
                return -1;
            }
        }
        int n3 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.rects[i2].contains(point.x, point.y)) continue;
            return i2;
        }
        return -1;
    }

    protected final Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.width = this.rects[n].width;
        rectangle.height = this.rects[n].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n].x + point.x - point2.x;
            rectangle.y = this.rects[n].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n].x;
            rectangle.y = this.rects[n].y;
        }
        return rectangle;
    }

    private int getClosestTab(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n7 = this.tabPane.getTabPlacement();
        boolean bl = n7 == 1 || n7 == 3;
        int n8 = n3 = bl ? n : n2;
        while (n5 != n6) {
            int n9;
            int n10;
            int n11 = (n6 + n5) / 2;
            if (bl) {
                n10 = this.rects[n11].x;
                n9 = n10 + this.rects[n11].width;
            } else {
                n10 = this.rects[n11].y;
                n9 = n10 + this.rects[n11].height;
            }
            if (n3 < n10) {
                n6 = n11;
                if (n5 != n6) continue;
                return Math.max(0, n11 - 1);
            }
            if (n3 >= n9) {
                n5 = n11;
                if (n6 - n5 > 1) continue;
                return Math.max(n11 + 1, n4 - 1);
            }
            return n11;
        }
        return n5;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n - point2.x + point3.x;
        point.y = n2 - point2.y + point3.y;
        return point;
    }

    protected final void paintTabArea(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        for (int i2 = this.runCount - 1; i2 >= 0; --i2) {
            int n4;
            int n5 = this.tabRuns[i2];
            int n6 = this.tabRuns[i2 == this.runCount - 1 ? 0 : i2 + 1];
            for (int i3 = n4 = n6 != 0 ? n6 - 1 : n3 - 1; i3 >= n5; --i3) {
                if (i3 == n2 || !this.rects[i3].intersects(rectangle3)) continue;
                this.paintTab(graphics, n, this.rects, i3, rectangle, rectangle2);
            }
        }
        if (n2 >= 0 && this.rects[n2].intersects(rectangle3)) {
            this.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
        }
    }

    protected final void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        Rectangle rectangle4 = new Rectangle(rectangle);
        if (bl) {
            Insets insets = this.getSelectedTabPadInsets(n);
            rectangle4.x += insets.left;
            rectangle4.y += insets.top;
            rectangle4.width -= insets.left + insets.right;
            rectangle4.height -= insets.bottom + insets.top;
        }
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        if (!(n != 4 && n != 2 || icon == null || string == null || string.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            n3 += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            rectangle2.y += rectangle4.height % 2;
        }
        this.tabPane.putClientProperty("html", null);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected final Icon getIconForTab(int n) {
        String string = this.tabPane.getTitleAt(n);
        boolean bl = string != null && string.length() > 0;
        return !isTabIconsEnabled && bl ? null : super.getIconForTab(n);
    }

    protected final LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new PlasticTabbedPaneUI$TabbedPaneScrollLayout(this, null);
        }
        return new PlasticTabbedPaneUI$TabbedPaneLayout(this, null);
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof PlasticTabbedPaneUI$TabbedPaneScrollLayout;
    }

    protected final boolean isTabInFirstRun(int n) {
        return this.getRunForTab(this.tabPane.getTabCount(), n) == 0;
    }

    protected final void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        graphics.setColor(this.selectColor == null ? this.tabPane.getBackground() : this.selectColor);
        graphics.fillRect(n5, n6, n7, n8);
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        boolean bl = n2 >= 0 && this.isTabInFirstRun(n2);
        boolean bl2 = !this.hasNoContentBorder();
        this.renderer.paintContentBorderTopEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
        this.renderer.paintContentBorderLeftEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
        this.renderer.paintContentBorderBottomEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
        this.renderer.paintContentBorderRightEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
    }

    protected final Insets getContentBorderInsets(int n) {
        return this.renderer.getContentBorderInsets(super.getContentBorderInsets(n));
    }

    protected final Insets getTabAreaInsets(int n) {
        return this.renderer.getTabAreaInsets(super.getTabAreaInsets(n));
    }

    protected final int getTabLabelShiftX(int n, int n2, boolean bl) {
        return this.renderer.getTabLabelShiftX(n2, bl);
    }

    protected final int getTabLabelShiftY(int n, int n2, boolean bl) {
        return this.renderer.getTabLabelShiftY(n2, bl);
    }

    protected final int getTabRunOverlay(int n) {
        return this.renderer.getTabRunOverlay(this.tabRunOverlay);
    }

    protected final boolean shouldPadTabRun(int n, int n2) {
        return this.renderer.shouldPadTabRun(n2, super.shouldPadTabRun(n, n2));
    }

    protected final int getTabRunIndent(int n, int n2) {
        return this.renderer.getTabRunIndent(n2);
    }

    protected final Insets getTabInsets(int n, int n2) {
        return this.renderer.getTabInsets(n2, this.tabInsets);
    }

    protected final Insets getSelectedTabPadInsets(int n) {
        return this.renderer.getSelectedTabPadInsets();
    }

    protected final void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        this.renderer.paintFocusIndicator(graphics, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    protected final void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.renderer.paintTabBackground(graphics, n2, n3, n4, n5, n6, bl);
    }

    protected final void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.renderer.paintTabBorder(graphics, n2, n3, n4, n5, n6, bl);
    }

    protected final boolean shouldRotateTabRuns(int n) {
        return false;
    }

    private boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    static final Rectangle[] access$800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final PlasticTabbedPaneUI$ScrollableTabSupport access$1000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabScroller;
    }

    static final PlasticTabbedPaneUI$AbstractRenderer access$1100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.renderer;
    }

    static final void access$1200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.tabPlacementChanged();
    }

    static final void access$1300(PlasticTabbedPaneUI plasticTabbedPaneUI, Boolean bl) {
        plasticTabbedPaneUI.embeddedTabsPropertyChanged(bl);
    }

    static final void access$1400(PlasticTabbedPaneUI plasticTabbedPaneUI, Boolean bl) {
        plasticTabbedPaneUI.noContentBorderPropertyChanged(bl);
    }

    static final FontMetrics access$1500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getFontMetrics();
    }

    static final JTabbedPane access$1600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$1700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$1800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$1900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final int access$2002(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabWidth = n;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$2100(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n);
    }

    static final int access$2202(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabWidth = n;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$2300(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n);
    }

    static final int access$2400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$2502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabHeight = n;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$2600(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n);
    }

    static final int access$2700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$2802(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabHeight = n;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$2900(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n);
    }

    static final int access$3002(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.runCount = n;
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$3102(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.selectedRun = n;
        return plasticTabbedPaneUI.selectedRun;
    }

    static final Rectangle[] access$3200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$3300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$3400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final int[] access$3500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int access$3602(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.runCount = n;
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$3702(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabWidth = n;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$3800(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, FontMetrics fontMetrics) {
        return plasticTabbedPaneUI.calculateTabWidth(n, n2, fontMetrics);
    }

    static final int access$3902(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabWidth = n;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$4000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$4100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int[] access$4200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final void access$4300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.expandTabRunsArray();
    }

    static final int[] access$4400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int access$4500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$4608(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount++;
    }

    static final int access$4700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$4800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final Rectangle[] access$4900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$5000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final int[] access$5100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int access$5202(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.runCount = n;
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$5302(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabHeight = n;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$5400(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, int n3) {
        return plasticTabbedPaneUI.calculateTabHeight(n, n2, n3);
    }

    static final int access$5502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabHeight = n;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$5600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$5700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int[] access$5800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final void access$5900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.expandTabRunsArray();
    }

    static final int[] access$6000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int access$6100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$6208(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount++;
    }

    static final int access$6300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$6400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$6502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.selectedRun = n;
        return plasticTabbedPaneUI.selectedRun;
    }

    static final int access$6600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$6700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$6800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.selectedRun;
    }

    static final int access$6900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int[] access$7000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int[] access$7100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int access$7200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final Rectangle[] access$7300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final int access$7400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$7500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final Rectangle[] access$7600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final int access$7700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$7800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final Rectangle[] access$7900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$8000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$8100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$8200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final boolean access$8300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.scrollableTabLayoutEnabled();
    }

    static final int access$8400(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n);
    }

    static final int access$8500(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n);
    }

    static final JTabbedPane access$8600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$8700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$8800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$8900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final Component access$9000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getVisibleComponent();
    }

    static final void access$9100(PlasticTabbedPaneUI plasticTabbedPaneUI, Component component) {
        plasticTabbedPaneUI.setVisibleComponent(component);
    }

    static final JTabbedPane access$9200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final void access$9300(PlasticTabbedPaneUI plasticTabbedPaneUI, Component component) {
        plasticTabbedPaneUI.setVisibleComponent(component);
    }

    static final JTabbedPane access$9400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$9500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final int access$9600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$9700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$9800(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, int n3) {
        return plasticTabbedPaneUI.calculateTabAreaWidth(n, n2, n3);
    }

    static final int access$9900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$10000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$10100(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, int n3) {
        return plasticTabbedPaneUI.calculateTabAreaWidth(n, n2, n3);
    }

    static final int access$10200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$10300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$10400(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, int n3) {
        return plasticTabbedPaneUI.calculateTabAreaHeight(n, n2, n3);
    }

    static final int access$10500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$10600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$10700(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, int n3) {
        return plasticTabbedPaneUI.calculateTabAreaHeight(n, n2, n3);
    }

    static final JTabbedPane access$10800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final Rectangle[] access$10900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$11000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$11100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$11200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$11300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$11400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$11500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$11600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final boolean access$11700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.requestFocusForVisibleComponent();
    }

    static final JTabbedPane access$11800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final FontMetrics access$11900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getFontMetrics();
    }

    static final JTabbedPane access$12000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$12100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$12200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$12300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final int access$12402(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabWidth = n;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$12500(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n);
    }

    static final int access$12602(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabHeight = n;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$12700(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n);
    }

    static final int access$12802(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.runCount = n;
        return plasticTabbedPaneUI.runCount;
    }

    static final int access$12902(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.selectedRun = n;
        return plasticTabbedPaneUI.selectedRun;
    }

    static final int access$13002(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.selectedRun = n;
        return plasticTabbedPaneUI.selectedRun;
    }

    static final int access$13102(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.runCount = n;
        return plasticTabbedPaneUI.runCount;
    }

    static final Rectangle[] access$13200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$13300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$13400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final int[] access$13500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int access$13602(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabWidth = n;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$13700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$13800(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, FontMetrics fontMetrics) {
        return plasticTabbedPaneUI.calculateTabWidth(n, n2, fontMetrics);
    }

    static final int access$13902(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabWidth = n;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$14000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$14100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final Rectangle[] access$14200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$14300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final int[] access$14400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    static final int access$14502(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabHeight = n;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$14600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final int access$14700(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2, int n3) {
        return plasticTabbedPaneUI.calculateTabHeight(n, n2, n3);
    }

    static final int access$14802(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        plasticTabbedPaneUI.maxTabHeight = n;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$14900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    static final int access$15000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    static final Rectangle[] access$15100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$15200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$15300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final JTabbedPane access$15400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$15500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$15600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$15700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$15800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final Rectangle[] access$15900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$16000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final JTabbedPane access$16100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$16200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final int access$16300(PlasticTabbedPaneUI plasticTabbedPaneUI, int n, int n2) {
        return plasticTabbedPaneUI.getClosestTab(n, n2);
    }

    static final Rectangle[] access$16400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final Rectangle[] access$16500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    static final JTabbedPane access$16600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$16700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$16800(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$16900(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17000(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17100(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17200(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17300(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17400(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17500(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17600(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    static final JTabbedPane access$17700(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }
}

