/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxButton$1;
import com.jgoodies.looks.plastic.PlasticComboBoxUI;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

final class PlasticComboBoxButton
extends JButton {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private JComboBox comboBox;
    private Icon comboIcon;
    private boolean iconOnly = false;
    private boolean borderPaintsFocus;

    PlasticComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        super("");
        this.setModel(new PlasticComboBoxButton$1(this));
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.iconOnly = bl;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(jComboBox.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(jComboBox.isEnabled());
        this.setBorder(UIManager.getBorder("ComboBox.arrowButtonBorder"));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.borderPaintsFocus = UIManager.getBoolean("ComboBox.borderPaintsFocus");
    }

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public final boolean isFocusTraversable() {
        return false;
    }

    public final void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        boolean bl = PlasticUtils.isLeftToRight(this.comboBox);
        Insets insets = this.getInsets();
        int n4 = this.getWidth() - (insets.left + insets.right);
        int n5 = this.getHeight() - (insets.top + insets.bottom);
        if (n5 <= 0 || n4 <= 0) {
            return;
        }
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n6 + (n4 - 1);
        int n9 = 0;
        int n10 = n3 = bl ? n8 : n6;
        if (this.comboIcon != null) {
            n9 = this.comboIcon.getIconWidth();
            n2 = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                n3 = (this.getWidth() - n9) / 2;
                n = (this.getHeight() - n2) / 2;
            } else {
                n3 = bl ? n6 + (n4 - 1) - n9 : n6;
                n = (this.getHeight() - n2) / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n3, n);
        }
        if (!this.iconOnly && this.comboBox != null) {
            Serializable serializable;
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            n = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, n != 0, false);
            int n11 = bl ? n6 : n6 + n9;
            int n12 = n7;
            int n13 = this.getWidth() - n6 - PlasticComboBoxUI.getEditableButtonWidth();
            int n14 = n5;
            Border border = null;
            if (component instanceof JComponent && !this.isTableCellEditor()) {
                JComponent jComponent = (JComponent)component;
                if (component instanceof BasicComboBoxRenderer.UIResource) {
                    border = jComponent.getBorder();
                    jComponent.setBorder(EMPTY_BORDER);
                }
                serializable = jComponent.getInsets();
                Insets insets2 = UIManager.getInsets("ComboBox.editorInsets");
                int n15 = Math.max(0, insets2.top - ((Insets)serializable).top);
                int n16 = Math.max(0, insets2.bottom - ((Insets)serializable).bottom);
                n12 += n15;
                n14 -= n15 + n16;
            }
            component.setFont(this.rendererPane.getFont());
            this.configureColors(component);
            boolean bl2 = component instanceof JPanel;
            if (!(this.is3D() && component instanceof JComponent && component.isOpaque())) {
                this.rendererPane.paintComponent(graphics, component, this, n11, n12, n13, n14, bl2);
            } else {
                serializable = (JComponent)component;
                boolean bl3 = ((JComponent)serializable).isOpaque();
                ((JComponent)serializable).setOpaque(false);
                this.rendererPane.paintComponent(graphics, component, this, n11, n12, n13, n14, bl2);
                ((JComponent)serializable).setOpaque(bl3);
            }
            if (border != null) {
                ((JComponent)component).setBorder(border);
            }
        }
        if (this.comboIcon != null) {
            n2 = this.comboBox.hasFocus() ? 1 : 0;
            if (!this.borderPaintsFocus && n2 != 0) {
                graphics.setColor(PlasticLookAndFeel.getFocusColor());
                graphics.drawRect(2, 2, this.getWidth() - 6, this.getHeight() - 6);
            }
        }
    }

    private void configureColors(Component component) {
        if (this.model.isArmed() && this.model.isPressed()) {
            if (this.isOpaque()) {
                component.setBackground(UIManager.getColor("Button.select"));
            }
            component.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        } else {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        }
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.comboBox)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.comboBox)) {
            return false;
        }
        return PlasticUtils.is3D("ComboBox.");
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty("JComboBox.isTableCellEditor"));
    }
}

