/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.ConstantSize$Unit;
import com.jgoodies.forms.layout.FormLayout$Measure;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;

public final class ConstantSize
implements Size,
Serializable {
    public static final ConstantSize$Unit PIXEL = new ConstantSize$Unit("Pixel", "px", true, null);
    public static final ConstantSize$Unit POINT = new ConstantSize$Unit("Point", "pt", true, null);
    public static final ConstantSize$Unit DIALOG_UNITS_X;
    public static final ConstantSize$Unit DLUX;
    public static final ConstantSize$Unit DIALOG_UNITS_Y;
    public static final ConstantSize$Unit DLUY;
    public static final ConstantSize$Unit MILLIMETER;
    public static final ConstantSize$Unit MM;
    public static final ConstantSize$Unit CENTIMETER;
    public static final ConstantSize$Unit CM;
    public static final ConstantSize$Unit INCH;
    public static final ConstantSize$Unit IN;
    private static final ConstantSize$Unit[] VALUES;
    private final double value;
    private final ConstantSize$Unit unit;

    ConstantSize(int n, ConstantSize$Unit constantSize$Unit) {
        this.value = n;
        this.unit = constantSize$Unit;
    }

    ConstantSize(double d2, ConstantSize$Unit constantSize$Unit) {
        this.value = d2;
        this.unit = constantSize$Unit;
    }

    static ConstantSize valueOf(String string, boolean bl) {
        String[] stringArray = ConstantSize.splitValueAndUnit(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        ConstantSize$Unit constantSize$Unit = ConstantSize$Unit.valueOf(string3, bl);
        double d2 = Double.parseDouble(string2);
        if (constantSize$Unit.requiresIntegers && d2 != (double)((int)d2)) {
            throw new IllegalArgumentException(constantSize$Unit.toString() + " value " + string2 + " must be an integer.");
        }
        return new ConstantSize(d2, constantSize$Unit);
    }

    static ConstantSize dluX(int n) {
        return new ConstantSize(n, DLUX);
    }

    static ConstantSize dluY(int n) {
        return new ConstantSize(n, DLUY);
    }

    public int getPixelSize(Component component) {
        if (this.unit == PIXEL) {
            return this.intValue();
        }
        if (this.unit == POINT) {
            return Sizes.pointAsPixel(this.intValue(), component);
        }
        if (this.unit == INCH) {
            return Sizes.inchAsPixel(this.value, component);
        }
        if (this.unit == MILLIMETER) {
            return Sizes.millimeterAsPixel(this.value, component);
        }
        if (this.unit == CENTIMETER) {
            return Sizes.centimeterAsPixel(this.value, component);
        }
        if (this.unit == DIALOG_UNITS_X) {
            return Sizes.dialogUnitXAsPixel(this.intValue(), component);
        }
        if (this.unit == DIALOG_UNITS_Y) {
            return Sizes.dialogUnitYAsPixel(this.intValue(), component);
        }
        throw new IllegalStateException("Invalid unit " + this.unit);
    }

    public int maximumSize(Container container, List list, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2, FormLayout$Measure formLayout$Measure3) {
        return this.getPixelSize(container);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstantSize)) {
            return false;
        }
        ConstantSize constantSize = (ConstantSize)object;
        return this.value == constantSize.value && this.unit == constantSize.unit;
    }

    public int hashCode() {
        return new Double(this.value).hashCode() + 37 * this.unit.hashCode();
    }

    public String toString() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.abbreviation() : Double.toString(this.value) + this.unit.abbreviation();
    }

    private int intValue() {
        return (int)Math.round(this.value);
    }

    static String[] splitValueAndUnit(String string) {
        int n;
        int n2;
        String[] stringArray = new String[2];
        for (n2 = n = string.length(); n2 > 0 && Character.isLetter(string.charAt(n2 - 1)); --n2) {
        }
        stringArray[0] = string.substring(0, n2);
        stringArray[1] = string.substring(n2);
        return stringArray;
    }

    static ConstantSize$Unit[] access$100() {
        return VALUES;
    }

    static {
        DLUX = DIALOG_UNITS_X = new ConstantSize$Unit("Dialog units X", "dluX", true, null);
        DLUY = DIALOG_UNITS_Y = new ConstantSize$Unit("Dialog units Y", "dluY", true, null);
        MM = MILLIMETER = new ConstantSize$Unit("Millimeter", "mm", false, null);
        CM = CENTIMETER = new ConstantSize$Unit("Centimeter", "cm", false, null);
        IN = INCH = new ConstantSize$Unit("Inch", "in", false, null);
        VALUES = new ConstantSize$Unit[]{PIXEL, POINT, DIALOG_UNITS_X, DIALOG_UNITS_Y, MILLIMETER, CENTIMETER, INCH};
    }
}

