/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.internal;

import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.util.debug.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPActiveDataSocket
implements FTPDataSocket {
    public static String cvsId = "@(#)$Id: FTPActiveDataSocket.java,v 1.4 2009-09-02 22:02:24 bruceb Exp $";
    private static Logger log = Logger.getLogger("FTPActiveDataSocket");
    protected ServerSocket sock = null;
    protected Socket acceptedSock = null;
    protected int sendBufferSize = 0;
    private InetAddress localAddress = null;

    public FTPActiveDataSocket(ServerSocket serverSocket) {
        this.sock = serverSocket;
    }

    public final void setTimeout(int n) {
        this.sock.setSoTimeout(n);
        if (this.acceptedSock != null) {
            this.acceptedSock.setSoTimeout(n);
        }
    }

    public final void setReceiveBufferSize(int n) {
        this.sock.setReceiveBufferSize(n);
        if (this.acceptedSock != null) {
            this.acceptedSock.setReceiveBufferSize(n);
        }
    }

    public final void setSendBufferSize(int n) {
        this.sendBufferSize = n;
        if (this.acceptedSock != null) {
            this.acceptedSock.setSendBufferSize(n);
        }
    }

    public final int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public final InetAddress getLocalAddress() {
        if (this.localAddress != null) {
            return this.localAddress;
        }
        return this.sock.getInetAddress();
    }

    public final void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    protected final void acceptConnection() {
        log.debug("Calling accept()");
        this.acceptedSock = this.sock.accept();
        this.acceptedSock.setSoTimeout(this.sock.getSoTimeout());
        this.acceptedSock.setReceiveBufferSize(this.sock.getReceiveBufferSize());
        if (this.sendBufferSize > 0) {
            this.acceptedSock.setSendBufferSize(this.sendBufferSize);
        }
        log.debug("accept() succeeded");
    }

    public final OutputStream getOutputStream() {
        this.acceptConnection();
        return this.acceptedSock.getOutputStream();
    }

    public final InputStream getInputStream() {
        this.acceptConnection();
        return this.acceptedSock.getInputStream();
    }

    public final void close() {
        this.closeChild();
        this.sock.close();
        log.debug("close() succeeded");
    }

    public final void closeChild() {
        if (this.acceptedSock != null) {
            this.acceptedSock.close();
            this.acceptedSock = null;
            log.debug("closeChild() succeeded");
        }
    }
}

