/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.internal;

import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.TransferDirection;

public class EventAggregator
implements FTPMessageListener,
FTPProgressMonitor,
FTPProgressMonitorEx {
    private EventListener eventListener;
    private String connId;
    private String remoteFile;

    public EventAggregator(EventListener eventListener) {
        this(null, eventListener);
    }

    public EventAggregator(String string, EventListener eventListener) {
        this.connId = string;
        this.eventListener = eventListener;
    }

    public final void setConnId(String string) {
        this.connId = string;
    }

    public final void logCommand(String string) {
        if (this.eventListener != null) {
            this.eventListener.commandSent(this.connId, string);
        }
    }

    public final void logReply(String string) {
        if (this.eventListener != null) {
            this.eventListener.replyReceived(this.connId, string);
        }
    }

    public final void bytesTransferred(long l2) {
        if (this.eventListener != null) {
            this.eventListener.bytesTransferred(this.connId, this.remoteFile, l2);
        }
    }

    public final void transferComplete(TransferDirection transferDirection, String string) {
        if (this.eventListener != null) {
            if (transferDirection.equals(TransferDirection.DOWNLOAD)) {
                this.eventListener.downloadCompleted(this.connId, string);
            } else if (transferDirection.equals(TransferDirection.UPLOAD)) {
                this.eventListener.uploadCompleted(this.connId, string);
            }
        }
    }

    public final void transferStarted(TransferDirection transferDirection, String string) {
        this.remoteFile = string;
        if (this.eventListener != null) {
            if (transferDirection.equals(TransferDirection.DOWNLOAD)) {
                this.eventListener.downloadStarted(this.connId, string);
            } else if (transferDirection.equals(TransferDirection.UPLOAD)) {
                this.eventListener.uploadStarted(this.connId, string);
            }
        }
    }
}

