/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class MLSXEntryParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: MLSXEntryParser.java,v 1.2 2011-03-18 06:28:16 bruceb Exp $";
    private static final String SIZE = "Size";
    private static final String MODIFY = "Modify";
    private static final String CREATE = "Create";
    private static final String TYPE = "Type";
    private static final String UNIQUE = "Unique";
    private static final String PERM = "Perm";
    private static final String LANG = "Lang";
    private static final String MEDIA_TYPE = "Media-Type";
    private static final String CHARSET = "CharSet";
    private static final String FILE_TYPE = "file";
    private static final String LISTED_DIR_TYPE = "cdir";
    private static final String PARENT_DIR_TYPE = "pdir";
    private static final String SUB_DIR_TYPE = "dir";
    private SimpleDateFormat tsFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleDateFormat tsFormat2 = new SimpleDateFormat("yyyyMMddHHmmss.SSS");

    public MLSXEntryParser() {
        this.tsFormat1.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.tsFormat2.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final FTPFile parse(String string) {
        String[] stringArray = this.split(string, ';');
        String string2 = null;
        FTPFile fTPFile = new FTPFile(string);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2];
            if (i2 + 1 == stringArray.length) {
                string2 = string3.trim();
                String string4 = string2;
                int n = string4.lastIndexOf(47);
                if (n >= 0) {
                    string2 = string4.substring(0, n);
                    fTPFile.setPath(string2);
                    string4 = string4.substring(++n);
                }
                fTPFile.setName(string4);
                continue;
            }
            int n = string3.indexOf(61);
            if (n <= 0) continue;
            String string5 = string3.substring(0, n);
            String string6 = string3.substring(++n);
            if (string5.equalsIgnoreCase(SIZE)) {
                fTPFile.setSize(this.parseSize(string6));
                continue;
            }
            if (string5.equalsIgnoreCase(MODIFY)) {
                fTPFile.setLastModified(this.parseDate(string6));
                continue;
            }
            if (string5.equalsIgnoreCase(TYPE)) {
                if (string6.equalsIgnoreCase(FILE_TYPE)) {
                    fTPFile.setDir(false);
                    continue;
                }
                fTPFile.setDir(true);
                continue;
            }
            if (string5.equalsIgnoreCase(PERM)) {
                fTPFile.setPermissions(string6);
                continue;
            }
            if (!string5.equalsIgnoreCase(CREATE)) continue;
            fTPFile.setCreated(this.parseDate(string6));
        }
        return fTPFile;
    }

    private long parseSize(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Failed to parse size: " + string, 0);
        }
    }

    private Date parseDate(String string) {
        try {
            return this.tsFormat1.parse(string);
        }
        catch (ParseException parseException) {
            return this.tsFormat2.parse(string);
        }
    }

    public final void setLocale(Locale locale) {
    }
}

