/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FTPOutputStream
extends FileTransferOutputStream {
    private static Logger log = Logger.getLogger("FTPOutputStream");
    private long monitorInterval;
    private FTPClient client;
    private BufferedOutputStream out;
    private boolean isASCII = false;
    private long monitorCount = 0L;
    private FTPProgressMonitor monitor;
    private FTPProgressMonitorEx monitorEx;
    private byte[] prevBuf = new byte[FTPClient.FTP_LINE_SEPARATOR.length];
    private int matchpos = 0;

    public FTPOutputStream(FTPClient fTPClient, String string) {
        this(fTPClient, string, false);
    }

    public FTPOutputStream(FTPClient fTPClient, String string, boolean bl) {
        this.client = fTPClient;
        this.remoteFile = string;
        try {
            this.remoteFile = fTPClient.initPut(string, bl);
            this.out = new BufferedOutputStream(new DataOutputStream(fTPClient.getOutputStream()), fTPClient.getTransferBufferSize() * 2);
        }
        catch (IOException iOException) {
            fTPClient.validateTransferOnError(iOException);
            throw iOException;
        }
        this.monitorInterval = fTPClient.getMonitorInterval();
        this.monitor = fTPClient.getProgressMonitor();
        this.isASCII = fTPClient.getType().equals(FTPTransferType.ASCII);
    }

    public final void setMonitor(FTPProgressMonitorEx fTPProgressMonitorEx, long l2) {
        this.monitor = fTPProgressMonitorEx;
        this.monitorEx = fTPProgressMonitorEx;
        this.monitorInterval = l2;
    }

    public final void write(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public final void write(byte[] byArray, int n, int n2) {
        if (this.isASCII) {
            for (int i2 = n; i2 < n + n2; ++i2) {
                if (byArray[i2] == 10 && this.matchpos == 0) {
                    this.out.write(13);
                    this.out.write(10);
                    this.size += 2L;
                    this.monitorCount += 2L;
                    continue;
                }
                if (byArray[i2] == FTPClient.FTP_LINE_SEPARATOR[this.matchpos]) {
                    this.prevBuf[this.matchpos] = byArray[i2];
                    ++this.matchpos;
                    if (this.matchpos != FTPClient.FTP_LINE_SEPARATOR.length) continue;
                    this.out.write(13);
                    this.out.write(10);
                    this.size += 2L;
                    this.monitorCount += 2L;
                    this.matchpos = 0;
                    continue;
                }
                if (this.matchpos > 0) {
                    this.out.write(13);
                    this.out.write(10);
                    this.size += 2L;
                    this.monitorCount += 2L;
                }
                this.out.write(byArray[i2]);
                ++this.size;
                ++this.monitorCount;
                this.matchpos = 0;
            }
        } else {
            this.out.write(byArray, n, n2);
            this.size += (long)n2;
            this.monitorCount += (long)n2;
        }
        if (this.monitor != null && this.monitorCount > this.monitorInterval) {
            this.monitor.bytesTransferred(this.size);
            this.monitorCount = 0L;
        }
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.isASCII && this.matchpos > 0) {
                this.out.write(this.prevBuf, 0, this.matchpos);
                this.size += (long)this.matchpos;
                this.monitorCount += (long)this.matchpos;
            }
            this.client.forceResumeOff();
            this.client.closeDataSocket(this.out);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(this.size);
            }
            log.debug("Transferred " + this.size + " bytes from remote host");
            try {
                this.client.validateTransfer();
            }
            catch (FTPException fTPException) {
                throw new IOException(fTPException.getMessage());
            }
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, this.remoteFile);
            }
        }
    }
}

