/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AbstractFTPInputStream;
import com.enterprisedt.net.ftp.FTPClient;
import java.io.ByteArrayOutputStream;

class FTPASCIIInputStream
extends AbstractFTPInputStream {
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    private byte[] buffer;
    private int bufpos = 0;
    private int buflen = 0;
    private byte[] chunk;
    private byte[] prevBuf = new byte[FTPClient.FTP_LINE_SEPARATOR.length];
    private int matchpos = 0;
    private ByteArrayOutputStream out;

    public FTPASCIIInputStream(FTPClient fTPClient, String string) {
        this(fTPClient, string, 0L);
    }

    public FTPASCIIInputStream(FTPClient fTPClient, String string, long l2) {
        super(fTPClient, string);
        this.chunk = new byte[fTPClient.getTransferBufferSize()];
        this.out = new ByteArrayOutputStream(fTPClient.getTransferBufferSize());
    }

    public final int read() {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        return 0xFF & this.buffer[this.bufpos++];
    }

    public final int read(byte[] byArray, int n, int n2) {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null || n2 == 0) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        int n3 = 0;
        int n4 = n2;
        while ((n3 = this.buflen - this.bufpos) < n4) {
            System.arraycopy(this.buffer, this.bufpos, byArray, n, n3);
            n4 -= n3;
            n += n3;
            this.buffer = this.refreshBuffer();
            if (this.buffer != null) continue;
            return n2 - n4;
        }
        System.arraycopy(this.buffer, this.bufpos, byArray, n, n4);
        this.bufpos += n4;
        return n2;
    }

    protected final void start() {
        super.start();
        this.buffer = this.refreshBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] refreshBuffer() {
        byte[] byArray;
        this.bufpos = 0;
        if (this.client.isTransferCancelled()) {
            return null;
        }
        int n = this.client.readChunk(this.in, this.chunk, this.chunk.length);
        if (n < 0) {
            if (this.matchpos > 0) {
                this.pos += (long)this.matchpos;
                this.buflen = this.matchpos;
                this.monitorCount += (long)this.matchpos;
                byte[] byArray2 = new byte[this.matchpos];
                System.arraycopy(byArray2, 0, this.prevBuf, 0, this.matchpos);
                this.matchpos = 0;
                return byArray2;
            }
            return null;
        }
        try {
            this.out.reset();
            for (int i2 = 0; i2 < n; ++i2) {
                if (this.chunk[i2] == FTPClient.FTP_LINE_SEPARATOR[this.matchpos]) {
                    this.prevBuf[this.matchpos] = this.chunk[i2];
                    ++this.matchpos;
                    if (this.matchpos != FTPClient.FTP_LINE_SEPARATOR.length) continue;
                    this.out.write(LINE_SEPARATOR);
                    this.pos += (long)LINE_SEPARATOR.length;
                    this.monitorCount += (long)LINE_SEPARATOR.length;
                    this.matchpos = 0;
                    continue;
                }
                if (this.matchpos > 0) {
                    this.out.write(this.prevBuf, 0, this.matchpos);
                    this.pos += (long)this.matchpos;
                    this.monitorCount += (long)this.matchpos;
                }
                this.out.write(this.chunk[i2]);
                ++this.pos;
                ++this.monitorCount;
                this.matchpos = 0;
            }
            byte[] byArray3 = this.out.toByteArray();
            this.buflen = byArray3.length;
            byArray = byArray3;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.checkMonitor();
            throw throwable;
        }
        this.checkMonitor();
        return byArray;
    }
}

