/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class SingularValueDecomposition
implements Serializable {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(Matrix matrix) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double[][] dArray = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        int n7 = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][n7];
        this.V = new double[this.n][this.n];
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.m];
        boolean bl = true;
        boolean bl2 = true;
        int n8 = Math.min(this.m - 1, this.n);
        int n9 = Math.max(0, Math.min(this.n - 2, this.m));
        int n10 = 0;
        while (n10 < Math.max(n8, n9)) {
            if (n10 < n8) {
                this.s[n10] = 0.0;
                n6 = n10;
                while (n6 < this.m) {
                    this.s[n10] = Maths.hypot(this.s[n10], dArray[n6][n10]);
                    ++n6;
                }
                if (this.s[n10] != 0.0) {
                    if (dArray[n10][n10] < 0.0) {
                        this.s[n10] = -this.s[n10];
                    }
                    int n11 = n10;
                    while (n11 < this.m) {
                        double[] dArray4 = dArray[n11];
                        int n12 = n10;
                        dArray4[n12] = dArray4[n12] / this.s[n10];
                        ++n11;
                    }
                    double[] dArray5 = dArray[n10];
                    int n13 = n10;
                    dArray5[n13] = dArray5[n13] + 1.0;
                }
                this.s[n10] = -this.s[n10];
            }
            n6 = n10 + 1;
            while (n6 < this.n) {
                if (n10 < n8 & this.s[n10] != 0.0) {
                    double d2 = 0.0;
                    n5 = n10;
                    while (n5 < this.m) {
                        d2 += dArray[n5][n10] * dArray[n5][n6];
                        ++n5;
                    }
                    d2 = -d2 / dArray[n10][n10];
                    n4 = n10;
                    while (n4 < this.m) {
                        double[] dArray6 = dArray[n4];
                        int n14 = n6;
                        dArray6[n14] = dArray6[n14] + d2 * dArray[n4][n10];
                        ++n4;
                    }
                }
                dArray2[n6] = dArray[n10][n6];
                ++n6;
            }
            if (bl & n10 < n8) {
                int n15 = n10;
                while (n15 < this.m) {
                    this.U[n15][n10] = dArray[n15][n10];
                    ++n15;
                }
            }
            if (n10 < n9) {
                dArray2[n10] = 0.0;
                int n16 = n10 + 1;
                while (n16 < this.n) {
                    dArray2[n10] = Maths.hypot(dArray2[n10], dArray2[n16]);
                    ++n16;
                }
                if (dArray2[n10] != 0.0) {
                    if (dArray2[n10 + 1] < 0.0) {
                        dArray2[n10] = -dArray2[n10];
                    }
                    n3 = n10 + 1;
                    while (n3 < this.n) {
                        int n17 = n3++;
                        dArray2[n17] = dArray2[n17] / dArray2[n10];
                    }
                    int n18 = n10 + 1;
                    dArray2[n18] = dArray2[n18] + 1.0;
                }
                dArray2[n10] = -dArray2[n10];
                if (n10 + 1 < this.m & dArray2[n10] != 0.0) {
                    n3 = n10 + 1;
                    while (n3 < this.m) {
                        dArray3[n3] = 0.0;
                        ++n3;
                    }
                    n5 = n10 + 1;
                    while (n5 < this.n) {
                        n4 = n10 + 1;
                        while (n4 < this.m) {
                            int n19 = n4;
                            dArray3[n19] = dArray3[n19] + dArray2[n5] * dArray[n4][n5];
                            ++n4;
                        }
                        ++n5;
                    }
                    n4 = n10 + 1;
                    while (n4 < this.n) {
                        double d3 = -dArray2[n4] / dArray2[n10 + 1];
                        n2 = n10 + 1;
                        while (n2 < this.m) {
                            double[] dArray7 = dArray[n2];
                            int n20 = n4;
                            dArray7[n20] = dArray7[n20] + d3 * dArray3[n2];
                            ++n2;
                        }
                        ++n4;
                    }
                }
                if (bl2) {
                    n3 = n10 + 1;
                    while (n3 < this.n) {
                        this.V[n3][n10] = dArray2[n3];
                        ++n3;
                    }
                }
            }
            ++n10;
        }
        n6 = Math.min(this.n, this.m + 1);
        if (n8 < this.n) {
            this.s[n8] = dArray[n8][n8];
        }
        if (this.m < n6) {
            this.s[n6 - 1] = 0.0;
        }
        if (n9 + 1 < n6) {
            dArray2[n9] = dArray[n9][n6 - 1];
        }
        dArray2[n6 - 1] = 0.0;
        if (bl) {
            int n21 = n8;
            while (n21 < n7) {
                n3 = 0;
                while (n3 < this.m) {
                    this.U[n3][n21] = 0.0;
                    ++n3;
                }
                this.U[n21][n21] = 1.0;
                ++n21;
            }
            n3 = n8 - 1;
            while (n3 >= 0) {
                if (this.s[n3] != 0.0) {
                    n5 = n3 + 1;
                    while (n5 < n7) {
                        double d4 = 0.0;
                        n = n3;
                        while (n < this.m) {
                            d4 += this.U[n][n3] * this.U[n][n5];
                            ++n;
                        }
                        d4 = -d4 / this.U[n3][n3];
                        n2 = n3;
                        while (n2 < this.m) {
                            double[] dArray8 = this.U[n2];
                            int n22 = n5;
                            dArray8[n22] = dArray8[n22] + d4 * this.U[n2][n3];
                            ++n2;
                        }
                        ++n5;
                    }
                    n4 = n3;
                    while (n4 < this.m) {
                        this.U[n4][n3] = -this.U[n4][n3];
                        ++n4;
                    }
                    this.U[n3][n3] = 1.0 + this.U[n3][n3];
                    int n23 = 0;
                    while (n23 < n3 - 1) {
                        this.U[n23][n3] = 0.0;
                        ++n23;
                    }
                } else {
                    n5 = 0;
                    while (n5 < this.m) {
                        this.U[n5][n3] = 0.0;
                        ++n5;
                    }
                    this.U[n3][n3] = 1.0;
                }
                --n3;
            }
        }
        if (bl2) {
            int n24 = this.n - 1;
            while (n24 >= 0) {
                if (n24 < n9 & dArray2[n24] != 0.0) {
                    n3 = n24 + 1;
                    while (n3 < n7) {
                        double d5 = 0.0;
                        int n25 = n24 + 1;
                        while (n25 < this.n) {
                            d5 += this.V[n25][n24] * this.V[n25][n3];
                            ++n25;
                        }
                        d5 = -d5 / this.V[n24 + 1][n24];
                        n = n24 + 1;
                        while (n < this.n) {
                            double[] dArray9 = this.V[n];
                            int n26 = n3;
                            dArray9[n26] = dArray9[n26] + d5 * this.V[n][n24];
                            ++n;
                        }
                        ++n3;
                    }
                }
                n3 = 0;
                while (n3 < this.n) {
                    this.V[n3][n24] = 0.0;
                    ++n3;
                }
                this.V[n24][n24] = 1.0;
                --n24;
            }
        }
        int n27 = n6 - 1;
        n3 = 0;
        double d6 = Math.pow(2.0, -52.0);
        block35: while (n6 > 0) {
            int n28 = n6 - 2;
            while (n28 >= -1) {
                if (n28 == -1) break;
                if (Math.abs(dArray2[n28]) <= d6 * (Math.abs(this.s[n28]) + Math.abs(this.s[n28 + 1]))) {
                    dArray2[n28] = 0.0;
                    break;
                }
                --n28;
            }
            if (n28 == n6 - 2) {
                n = 4;
            } else {
                int n29 = n6 - 1;
                while (n29 >= n28) {
                    if (n29 == n28) break;
                    double d7 = (n29 != n6 ? Math.abs(dArray2[n29]) : 0.0) + (n29 != n28 + 1 ? Math.abs(dArray2[n29 - 1]) : 0.0);
                    if (Math.abs(this.s[n29]) <= d6 * d7) {
                        this.s[n29] = 0.0;
                        break;
                    }
                    --n29;
                }
                if (n29 == n28) {
                    n = 3;
                } else if (n29 == n6 - 1) {
                    n = 1;
                } else {
                    n = 2;
                    n28 = n29;
                }
            }
            ++n28;
            switch (n) {
                case 1: {
                    int n30;
                    double d8;
                    double d9;
                    double d10;
                    double d11 = dArray2[n6 - 2];
                    dArray2[n6 - 2] = 0.0;
                    int n31 = n6 - 2;
                    while (n31 >= n28) {
                        d10 = Maths.hypot(this.s[n31], d11);
                        d9 = this.s[n31] / d10;
                        d8 = d11 / d10;
                        this.s[n31] = d10;
                        if (n31 != n28) {
                            d11 = -d8 * dArray2[n31 - 1];
                            dArray2[n31 - 1] = d9 * dArray2[n31 - 1];
                        }
                        if (bl2) {
                            n30 = 0;
                            while (n30 < this.n) {
                                d10 = d9 * this.V[n30][n31] + d8 * this.V[n30][n6 - 1];
                                this.V[n30][n6 - 1] = -d8 * this.V[n30][n31] + d9 * this.V[n30][n6 - 1];
                                this.V[n30][n31] = d10;
                                ++n30;
                            }
                        }
                        --n31;
                    }
                    continue block35;
                }
                case 2: {
                    int n30;
                    double d8;
                    double d9;
                    double d10;
                    double d12 = dArray2[n28 - 1];
                    dArray2[n28 - 1] = 0.0;
                    int n32 = n28;
                    while (n32 < n6) {
                        d10 = Maths.hypot(this.s[n32], d12);
                        d9 = this.s[n32] / d10;
                        d8 = d12 / d10;
                        this.s[n32] = d10;
                        d12 = -d8 * dArray2[n32];
                        dArray2[n32] = d9 * dArray2[n32];
                        if (bl) {
                            n30 = 0;
                            while (n30 < this.m) {
                                d10 = d9 * this.U[n30][n32] + d8 * this.U[n30][n28 - 1];
                                this.U[n30][n28 - 1] = -d8 * this.U[n30][n32] + d9 * this.U[n30][n28 - 1];
                                this.U[n30][n32] = d10;
                                ++n30;
                            }
                        }
                        ++n32;
                    }
                    continue block35;
                }
                case 3: {
                    double d13 = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[n6 - 1]), Math.abs(this.s[n6 - 2])), Math.abs(dArray2[n6 - 2])), Math.abs(this.s[n28])), Math.abs(dArray2[n28]));
                    double d14 = this.s[n6 - 1] / d13;
                    double d15 = this.s[n6 - 2] / d13;
                    double d16 = dArray2[n6 - 2] / d13;
                    double d17 = this.s[n28] / d13;
                    double d18 = dArray2[n28] / d13;
                    double d19 = ((d15 + d14) * (d15 - d14) + d16 * d16) / 2.0;
                    double d20 = d14 * d16 * (d14 * d16);
                    double d21 = 0.0;
                    if (d19 != 0.0 | d20 != 0.0) {
                        d21 = Math.sqrt(d19 * d19 + d20);
                        if (d19 < 0.0) {
                            d21 = -d21;
                        }
                        d21 = d20 / (d19 + d21);
                    }
                    double d22 = (d17 + d14) * (d17 - d14) + d21;
                    double d23 = d17 * d18;
                    int n33 = n28;
                    while (n33 < n6 - 1) {
                        int n34;
                        double d24 = Maths.hypot(d22, d23);
                        double d25 = d22 / d24;
                        double d26 = d23 / d24;
                        if (n33 != n28) {
                            dArray2[n33 - 1] = d24;
                        }
                        d22 = d25 * this.s[n33] + d26 * dArray2[n33];
                        dArray2[n33] = d25 * dArray2[n33] - d26 * this.s[n33];
                        d23 = d26 * this.s[n33 + 1];
                        this.s[n33 + 1] = d25 * this.s[n33 + 1];
                        if (bl2) {
                            n34 = 0;
                            while (n34 < this.n) {
                                d24 = d25 * this.V[n34][n33] + d26 * this.V[n34][n33 + 1];
                                this.V[n34][n33 + 1] = -d26 * this.V[n34][n33] + d25 * this.V[n34][n33 + 1];
                                this.V[n34][n33] = d24;
                                ++n34;
                            }
                        }
                        d24 = Maths.hypot(d22, d23);
                        d25 = d22 / d24;
                        d26 = d23 / d24;
                        this.s[n33] = d24;
                        d22 = d25 * dArray2[n33] + d26 * this.s[n33 + 1];
                        this.s[n33 + 1] = -d26 * dArray2[n33] + d25 * this.s[n33 + 1];
                        d23 = d26 * dArray2[n33 + 1];
                        dArray2[n33 + 1] = d25 * dArray2[n33 + 1];
                        if (bl && n33 < this.m - 1) {
                            n34 = 0;
                            while (n34 < this.m) {
                                d24 = d25 * this.U[n34][n33] + d26 * this.U[n34][n33 + 1];
                                this.U[n34][n33 + 1] = -d26 * this.U[n34][n33] + d25 * this.U[n34][n33 + 1];
                                this.U[n34][n33] = d24;
                                ++n34;
                            }
                        }
                        ++n33;
                    }
                    dArray2[n6 - 2] = d22;
                    ++n3;
                    break;
                }
                case 4: {
                    if (this.s[n28] <= 0.0) {
                        double d27 = this.s[n28] = this.s[n28] < 0.0 ? -this.s[n28] : 0.0;
                        if (bl2) {
                            int n35 = 0;
                            while (n35 <= n27) {
                                this.V[n35][n28] = -this.V[n35][n28];
                                ++n35;
                            }
                        }
                    }
                    while (n28 < n27) {
                        int n36;
                        if (this.s[n28] >= this.s[n28 + 1]) break;
                        double d28 = this.s[n28];
                        this.s[n28] = this.s[n28 + 1];
                        this.s[n28 + 1] = d28;
                        if (bl2 && n28 < this.n - 1) {
                            n36 = 0;
                            while (n36 < this.n) {
                                d28 = this.V[n36][n28 + 1];
                                this.V[n36][n28 + 1] = this.V[n36][n28];
                                this.V[n36][n28] = d28;
                                ++n36;
                            }
                        }
                        if (bl && n28 < this.m - 1) {
                            n36 = 0;
                            while (n36 < this.m) {
                                d28 = this.U[n36][n28 + 1];
                                this.U[n36][n28 + 1] = this.U[n36][n28];
                                this.U[n36][n28] = d28;
                                ++n36;
                            }
                        }
                        ++n28;
                    }
                    n3 = 0;
                    --n6;
                    break;
                }
            }
        }
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public Matrix getS() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = 0.0;
                ++n2;
            }
            dArray[n][n] = this.s[n];
            ++n;
        }
        return matrix;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public Matrix getU() {
        return new Matrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double norm2() {
        return this.s[0];
    }

    public int rank() {
        double d2 = Math.pow(2.0, -52.0);
        double d3 = (double)Math.max(this.m, this.n) * this.s[0] * d2;
        int n = 0;
        int n2 = 0;
        while (n2 < this.s.length) {
            if (this.s[n2] > d3) {
                ++n;
            }
            ++n2;
        }
        return n;
    }
}

